/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.StylePattern;
import freemind.modes.actions.NodeGeneralAction;
import freemind.modes.actions.SingleNodeOperation;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.util.ListIterator;

public class ApplyPatternAction
extends NodeGeneralAction
implements SingleNodeOperation {
    private StylePattern mpattern;

    public ApplyPatternAction(ModeController controller, StylePattern pattern) {
        super(controller, null, null);
        this.setName(pattern.getName());
        this.mpattern = pattern;
        this.setSingleNodeOperation(this);
    }

    public void apply(MindMapMapModel map, MindMapNodeModel node) {
        this.applyPattern(node, this.mpattern);
    }

    public void applyPattern(MindMapNode node, StylePattern pattern) {
        if (pattern.getAppliesToNode()) {
            if (pattern.getText() != null) {
                this.getModeController().setNodeText(node, pattern.getText());
            }
            this.getModeController().setNodeColor(node, pattern.getNodeColor());
            this.getModeController().setNodeBackgroundColor(node, pattern.getNodeBackgroundColor());
            if (pattern.getNodeStyle() != null) {
                this.getModeController().setNodeStyle(node, pattern.getNodeStyle());
            }
            if (pattern.getAppliesToNodeIcon()) {
                if (pattern.getNodeIcon() == null) {
                    while (this.getModeController().removeLastIcon(node) > 0) {
                    }
                } else {
                    this.getModeController().addIcon(node, pattern.getNodeIcon());
                }
            }
            if (pattern.getAppliesToNodeFont()) {
                String nodeFontFamily = pattern.getNodeFontFamily();
                if (nodeFontFamily == null) {
                    nodeFontFamily = this.getModeController().getController().getDefaultFontFamilyName();
                }
                this.getModeController().setFontFamily(node, nodeFontFamily);
                Integer nodeFontSize = pattern.getNodeFontSize();
                if (nodeFontSize == null) {
                    nodeFontSize = new Integer(this.getModeController().getController().getDefaultFontSize());
                }
                this.getModeController().setFontSize(node, String.valueOf(nodeFontSize));
                if (pattern.getNodeFontItalic() != null) {
                    this.getModeController().setItalic(node, pattern.getNodeFontItalic());
                } else {
                    this.getModeController().setItalic(node, false);
                }
                if (pattern.getNodeFontBold() != null) {
                    this.getModeController().setBold(node, pattern.getNodeFontBold());
                } else {
                    this.getModeController().setBold(node, false);
                }
            }
        }
        if (pattern.getAppliesToEdge()) {
            this.getModeController().setEdgeColor(node, pattern.getEdgeColor());
            this.getModeController().setEdgeStyle(node, pattern.getEdgeStyle());
            this.getModeController().setEdgeWidth(node, pattern.getEdgeWidth());
        }
        if (pattern.getAppliesToChildren()) {
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                NodeAdapter child = (NodeAdapter)i.next();
                this.applyPattern(child, pattern.getChildrenStylePattern());
            }
        }
    }

    public StylePattern getPattern() {
        return this.mpattern;
    }
}

