/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public abstract class EdgeAdapter
extends LineAdapter
implements MindMapEdge {
    private static Color standardColor = null;
    private static String standardStyle = null;
    private static LineAdapter.LineAdapterListener listener = null;
    public static final int WIDTH_PARENT = -1;
    public static final int WIDTH_THIN = 0;
    private static Color standardEdgeColor = new Color(0);

    public EdgeAdapter(MindMapNode target, FreeMindMain frame) {
        this(target, frame, "standardedgecolor", "standardedgestyle");
    }

    protected EdgeAdapter(MindMapNode target, FreeMindMain frame, String standardColorPropertyString, String standardStylePropertyString) {
        super(target, frame, standardColorPropertyString, standardStylePropertyString);
        this.NORMAL_WIDTH = -1;
        if (listener == null) {
            listener = new LineAdapter.LineAdapterListener(this);
            Controller.addPropertyChangeListener(listener);
        }
    }

    public Color getColor() {
        if (this.color == null) {
            if (this.getTarget().isRoot()) {
                return this.getStandardColor();
            }
            return this.getSource().getEdge().getColor();
        }
        return this.color;
    }

    public Color getRealColor() {
        return this.color;
    }

    public int getWidth() {
        if (this.width == -1) {
            if (this.getTarget().isRoot()) {
                return 0;
            }
            return this.getSource().getEdge().getWidth();
        }
        return this.width;
    }

    public Stroke getStroke() {
        if (this.width == 0) {
            return null;
        }
        if (this.stroke == null) {
            if (this.getTarget().isRoot()) {
                return null;
            }
            return this.getSource().getEdge().getStroke();
        }
        return this.stroke;
    }

    public void setWidth(int width) {
        this.width = width;
        this.stroke = width == -1 || width == 0 ? null : new BasicStroke(this.getWidth(), 0, 0);
    }

    public int getRealWidth() {
        return this.width;
    }

    public String getStyle() {
        if (this.style == null) {
            if (this.getTarget().isRoot()) {
                return this.getFrame().getProperty(this.standardStylePropertyString);
            }
            return this.getSource().getEdge().getStyle();
        }
        return this.style;
    }

    private MindMapNode getSource() {
        return this.target.getParentNode();
    }

    public XMLElement save() {
        if (this.style != null || this.color != null || this.width != -1) {
            XMLElement edge = new XMLElement();
            edge.setName("edge");
            if (this.style != null) {
                edge.setAttribute("STYLE", this.style);
            }
            if (this.color != null) {
                edge.setAttribute("COLOR", Tools.colorToXml(this.color));
            }
            if (this.width != -1) {
                if (this.width == 0) {
                    edge.setAttribute("WIDTH", "thin");
                } else {
                    edge.setAttribute("WIDTH", Integer.toString(this.width));
                }
            }
            return edge;
        }
        return null;
    }

    protected Color getStandardColor() {
        return standardColor;
    }

    protected void setStandardColor(Color standardColor) {
        EdgeAdapter.standardColor = standardColor;
    }

    protected String getStandardStyle() {
        return standardStyle;
    }

    protected void setStandardStyle(String standardStyle) {
        EdgeAdapter.standardStyle = standardStyle;
    }
}

