/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.extensions.ModeControllerHookAdapter;
import freemind.main.Tools;
import freemind.modes.NodeAdapter;
import freemind.view.mindmapview.MapView;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExportHook
extends ModeControllerHookAdapter {
    private MapView view;

    protected File chooseFile(String type, String description) {
        String overwriteText;
        int overwriteMap;
        Container component = this.getController().getFrame().getContentPane();
        JFileChooser chooser = null;
        chooser = new JFileChooser();
        File mmFile = this.getController().getMap().getFile();
        if (mmFile != null) {
            String proposedName = mmFile.getAbsolutePath().replaceFirst("\\.[^.]*?$", "") + "." + type;
            chooser.setSelectedFile(new File(proposedName));
        }
        chooser.addChoosableFileFilter(new ImageFilter(type, description));
        int returnVal = chooser.showSaveDialog(component);
        if (returnVal != 0) {
            return null;
        }
        File chosenFile = chooser.getSelectedFile();
        String ext = Tools.getExtension(chosenFile.getName());
        if (!Tools.safeEqualsIgnoreCase(ext, type)) {
            chosenFile = new File(chosenFile.getParent(), chosenFile.getName() + "." + type);
        }
        if (chosenFile.exists() && (overwriteMap = JOptionPane.showConfirmDialog(component, overwriteText = MessageFormat.format(this.getController().getText("file_already_exists"), chosenFile.toString()), overwriteText, 0)) != 0) {
            return null;
        }
        return chosenFile;
    }

    public BufferedImage createBufferedImage() {
        this.view = this.getController().getView();
        if (this.view == null) {
            return null;
        }
        NodeAdapter root = (NodeAdapter)this.getController().getMap().getRoot();
        Rectangle innerBounds = this.view.getInnerBounds(root.getViewer());
        BufferedImage myImage = (BufferedImage)this.view.createImage(this.view.getWidth(), this.view.getHeight());
        Graphics g = myImage.getGraphics();
        g.clipRect(innerBounds.x, innerBounds.y, innerBounds.width, innerBounds.height);
        this.view.print(g);
        myImage = myImage.getSubimage(innerBounds.x, innerBounds.y, innerBounds.width, innerBounds.height);
        return myImage;
    }

    public static class ImageFilter
    extends FileFilter {
        private String type;
        private final String description;

        public ImageFilter(String type, String description) {
            this.type = type;
            this.description = description;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Tools.getExtension(f.getName());
            return Tools.safeEqualsIgnoreCase(extension, this.type);
        }

        public String getDescription() {
            return this.description == null ? this.type : this.description;
        }
    }
}

