/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.engine.value.svg.OpacityManager;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.DomExtension;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.BatikHistogramNormalizationElement;
import org.apache.batik.extension.svg.BatikMultiImageElement;
import org.apache.batik.extension.svg.BatikRegularPolygonElement;
import org.apache.batik.extension.svg.BatikStarElement;
import org.apache.batik.extension.svg.ColorSwitchElement;
import org.apache.batik.extension.svg.FlowDivElement;
import org.apache.batik.extension.svg.FlowLineElement;
import org.apache.batik.extension.svg.FlowParaElement;
import org.apache.batik.extension.svg.FlowRegionBreakElement;
import org.apache.batik.extension.svg.FlowSpanElement;
import org.apache.batik.extension.svg.FlowTextElement;
import org.apache.batik.extension.svg.SolidColorElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BatikDomExtension
implements DomExtension,
BatikExtConstants {
    public float getPriority() {
        return 1.0f;
    }

    public String getAuthor() {
        return "Thomas DeWeese";
    }

    public String getContactAddress() {
        return "deweese@apache.org";
    }

    public String getURL() {
        return "http://xml.apache.org/batik";
    }

    public String getDescription() {
        return "Example extension to standard SVG shape tags";
    }

    public void registerTags(ExtensibleSVGDOMImplementation extensibleSVGDOMImplementation) {
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "regularPolygon", (SVGDOMImplementation.ElementFactory)new BatikRegularPolygonElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "star", (SVGDOMImplementation.ElementFactory)new BatikStarElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "histogramNormalization", (SVGDOMImplementation.ElementFactory)new BatikHistogramNormalizationElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "multiImage", (SVGDOMImplementation.ElementFactory)new BatikMultiImageElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "solidColor", (SVGDOMImplementation.ElementFactory)new SolidColorElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowText", (SVGDOMImplementation.ElementFactory)new FlowTextElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowDiv", (SVGDOMImplementation.ElementFactory)new FlowDivElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowPara", (SVGDOMImplementation.ElementFactory)new FlowParaElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowRegionBreak", (SVGDOMImplementation.ElementFactory)new FlowRegionBreakElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowLine", (SVGDOMImplementation.ElementFactory)new FlowLineElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowSpan", (SVGDOMImplementation.ElementFactory)new FlowSpanElementFactory());
        extensibleSVGDOMImplementation.registerCustomCSSValueManager((ValueManager)new SVGColorManager("solid-color"));
        extensibleSVGDOMImplementation.registerCustomCSSValueManager((ValueManager)new OpacityManager("solid-opacity", true));
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "colorSwitch", (SVGDOMImplementation.ElementFactory)new ColorSwitchElementFactory());
    }

    protected static class FlowSpanElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new FlowSpanElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowLineElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new FlowLineElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionBreakElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new FlowRegionBreakElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowParaElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new FlowParaElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowDivElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new FlowDivElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowTextElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new FlowTextElement(string, (AbstractDocument)document);
        }
    }

    protected static class ColorSwitchElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new ColorSwitchElement(string, (AbstractDocument)document);
        }
    }

    protected static class SolidColorElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SolidColorElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikMultiImageElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new BatikMultiImageElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikHistogramNormalizationElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new BatikHistogramNormalizationElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikStarElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new BatikStarElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikRegularPolygonElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new BatikRegularPolygonElement(string, (AbstractDocument)document);
        }
    }
}

