/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.view.mindmapview.EdgeView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class LinearEdgeView
extends EdgeView {
    protected void paint(Graphics2D g) {
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        int w = this.getWidth();
        if (w <= 1) {
            g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
            if (this.isTargetEclipsed()) {
                g.setColor(g.getBackground());
                g.setStroke(LinearEdgeView.getEclipsedStroke());
                g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
                g.setColor(color);
                g.setStroke(stroke);
            }
        } else {
            int dx = w / 3 + 1;
            if (this.getTarget().isLeft()) {
                dx = -dx;
            }
            int[] xs = new int[]{this.start.x, this.start.x + dx, this.end.x - dx, this.end.x};
            int[] ys = new int[]{this.start.y, this.start.y, this.end.y, this.end.y};
            g.drawPolyline(xs, ys, 4);
            if (this.isTargetEclipsed()) {
                g.setColor(g.getBackground());
                g.setStroke(LinearEdgeView.getEclipsedStroke());
                g.drawPolyline(xs, ys, 4);
                g.setColor(color);
                g.setStroke(stroke);
            }
        }
    }

    public Color getColor() {
        return this.getModel().getColor();
    }
}

