/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUnit
extends Unit
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerUnit.class.getName());
    private static int rumourNothing = -1;

    public ServerUnit(Game game, String id) {
        super(game, id);
    }

    public ServerUnit(Game game, Location location, Player owner, UnitType type) {
        this(game, location, owner, type, type.getDefaultEquipment());
    }

    public ServerUnit(Game game, Location location, Player owner, UnitType type, EquipmentType ... initialEquipment) {
        super(game);
        UnitType newType;
        this.visibleGoodsCount = -1;
        if (type.canCarryGoods()) {
            this.setGoodsContainer(new GoodsContainer(game, this));
        }
        this.unitType = (newType = type.getTargetType(UnitTypeChange.ChangeType.CREATION, owner)) == null ? type : newType;
        this.owner = owner;
        if (this.isPerson()) {
            this.ethnicity = this.nationality = owner.getNationID();
        }
        this.setLocation(location);
        this.workLeft = -1;
        this.workType = null;
        this.movesLeft = this.getInitialMovesLeft();
        this.hitpoints = this.unitType.getHitPoints();
        for (EquipmentType equipmentType : initialEquipment) {
            if (EquipmentType.NO_EQUIPMENT.equals(equipmentType)) {
                this.equipment.clear();
                break;
            }
            this.equipment.incrementCount(equipmentType, 1);
        }
        this.setRole();
        this.setStateUnchecked(this.state);
        owner.setUnit(this);
        owner.invalidateCanSeeTiles();
        owner.modifyScore(this.unitType.getScoreValue());
    }

    @Override
    public void csNewTurn(Random random, ChangeSet cs) {
        int maximumExperience;
        int maxValue;
        UnitType learn;
        GoodsType produce;
        logger.finest("ServerUnit.csNewTurn, for " + this.toString());
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        Specification spec = this.getSpecification();
        Location loc = this.getLocation();
        boolean locDirty = false;
        boolean unitDirty = false;
        if (loc instanceof Tile && ((Tile)loc).getSettlement() == null) {
            int attrition = this.getAttrition() + 1;
            this.setAttrition(attrition);
            if (attrition > this.getType().getMaximumAttrition()) {
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.unit.attrition", this).addStringTemplate("%unit%", this.getLabel()).addStringTemplate("%location%", loc.getLocationNameFor(owner)));
                cs.addDispose(ChangeSet.See.perhaps().always(owner), loc, this);
                cs.add(ChangeSet.See.perhaps(), (Tile)loc);
                return;
            }
        } else {
            this.setAttrition(0);
        }
        if (loc instanceof WorkLocation && (produce = this.getWorkType()) != null && (learn = spec.getExpertForProducing(produce)) != null && learn != this.getType() && this.getType().canBeUpgraded(learn, UnitTypeChange.ChangeType.EXPERIENCE) && (maxValue = 100 * (maximumExperience = this.getType().getMaximumExperience()) / this.getType().getUnitTypeChange(learn).getProbability(UnitTypeChange.ChangeType.EXPERIENCE)) > 0 && Utils.randomInt(logger, "Experience", random, maxValue) < Math.min(this.getExperience(), maximumExperience)) {
            StringTemplate oldName = this.getLabel();
            this.setType(learn);
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.unit.experience", this.getColony(), this).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", this.getLabel()).addName("%colony%", this.getColony().getName()));
            logger.finest("Experience upgrade for unit " + this.getId() + " to " + this.getType());
            unitDirty = true;
        }
        if (this.isInMission()) {
            this.getLocation().getTile().updatePlayerExploredTile(owner, true);
            this.setMovesLeft(0);
        } else if (this.isUnderRepair()) {
            this.setMovesLeft(0);
        } else {
            this.setMovesLeft(this.getInitialMovesLeft());
        }
        if (this.getWorkLeft() > 0) {
            unitDirty = true;
            switch (this.getState()) {
                case IMPROVING: {
                    TileImprovement ti = this.getWorkImprovement();
                    if (ti.isComplete()) {
                        this.setState(Unit.UnitState.ACTIVE);
                        this.setWorkLeft(-1);
                        break;
                    }
                    int amount = this.getType().hasAbility("model.ability.expertPioneer") ? 2 : 1;
                    int turns = ti.getTurnsToComplete();
                    if ((turns -= amount) < 0) {
                        turns = 0;
                    }
                    ti.setTurnsToComplete(turns);
                    this.setWorkLeft(turns);
                    break;
                }
                default: {
                    this.setWorkLeft(this.getWorkLeft() - 1);
                }
            }
            if (loc instanceof HighSeas && this.getOwner().isREF()) {
                this.setWorkLeft(0);
            }
        }
        if (this.getWorkLeft() == 0) {
            locDirty |= this.csCompleteWork(random, cs);
        }
        if (this.getState() == Unit.UnitState.SKIPPED) {
            this.setState(Unit.UnitState.ACTIVE);
            unitDirty = true;
        }
        if (locDirty) {
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)this.getLocation()));
        } else if (unitDirty) {
            cs.add(ChangeSet.See.perhaps(), this);
        } else {
            cs.addPartial(ChangeSet.See.only(owner), this, "movesLeft");
        }
    }

    private boolean csCompleteWork(Random random, ChangeSet cs) {
        this.setWorkLeft(-1);
        if (this.getLocation() instanceof HighSeas) {
            ServerPlayer owner = (ServerPlayer)this.getOwner();
            Europe europe = owner.getEurope();
            Map map = this.getGame().getMap();
            Location dst = this.getDestination();
            Location result = this.resolveDestination();
            if (result == europe) {
                logger.info(this + " arrives in Europe");
                if (this.getTradeRoute() == null) {
                    this.setDestination(null);
                    cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.unit.arriveInEurope", europe, this).add("%europe%", europe.getNameKey()));
                }
                this.setState(Unit.UnitState.ACTIVE);
                this.setLocation(europe);
                cs.add(ChangeSet.See.only(owner), owner.getHighSeas());
                return true;
            }
            if (result instanceof Tile) {
                Tile tile = ((Tile)result).getSafeTile(owner, random);
                logger.info(this + " arrives in America at " + tile + (dst == null ? "" : ", sailing for " + dst));
                if (dst instanceof Map) {
                    this.setDestination(null);
                }
                this.csMove(tile, random, cs);
            } else {
                logger.warning(this + " has unsupported destination " + this.getDestination());
            }
        } else {
            switch (this.getState()) {
                case FORTIFYING: {
                    this.setState(Unit.UnitState.FORTIFIED);
                    break;
                }
                case IMPROVING: {
                    this.csImproveTile(random, cs);
                    return true;
                }
                default: {
                    logger.warning("Unknown work completed, state=" + (Object)((Object)this.getState()));
                    this.setState(Unit.UnitState.ACTIVE);
                }
            }
        }
        return false;
    }

    private void csImproveTile(Random random, ChangeSet cs) {
        TileImprovementType tileImprovementType;
        int exposeResource;
        TileImprovement ti;
        TileType changeType;
        Tile tile = this.getTile();
        AbstractGoods deliver = this.getWorkImprovement().getType().getProduction(tile.getType());
        if (deliver != null) {
            Settlement settlement;
            int amount = deliver.getAmount();
            if (this.getType().hasAbility("model.ability.expertPioneer")) {
                amount *= 2;
            }
            if ((settlement = tile.getSettlement()) != null && (ServerPlayer)settlement.getOwner() == this.owner) {
                amount = (int)settlement.applyModifier(amount, "model.modifier.tileTypeChangeProduction", deliver.getType());
                settlement.addGoods(deliver.getType(), amount);
            } else {
                ArrayList<Settlement> adjacent = new ArrayList<Settlement>();
                int newAmount = amount;
                for (Tile t : tile.getSurroundingTiles(2)) {
                    Settlement ts = t.getSettlement();
                    if (ts == null || (ServerPlayer)ts.getOwner() != this.owner) continue;
                    adjacent.add(ts);
                    int modAmount = (int)ts.applyModifier(amount, "model.modifier.tileTypeChangeProduction", deliver.getType());
                    if (modAmount <= newAmount) continue;
                    newAmount = modAmount;
                }
                if (adjacent.size() > 0) {
                    int deliverPerCity = newAmount / adjacent.size();
                    for (Settlement s : adjacent) {
                        s.addGoods(deliver.getType(), deliverPerCity);
                    }
                    ((Settlement)adjacent.get(0)).addGoods(deliver.getType(), newAmount % adjacent.size());
                }
            }
        }
        if ((changeType = (ti = this.getWorkImprovement()).getChange(tile.getType())) != null) {
            tile.setType(changeType);
        }
        if ((exposeResource = (tileImprovementType = ti.getType()).getExposeResourcePercent()) > 0 && !tile.hasResource() && Utils.randomInt(logger, "Expose resource", random, 100) < exposeResource) {
            int maxValue;
            int minValue;
            ResourceType resType = (ResourceType)RandomChoice.getWeightedRandom(logger, "Resource type", random, tile.getType().getWeightedResources());
            int value = minValue + ((minValue = resType.getMinValue()) == (maxValue = resType.getMaxValue()) ? 0 : Utils.randomInt(logger, "Resource quantity", random, maxValue - minValue + 1));
            tile.addResource(new Resource(this.getGame(), tile, resType, value));
        }
        EquipmentType type = ti.getExpendedEquipmentType();
        this.changeEquipment(type, -ti.getExpendedAmount());
        for (Unit unit : tile.getUnitList()) {
            if (unit.getWorkImprovement() == null || unit.getWorkImprovement().getType() != ti.getType() || unit.getState() != Unit.UnitState.IMPROVING) continue;
            unit.setWorkLeft(-1);
            unit.setWorkImprovement(null);
            unit.setState(Unit.UnitState.ACTIVE);
            unit.setMovesLeft(0);
        }
        EquipmentType tools = this.getSpecification().getEquipmentType("model.equipment.tools");
        if (type == tools && this.getEquipmentCount(tools) == 0) {
            ServerPlayer owner = (ServerPlayer)this.getOwner();
            StringTemplate locName = this.getLocation().getLocationNameFor(owner);
            String messageId = this.getType().getDefaultEquipmentType() == type ? this.getType() + ".noMoreTools" : "model.unit.noMoreTools";
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, messageId, this).addStringTemplate("%unit%", this.getLabel()).addStringTemplate("%location%", locName));
        }
    }

    public void csRepairUnit(ChangeSet cs) {
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        this.setHitpoints(this.getHitpoints() + 1);
        if (!this.isUnderRepair()) {
            Location loc = this.getLocation();
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage("model.unit.unitRepaired", this, (FreeColObject)((FreeColGameObject)((Object)loc))).addStringTemplate("%unit%", this.getLabel()).addStringTemplate("%repairLocation%", loc.getLocationNameFor(owner)));
        }
        cs.addPartial(ChangeSet.See.only(owner), this, "hitpoints");
    }

    private Unit getSlowedBy(Tile newTile, Random random) {
        Player player = this.getOwner();
        Game game = this.getGame();
        CombatModel combatModel = game.getCombatModel();
        boolean pirate = this.hasAbility("model.ability.piracy");
        Unit attacker = null;
        float attackPower = 0.0f;
        float totalAttackPower = 0.0f;
        if (!this.isNaval() || this.getMovesLeft() <= 0) {
            return null;
        }
        for (Tile tile : newTile.getSurroundingTiles(1)) {
            Player enemy;
            if (tile.isLand() || tile.getColony() != null || tile.getFirstUnit() == null || (enemy = tile.getFirstUnit().getOwner()) == player) continue;
            for (Unit enemyUnit : tile.getUnitList()) {
                if (!pirate && !enemyUnit.hasAbility("model.ability.piracy") && (!enemyUnit.isOffensiveUnit() || !player.atWarWith(enemy)) || !enemyUnit.isNaval() || !(combatModel.getOffencePower(enemyUnit, this) > attackPower)) continue;
                attackPower = combatModel.getOffencePower(enemyUnit, this);
                totalAttackPower += attackPower;
                attacker = enemyUnit;
            }
        }
        if (attacker != null) {
            float defencePower = combatModel.getDefencePower(attacker, this);
            float totalProbability = totalAttackPower + defencePower;
            if ((float)Utils.randomInt(logger, "Slowed", random, Math.round(totalProbability) + 1) < totalAttackPower) {
                int diff = Math.max(0, Math.round(totalAttackPower - defencePower));
                int moves = Math.min(9, 3 + diff / 3);
                this.setMovesLeft(this.getMovesLeft() - moves);
                logger.info(this.getId() + " slowed by " + attacker.getId() + " by " + Integer.toString(moves) + " moves.");
            } else {
                attacker = null;
            }
        }
        return attacker;
    }

    private void csNativeBurialGround(ChangeSet cs) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        Tile tile = this.getTile();
        Player indianPlayer = tile.getOwner();
        cs.add(ChangeSet.See.only(serverPlayer), indianPlayer.modifyTension(serverPlayer, Tension.Level.HATEFUL.getLimit()));
        cs.add(ChangeSet.See.only(serverPlayer), indianPlayer);
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.burialGround", serverPlayer, this).addStringTemplate("%nation%", indianPlayer.getNationName()));
    }

    private void csExploreLostCityRumour(Random random, ChangeSet cs) {
        boolean mounds;
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        Tile tile = this.getTile();
        LostCityRumour lostCity = tile.getLostCityRumour();
        if (lostCity == null) {
            return;
        }
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        int difficulty = spec.getInteger("model.option.rumourDifficulty");
        int dx = 10 - difficulty;
        ServerUnit newUnit = null;
        List<UnitType> treasureUnitTypes = spec.getUnitTypesWithAbility("model.ability.carryTreasure");
        LostCityRumour.RumourType rumour = lostCity.getType();
        if (rumour == null) {
            rumour = lostCity.chooseType(this, difficulty, random);
        }
        switch (rumour) {
            case BURIAL_GROUND: 
            case MOUNDS: {
                if (tile.getOwner() != null && tile.getOwner().isIndian()) break;
                rumour = LostCityRumour.RumourType.NOTHING;
                break;
            }
            case LEARN: {
                if (!this.getType().getUnitTypesLearntInLostCity().isEmpty()) break;
                rumour = LostCityRumour.RumourType.NOTHING;
                break;
            }
        }
        boolean bl = mounds = rumour == LostCityRumour.RumourType.MOUNDS;
        if (mounds) {
            boolean done = false;
            boolean burial = false;
            block19: while (!done) {
                rumour = lostCity.chooseType(this, difficulty, random);
                switch (rumour) {
                    case EXPEDITION_VANISHES: 
                    case NOTHING: 
                    case TRIBAL_CHIEF: 
                    case RUINS: {
                        done = true;
                        continue block19;
                    }
                    case BURIAL_GROUND: {
                        if (tile.getOwner() == null || !tile.getOwner().isIndian() || burial) continue block19;
                        this.csNativeBurialGround(cs);
                        burial = true;
                        continue block19;
                    }
                }
            }
        }
        logger.info("Unit " + this.getId() + " is exploring rumour " + (Object)((Object)rumour));
        switch (rumour) {
            case BURIAL_GROUND: {
                this.csNativeBurialGround(cs);
                break;
            }
            case EXPEDITION_VANISHES: {
                cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), tile, this);
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.expeditionVanishes", serverPlayer));
                break;
            }
            case NOTHING: {
                if (game.getTurn().getYear() % 100 == 12 && Utils.randomInt(logger, "Mayans?", random, 4) == 0) {
                    int years = 2012 - game.getTurn().getYear();
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.mayans", serverPlayer, this).add("%years%", Integer.toString(years)));
                    break;
                }
                if (mounds) {
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.moundsNothing", serverPlayer, this));
                    break;
                }
                if (rumourNothing < 0) {
                    int i = 0;
                    while (Messages.containsKey("lostCityRumour.nothing." + Integer.toString(i))) {
                        ++i;
                    }
                    rumourNothing = i;
                }
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.nothing." + Integer.toString(Utils.randomInt(logger, "Nothing rumour", random, rumourNothing)), serverPlayer, this));
                break;
            }
            case LEARN: {
                StringTemplate oldName = this.getLabel();
                List<UnitType> learnTypes = this.getType().getUnitTypesLearntInLostCity();
                UnitType unitType = Utils.getRandomMember(logger, "Choose learn", learnTypes, random);
                this.setType(unitType);
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.learn", serverPlayer, this).addStringTemplate("%unit%", oldName).add("%type%", this.getType().getNameKey()));
                break;
            }
            case TRIBAL_CHIEF: {
                int chiefAmount = Utils.randomInt(logger, "Chief base amount", random, dx * 10) + dx * 5;
                serverPlayer.modifyGold(chiefAmount);
                cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, mounds ? "lostCityRumour.moundsTrinkets" : "lostCityRumour.tribalChief", serverPlayer, this).addAmount("%money%", chiefAmount));
                break;
            }
            case COLONIST: {
                List<UnitType> foundTypes = spec.getUnitTypesWithAbility("model.ability.foundInLostCity");
                UnitType unitType = Utils.getRandomMember(logger, "Choose found", foundTypes, random);
                newUnit = new ServerUnit(game, tile, serverPlayer, unitType);
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.colonist", serverPlayer, newUnit));
                break;
            }
            case CIBOLA: {
                String cityName = game.getCityOfCibola();
                if (cityName != null) {
                    int treasureAmount = Utils.randomInt(logger, "Base treasure amount", random, dx * 600) + dx * 300;
                    UnitType unitType = Utils.getRandomMember(logger, "Choose train", treasureUnitTypes, random);
                    newUnit = new ServerUnit(game, tile, serverPlayer, unitType);
                    newUnit.setTreasureAmount(treasureAmount);
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.cibola", serverPlayer, newUnit).add("%city%", cityName).addAmount("%money%", treasureAmount));
                    cs.addGlobalHistory(game, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.CITY_OF_GOLD).addStringTemplate("%nation%", serverPlayer.getNationName()).add("%city%", cityName).addAmount("%treasure%", treasureAmount));
                    break;
                }
            }
            case RUINS: {
                int ruinsAmount = Utils.randomInt(logger, "Base ruins amount", random, dx * 2) * 300 + 50;
                if (ruinsAmount < 500) {
                    serverPlayer.modifyGold(ruinsAmount);
                    cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
                } else {
                    UnitType unitType = Utils.getRandomMember(logger, "Choose train", treasureUnitTypes, random);
                    newUnit = new ServerUnit(game, tile, serverPlayer, unitType);
                    newUnit.setTreasureAmount(ruinsAmount);
                }
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, mounds ? "lostCityRumour.moundsTreasure" : "lostCityRumour.ruins", serverPlayer, newUnit != null ? newUnit : this).addAmount("%money%", ruinsAmount));
                break;
            }
            case FOUNTAIN_OF_YOUTH: {
                Europe europe = serverPlayer.getEurope();
                if (europe == null) {
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.fountainOfYouthWithoutEurope", serverPlayer, this));
                } else {
                    if (serverPlayer.hasAbility("model.ability.selectRecruit") && !serverPlayer.isAI()) {
                        serverPlayer.setRemainingEmigrants(dx);
                        cs.addTrivial(ChangeSet.See.only(serverPlayer), "fountainOfYouth", ChangeSet.ChangePriority.CHANGE_LATE, "migrants", Integer.toString(dx));
                    } else {
                        List recruitables = serverPlayer.generateRecruitablesList();
                        for (int k = 0; k < dx; ++k) {
                            UnitType type = (UnitType)RandomChoice.getWeightedRandom(logger, "Choose FoY", random, recruitables);
                            new ServerUnit(game, europe, serverPlayer, type);
                        }
                        cs.add(ChangeSet.See.only(serverPlayer), europe);
                    }
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.fountainOfYouth", serverPlayer, this));
                }
                cs.addAttribute(ChangeSet.See.only(serverPlayer), "sound", "sound.event.fountainOfYouth");
                break;
            }
            default: {
                logger.warning("Bogus rumour type: " + (Object)((Object)rumour));
            }
        }
        tile.removeLostCityRumour();
    }

    private void csActivateSentries(Tile tile, ChangeSet cs) {
        for (Unit u : tile.getUnitList()) {
            if (u.getState() != Unit.UnitState.SENTRY) continue;
            u.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.perhaps(), u);
        }
    }

    public List<Tile> collectNewTiles(Tile tile) {
        ArrayList<Tile> newTiles = new ArrayList<Tile>();
        int los = this.getLineOfSight();
        for (Tile t : tile.getSurroundingTiles(los)) {
            if (this.getOwner().canSee(t)) continue;
            newTiles.add(t);
        }
        return newTiles;
    }

    public void csMove(Tile newTile, Random random, ChangeSet cs) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        List<Tile> newTiles = this.collectNewTiles(newTile);
        Location oldLocation = this.getLocation();
        this.setState(Unit.UnitState.ACTIVE);
        this.setStateToAllChildren(Unit.UnitState.SENTRY);
        if (!(oldLocation instanceof HighSeas)) {
            if (oldLocation instanceof Unit) {
                this.setMovesLeft(0);
            } else {
                if (this.getMoveCost(newTile) <= 0) {
                    logger.warning("Move of unit: " + this.getId() + " from: " + (oldLocation == null ? "null" : oldLocation.getTile().getId()) + " to: " + newTile.getId() + " has bogus cost: " + this.getMoveCost(newTile));
                    this.setMovesLeft(0);
                }
                this.setMovesLeft(this.getMovesLeft() - this.getMoveCost(newTile));
            }
        }
        this.setLocation(newTile);
        if (newTile.hasLostCityRumour() && serverPlayer.isEuropean()) {
            this.csExploreLostCityRumour(random, cs);
        }
        if (oldLocation instanceof Tile) {
            cs.addMove(ChangeSet.See.perhaps().always(serverPlayer), this, oldLocation, newTile);
            cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)oldLocation));
        } else {
            cs.add(ChangeSet.See.only(serverPlayer), (FreeColGameObject)((Object)oldLocation));
        }
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), newTile);
        if (this.isDisposed()) {
            return;
        }
        serverPlayer.csSeeNewTiles(newTiles, cs);
        if (newTile.isLand()) {
            int d;
            Settlement settlement;
            Unit unit = null;
            if (newTile.getOwner() == null && serverPlayer.isIndian() && (settlement = this.getIndianSettlement()) != null && (d = newTile.getPosition().getDistance(settlement.getTile().getPosition())) < settlement.getRadius() + settlement.getType().getExtraClaimableRadius() && Utils.randomInt(logger, "Claim tribal land", random, d + 1) == 0) {
                newTile.setOwner(serverPlayer);
                newTile.changeOwningSettlement(settlement);
            }
            String newLand = null;
            if (serverPlayer.isEuropean() && !serverPlayer.isNewLandNamed()) {
                newLand = Messages.getNewLandName(serverPlayer);
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.DEFAULT, "EventPanel.FIRST_LANDING", serverPlayer));
                serverPlayer.setNewLandName(newLand);
            }
            Player welcomer = null;
            for (Tile t : newTile.getSurroundingTiles(1, 1)) {
                IndianSettlement is;
                ServerPlayer other;
                if (t == null || !t.isLand() || (other = (settlement = t.getSettlement()) != null ? (ServerPlayer)settlement.getOwner() : ((unit = t.getFirstUnit()) != null ? (ServerPlayer)unit.getOwner() : null)) == null || other == serverPlayer) continue;
                if (serverPlayer.csContact(other, newTile, cs) != null) {
                    welcomer = other;
                }
                ServerPlayer contactPlayer = serverPlayer;
                IndianSettlement indianSettlement = is = settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
                if ((is != null || unit != null && (is = unit.getIndianSettlement()) != null || unit != null && (contactPlayer = (ServerPlayer)unit.getOwner()).isEuropean() && (is = this.getIndianSettlement()) != null) && contactPlayer.hasExplored(is.getTile()) && is.setContacted(contactPlayer)) {
                    cs.add(ChangeSet.See.only(contactPlayer), is);
                    StringTemplate nation = is.getOwner().getNationName();
                    cs.addMessage(ChangeSet.See.only(contactPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.unit.nativeSettlementContact", this, is).addStringTemplate("%nation%", nation).addName("%settlement%", is.getName()));
                }
                this.csActivateSentries(t, cs);
            }
            if (newLand != null) {
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new NewLandNameMessage(this, newLand, welcomer, welcomer == null ? -1 : welcomer.getNumberOfSettlements(), false));
            }
        } else {
            for (Tile t : newTile.getSurroundingTiles(1, 1)) {
                if (t == null || t.isLand() || t.getFirstUnit() == null || (ServerPlayer)t.getFirstUnit().getOwner() == serverPlayer) continue;
                this.csActivateSentries(t, cs);
            }
        }
        Unit slowedBy = this.getSlowedBy(newTile, random);
        if (slowedBy != null) {
            StringTemplate enemy = slowedBy.getApparentOwnerName();
            cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.unit.slowed", this, slowedBy).addStringTemplate("%unit%", Messages.getLabel(this)).addStringTemplate("%enemyUnit%", Messages.getLabel(slowedBy)).addStringTemplate("%enemyNation%", enemy));
        }
        Region region = newTile.getDiscoverableRegion();
        if (serverPlayer.isEuropean() && region != null) {
            if (region.isPacific()) {
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.DEFAULT, "EventPanel.DISCOVER_PACIFIC", serverPlayer));
                cs.addRegion(serverPlayer, region, Messages.message("model.region.pacific"));
            } else if (region.getName() == null) {
                String defaultName = Messages.getDefaultRegionName(serverPlayer, region.getType());
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new NewRegionNameMessage(region, newTile, defaultName));
                region.setName(defaultName);
            }
        }
    }

    public void csRemoveEquipment(Settlement settlement, Collection<EquipmentType> remove, int amount, Random random, ChangeSet cs) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        for (EquipmentType e : remove) {
            int a = amount > 0 ? amount : this.getEquipmentCount(e);
            for (AbstractGoods ag : e.getRequiredGoods()) {
                GoodsType goodsType = ag.getType();
                int n = ag.getAmount() * a;
                if (this.isInEurope()) {
                    if (!serverPlayer.canTrade(goodsType, Market.Access.EUROPE)) continue;
                    serverPlayer.sell(null, goodsType, n, random);
                    serverPlayer.csFlushMarket(goodsType, cs);
                    continue;
                }
                if (settlement == null) continue;
                settlement.addGoods(goodsType, n);
            }
            this.changeEquipment(e, -a);
        }
    }

    public boolean hasWorkAtStop(TradeRoute.Stop stop) {
        List<GoodsType> stopGoods = stop.getCargo();
        int cargoSize = stopGoods.size();
        for (Goods goods : this.getGoodsList()) {
            GoodsType type = goods.getType();
            if (stopGoods.contains(type)) {
                if (this.getLoadableAmount(type) > 0) {
                    Location loc = stop.getLocation();
                    if (!(loc instanceof Colony ? ((Colony)loc).getExportAmount(type) > 0 : loc instanceof Europe)) continue;
                    return true;
                }
                --cargoSize;
                continue;
            }
            return true;
        }
        return this.hasSpaceLeft() && cargoSize > 0;
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverUnit";
    }
}

