/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.awt.Rectangle;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;

public class ServerRegion
extends Region {
    private int size = 0;
    private Rectangle bounds = new Rectangle();

    public ServerRegion(Game game, Region region) {
        super(game);
        this.name = region.getName();
        this.nameKey = region.getNameKey();
        this.parent = null;
        this.claimable = region.isClaimable();
        this.discoverable = region.isDiscoverable();
        this.discoveredIn = region.getDiscoveredIn();
        this.discoveredBy = region.getDiscoveredBy();
        this.prediscovered = region.isPrediscovered();
        this.scoreValue = region.getScoreValue();
        this.type = region.getType();
    }

    public ServerRegion(Game game, String nameKey, Region.RegionType type, Region parent) {
        super(game, nameKey);
        this.setNameKey(nameKey);
        this.setType(type);
        this.setParent(parent);
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int newSize) {
        this.size = newSize;
    }

    public final Rectangle getBounds() {
        return this.bounds;
    }

    public final void setBounds(Rectangle newBounds) {
        this.bounds = newBounds;
    }

    public void addTile(Tile tile) {
        tile.setRegion(this);
        ++this.size;
        if (this.bounds.x == 0 && this.bounds.width == 0 || this.bounds.y == 0 && this.bounds.height == 0) {
            this.bounds.setBounds(tile.getX(), tile.getY(), 0, 0);
        } else {
            this.bounds.add(tile.getX(), tile.getY());
        }
    }

    public Map.Position getCenter() {
        return new Map.Position(this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height / 2);
    }
}

