/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.InputHandler;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public final class PreGameInputHandler
extends InputHandler {
    private static Logger logger = Logger.getLogger(PreGameInputHandler.class.getName());
    private boolean launching = false;

    public PreGameInputHandler(FreeColServer freeColServer) {
        super(freeColServer);
        this.register("updateGameOptions", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.updateGameOptions(connection, element);
            }
        });
        this.register("updateMapGeneratorOptions", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.updateMapGeneratorOptions(connection, element);
            }
        });
        this.register("ready", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.ready(connection, element);
            }
        });
        this.register("setNation", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.nation(connection, element);
            }
        });
        this.register("setNationType", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.nationType(connection, element);
            }
        });
        this.register("setAvailable", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.available(connection, element);
            }
        });
        this.register("requestLaunch", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                Element reply = PreGameInputHandler.this.requestLaunch(connection, element);
                if (reply != null) {
                    PreGameInputHandler.this.launching = false;
                }
                return reply;
            }
        });
    }

    private Element updateGameOptions(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (!player.isAdmin()) {
            throw new IllegalStateException("Not an admin");
        }
        Specification spec = this.getFreeColServer().getGame().getSpecification();
        OptionGroup gameOptions = spec.getOptionGroup("gameOptions");
        Element child = (Element)element.getChildNodes().item(0);
        gameOptions.readFromXMLElement(child);
        spec.clean();
        Element up = DOMMessage.createMessage("updateGameOptions", new String[0]);
        up.appendChild(gameOptions.toXMLElement(up.getOwnerDocument()));
        this.getFreeColServer().getServer().sendToAll(up, connection);
        return null;
    }

    private Element updateMapGeneratorOptions(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (!player.isAdmin()) {
            throw new IllegalStateException("Not an admin");
        }
        Element child = (Element)element.getChildNodes().item(0);
        this.getFreeColServer().getMapGenerator().getMapGeneratorOptions().readFromXMLElement(child);
        Element umge = DOMMessage.createMessage("updateMapGeneratorOptions", new String[0]);
        umge.appendChild(this.getFreeColServer().getMapGenerator().getMapGeneratorOptions().toXMLElement(umge.getOwnerDocument()));
        this.getFreeColServer().getServer().sendToAll(umge, connection);
        return null;
    }

    private Element ready(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            boolean ready = new Boolean(element.getAttribute("value"));
            player.setReady(ready);
            this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("playerReady", "player", player.getId(), "value", Boolean.toString(ready)), player.getConnection());
        } else {
            logger.warning("Ready from unknown connection.");
        }
        return null;
    }

    private Element nation(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("value"));
            if (this.getFreeColServer().getGame().getNationOptions().getNations().get(nation) == NationOptions.NationState.AVAILABLE) {
                player.setNation(nation);
                this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("updateNation", "player", player.getId(), "value", nation.getId()), player.getConnection());
            } else {
                logger.warning("Selected non-selectable nation.");
            }
        } else {
            logger.warning("Nation from unknown connection.");
        }
        return null;
    }

    private Element nationType(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            NationType nationType = this.getGame().getSpecification().getNationType(element.getAttribute("value"));
            NationType fixedNationType = this.getGame().getSpecification().getNation(player.getNationID()).getType();
            NationOptions.Advantages advantages = this.getFreeColServer().getGame().getNationOptions().getNationalAdvantages();
            if (advantages == NationOptions.Advantages.SELECTABLE || advantages == NationOptions.Advantages.FIXED && nationType.equals(fixedNationType)) {
                player.setNationType(nationType);
                this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("updateNationType", "player", player.getId(), "value", nationType.getId()), player.getConnection());
            } else {
                logger.warning("NationType is not selectable");
            }
        } else {
            logger.warning("NationType from unknown connection.");
        }
        return null;
    }

    private Element available(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("nation"));
            NationOptions.NationState state = Enum.valueOf(NationOptions.NationState.class, element.getAttribute("state"));
            this.getFreeColServer().getGame().getNationOptions().setNationState(nation, state);
            this.getFreeColServer().getServer().sendToAll(element, player.getConnection());
        } else {
            logger.warning("Available from unknown connection.");
        }
        return null;
    }

    private Element requestLaunch(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer launchingPlayer = freeColServer.getPlayer(connection);
        if (!launchingPlayer.isAdmin()) {
            return DOMMessage.createError("server.onlyAdminCanLaunch", "Only the server admin can launch the game.");
        }
        if (this.launching) {
            return null;
        }
        this.launching = true;
        ArrayList<Nation> nations = new ArrayList<Nation>();
        for (Player player : freeColServer.getGame().getPlayers()) {
            Nation nation = this.getGame().getSpecification().getNation(player.getNationID());
            if (nations.contains(nation)) {
                return DOMMessage.createError("server.invalidPlayerNations", "All players need to pick a unique nation before the game can start.");
            }
            nations.add(nation);
        }
        if (!freeColServer.getGame().isAllPlayersReadyToLaunch()) {
            return DOMMessage.createError("server.notAllReady", "Not all players are ready to begin the game!");
        }
        try {
            ((PreGameController)freeColServer.getController()).startGame();
        }
        catch (FreeColException e) {
            return DOMMessage.createError("server.errorStartingGame", "An error occurred while starting the game!");
        }
        return null;
    }

    protected Element logout(Connection connection, Element element) {
        logger.info("Logout from: " + connection);
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        player.setConnected(false);
        this.getFreeColServer().getGame().removePlayer(player);
        this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("logout", "reason", "User has logged out.", "player", player.getId()), connection);
        try {
            this.getFreeColServer().updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            // empty catch block
        }
        return null;
    }
}

