/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class WorkInsideColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(WorkInsideColonyMission.class.getName());
    private static final String tag = "AI worker";
    private AIColony aiColony;

    public WorkInsideColonyMission(AIMain aiMain, AIUnit aiUnit, AIColony aiColony) {
        super(aiMain, aiUnit);
        this.aiColony = aiColony;
        this.uninitialized = false;
    }

    public WorkInsideColonyMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public AIColony getAIColony() {
        return this.aiColony;
    }

    public Location getTransportDestination() {
        return this.getUnit().shouldTakeTransportTo(this.getTarget()) ? this.getTarget() : null;
    }

    public Location getTarget() {
        return this.aiColony == null || this.aiColony.getColony() == null ? null : this.aiColony.getColony().getTile();
    }

    public void setTarget(Location target) {
        throw new IllegalStateException("Target is fixed.");
    }

    public Location findTarget() {
        throw new IllegalStateException("Target is fixed.");
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = WorkInsideColonyMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isPerson() ? "unit-not-a-person" : ((reason = WorkInsideColonyMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner())) != null ? reason : null));
    }

    public String invalidReason() {
        return WorkInsideColonyMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (reason != null) {
            logger.finest("AI worker broken(" + reason + "): " + this);
            return;
        }
        this.travelToTarget(tag, this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits());
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, WorkInsideColonyMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("colony", this.aiColony.getId());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.aiColony = (AIColony)this.getAIMain().getAIObject(in.getAttributeValue(null, "colony"));
    }

    public static String getXMLElementTagName() {
        return "workInsideColonyMission";
    }
}

