/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;

public class UnitWanderHostileMission
extends Mission {
    private static final Logger logger = Logger.getLogger(UnitWanderHostileMission.class.getName());
    private static final String tag = "AI hostile-wanderer";

    public UnitWanderHostileMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        this.uninitialized = false;
    }

    public UnitWanderHostileMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public Location getTarget() {
        return null;
    }

    public void setTarget(Location target) {
    }

    public Location findTarget() {
        return null;
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        Unit unit = aiUnit.getUnit();
        return !unit.isOffensiveUnit() ? "unit-not-offensive" : (unit.getTile() == null ? "unit-not-on-map" : null);
    }

    public static String invalidReason(AIUnit aiUnit) {
        String reason = Mission.invalidReason(aiUnit);
        return reason != null ? reason : ((reason = UnitWanderHostileMission.invalidMissionReason(aiUnit)) != null ? reason : null);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = UnitWanderHostileMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : ((reason = UnitWanderHostileMission.invalidMissionReason(aiUnit)) != null ? reason : null);
    }

    public String invalidReason() {
        return UnitWanderHostileMission.invalidReason(this.getAIUnit(), null);
    }

    public boolean isOneTime() {
        return true;
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (reason != null) {
            logger.finest("AI hostile-wanderer broken(" + reason + "): " + this);
            return;
        }
        Unit unit = this.getUnit();
        AIMain aiMain = this.getAIMain();
        AIUnit aiUnit = this.getAIUnit();
        int check = 0;
        int checkTurns = Utils.randomInt(logger, "Hostile", this.getAIRandom(), 4);
        Map.Direction d = Map.Direction.getRandomDirection(tag, this.getAIRandom());
        boolean moved = false;
        while (unit.getMovesLeft() > 0) {
            if (check == 0) {
                Location loc = UnitSeekAndDestroyMission.findTarget(aiUnit, 1, false);
                if (loc != null) {
                    UnitSeekAndDestroyMission m = new UnitSeekAndDestroyMission(aiMain, aiUnit, loc);
                    aiUnit.setMission(m);
                    ((Mission)m).doMission();
                    return;
                }
                check = checkTurns;
            } else {
                --check;
            }
            d = this.moveRandomly(tag, d);
            if (d == null) break;
            moved = true;
        }
        if (moved) {
            logger.finest("AI hostile-wanderer moved to " + unit.getLocation() + ": " + this);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, UnitWanderHostileMission.getXMLElementTagName());
        }
    }

    public static String getXMLElementTagName() {
        return "unitWanderHostileMission";
    }
}

