/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class IndianBringGiftMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianBringGiftMission.class.getName());
    private static final String tag = "AI native gifter";
    private Location target = null;
    private boolean completed;

    public IndianBringGiftMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.target = target;
        this.completed = false;
        Unit unit = this.getUnit();
        if (!unit.getOwner().isIndian() || !unit.canCarryGoods()) {
            throw new IllegalArgumentException("Unsuitable unit: " + unit);
        }
        this.uninitialized = false;
    }

    public IndianBringGiftMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    private boolean hasGift() {
        return this.getUnit().hasGoodsCargo();
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        throw new IllegalStateException("Target is fixed");
    }

    public Location findTarget() {
        throw new IllegalStateException("Target is fixed");
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = IndianBringGiftMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (aiUnit.getUnit().getIndianSettlement() == null ? "home-destroyed" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = IndianBringGiftMission.invalidTargetReason(colony);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        Player targetPlayer = colony.getOwner();
        switch (owner.getStance(targetPlayer)) {
            case UNCONTACTED: 
            case WAR: 
            case CEASE_FIRE: {
                return "bad-stance";
            }
            case PEACE: 
            case ALLIANCE: {
                Tension tension = unit.getIndianSettlement().getAlarm(targetPlayer);
                if (tension == null || tension.getLevel().compareTo(Tension.Level.HAPPY) <= 0) break;
                return "unhappy";
            }
        }
        return null;
    }

    public static String invalidReason(AIUnit aiUnit) {
        return IndianBringGiftMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = IndianBringGiftMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? IndianBringGiftMission.invalidColonyReason(aiUnit, (Colony)loc) : "target-invalid");
    }

    public String invalidReason() {
        String reason = IndianBringGiftMission.invalidReason(this.getAIUnit(), this.target);
        return reason != null ? reason : (this.completed ? "completed" : null);
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (reason != null) {
            logger.finest("AI native gifter broken(" + reason + "): " + this);
            return;
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        IndianSettlement is = unit.getIndianSettlement();
        if (!this.hasGift()) {
            Unit.MoveType mt = this.travelToTarget(tag, is, null);
            switch (mt) {
                case MOVE_NO_MOVES: {
                    return;
                }
                case MOVE: {
                    break;
                }
                case ATTACK_SETTLEMENT: 
                case ATTACK_UNIT: {
                    Location blocker = IndianBringGiftMission.resolveBlockage(aiUnit, is);
                    if (blocker == null) {
                        logger.warning("AI native gifter could not resolve blockage: " + this);
                        this.moveRandomly(tag, null);
                        unit.setMovesLeft(0);
                        break;
                    }
                    logger.finest("AI native gifter blocked by " + blocker + ", attacking: " + this);
                    AIMessage.askAttack(aiUnit, unit.getTile().getDirection(blocker.getTile()));
                    break;
                }
                default: {
                    logger.warning("AI native gifter unexpected collection move type: " + (Object)((Object)mt) + ": " + this);
                    this.moveRandomly(tag, null);
                    return;
                }
            }
            Goods gift = is.getRandomGift(this.getAIRandom());
            if (gift == null) {
                logger.finest("AI native gifter found no gift to collect at " + is.getName() + ": " + this);
            } else if (!AIMessage.askLoadCargo(aiUnit, gift)) {
                logger.finest("AI native gifter failed to collect gift  at " + is.getName() + ": " + this);
            }
            if (!this.hasGift()) {
                this.completed = true;
                return;
            }
        } else {
            Unit.MoveType mt = this.travelToTarget(tag, this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits());
            switch (mt) {
                case MOVE_NO_MOVES: {
                    return;
                }
                case ATTACK_SETTLEMENT: {
                    break;
                }
                default: {
                    logger.finest("AI native gifter unexpected delivery move type: " + (Object)((Object)mt) + ": " + this);
                    this.moveRandomly(tag, null);
                    return;
                }
            }
            if (!unit.getTile().isAdjacent(this.getTarget().getTile())) {
                throw new IllegalStateException("Not at target: " + this.getTarget());
            }
            Settlement settlement = (Settlement)this.getTarget();
            if (AIMessage.askGetTransaction(aiUnit, settlement) && AIMessage.askDeliverGift(aiUnit, settlement, unit.getGoodsList().get(0))) {
                AIMessage.askCloseTransaction(aiUnit, settlement);
                logger.finest("AI native gifter completed at " + settlement.getName() + ": " + this);
            } else {
                logger.warning("AI native gifter failed at " + settlement.getName() + ": " + this);
            }
            this.completed = true;
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, IndianBringGiftMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
        out.writeAttribute("completed", Boolean.toString(this.completed));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = this.getGame().getFreeColGameObject(str, Colony.class);
        str = in.getAttributeValue(null, "completed");
        if (str == null) {
            str = in.getAttributeValue(null, "giftDelivered");
        }
        this.completed = Boolean.valueOf(str);
    }

    public static String getXMLElementTagName() {
        return "indianBringGiftMission";
    }
}

