/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class CashInTreasureTrainMission
extends Mission {
    private static final Logger logger = Logger.getLogger(CashInTreasureTrainMission.class.getName());
    private static final String tag = "AI treasureTrain";
    private Location target = null;

    public CashInTreasureTrainMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
        logger.finest("AI treasureTrain starts at " + aiUnit.getUnit().getLocation() + " with target " + target + ": " + this);
        this.uninitialized = false;
    }

    public CashInTreasureTrainMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        Colony colony = loc.getColony();
        return loc instanceof Europe && CashInTreasureTrainMission.invalidReason(aiUnit, loc) == null ? loc : (colony != null && CashInTreasureTrainMission.invalidReason(aiUnit, colony) == null ? colony : null);
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc;
        if (path == null || (loc = CashInTreasureTrainMission.extractTarget(aiUnit, path)) == null || loc instanceof Colony && CashInTreasureTrainMission.invalidFullColonyReason(aiUnit, loc.getColony()) != null) {
            return Integer.MIN_VALUE;
        }
        return aiUnit.getUnit().getTreasureAmount() / (path.getTotalTurns() + 1);
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value;
                Location loc = CashInTreasureTrainMission.extractTarget(aiUnit, path);
                if ((loc instanceof Colony && CashInTreasureTrainMission.invalidFullColonyReason(aiUnit, (Colony)loc) == null || loc instanceof Europe) && this.bestValue < (value = CashInTreasureTrainMission.scorePath(aiUnit, path))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    private static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (CashInTreasureTrainMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        Player player = unit.getOwner();
        Europe europe = player.getEurope();
        Unit carrier = unit.getCarrier();
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        if (player.getNumberOfSettlements() <= 0) {
            return europe == null ? null : unit.findPath(startTile, europe, carrier, standardCd);
        }
        GoalDecider gd = CashInTreasureTrainMission.getGoalDecider(aiUnit, deferOK);
        return unit.search(startTile, gd, standardCd, range, carrier);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        Player player = aiUnit.getUnit().getOwner();
        PathNode path = CashInTreasureTrainMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? CashInTreasureTrainMission.extractTarget(aiUnit, path) : CashInTreasureTrainMission.upLoc(CashInTreasureTrainMission.findCircleTarget(aiUnit, CashInTreasureTrainMission.getGoalDecider(aiUnit, deferOK), range * 3, deferOK));
    }

    public Location getTransportDestination() {
        return this.getUnit().shouldTakeTransportTo(this.getTarget()) ? this.getTarget() : null;
    }

    public int getTransportPriority() {
        return this.getTransportDestination() == null ? 0 : this.getUnit().getTreasureAmount();
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Europe || target instanceof Colony) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return CashInTreasureTrainMission.findTarget(this.getAIUnit(), 20, true);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = CashInTreasureTrainMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return !unit.canCarryTreasure() ? "unit-cannot-carry-treasure" : (unit.getTreasureAmount() <= 0 ? "unit-treasure-nonpositive" : null);
    }

    private static String invalidFullColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = CashInTreasureTrainMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
        return reason != null ? reason : (!aiUnit.getUnit().canCashInTreasureTrain(colony.getTile()) ? "cashin-impossible-at-location" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return CashInTreasureTrainMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidEuropeReason(AIUnit aiUnit, Europe europe) {
        return CashInTreasureTrainMission.invalidTargetReason(europe, aiUnit.getUnit().getOwner());
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = CashInTreasureTrainMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? CashInTreasureTrainMission.invalidColonyReason(aiUnit, (Colony)loc) : (loc instanceof Europe ? CashInTreasureTrainMission.invalidEuropeReason(aiUnit, (Europe)loc) : "target-invalid"));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return CashInTreasureTrainMission.invalidMissionReason(aiUnit);
    }

    public String invalidReason() {
        return CashInTreasureTrainMission.invalidReason(this.getAIUnit(), this.target);
    }

    public void doMission() {
        Unit unit = this.getUnit();
        String reason = this.invalidReason();
        if (this.isTargetReason(reason)) {
            if (!this.retargetMission(tag, reason)) {
                return;
            }
        } else if (reason != null) {
            logger.finest("AI treasureTrain broken(" + reason + "): " + this);
            return;
        }
        if (this.travelToTarget(tag, this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits()) != Unit.MoveType.MOVE) {
            return;
        }
        AIUnit aiUnit = this.getAIUnit();
        Player player = unit.getOwner();
        Europe europe = player.getEurope();
        if (unit.canCashInTreasureTrain()) {
            if (unit.isInEurope() || europe == null || unit.getTransportFee() == 0 || player.getCarriersForUnit(unit).isEmpty()) {
                if (AIMessage.askCashInTreasureTrain(aiUnit)) {
                    logger.finest("AI treasureTrain completed cash in at " + CashInTreasureTrainMission.upLoc(unit.getLocation()) + ": " + this);
                } else {
                    logger.warning("AI treasureTrain failed to cash in at " + CashInTreasureTrainMission.upLoc(unit.getLocation()) + ": " + this);
                }
            } else {
                this.setTarget(europe);
                logger.finest("AI treasureTrain at " + CashInTreasureTrainMission.upLoc(unit.getLocation()) + " retargeting Europe: " + this);
            }
        } else {
            this.retargetMission(tag, "arrived at " + unit.getLocation().getColony().getName());
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, CashInTreasureTrainMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = this.getGame().getFreeColLocation(str);
    }

    public static String getXMLElementTagName() {
        return "cashInTreasureTrainMission";
    }
}

