/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkLocationPlan
extends AIObject {
    private static final Logger logger = Logger.getLogger(WorkLocationPlan.class.getName());
    private WorkLocation workLocation;
    private GoodsType goodsType;

    public WorkLocationPlan(AIMain aiMain, WorkLocation workLocation, GoodsType goodsType) {
        super(aiMain);
        this.workLocation = workLocation;
        this.goodsType = goodsType;
        this.uninitialized = false;
    }

    public WorkLocationPlan(AIMain aiMain, Element element) {
        super(aiMain, element);
    }

    public WorkLocation getWorkLocation() {
        return this.workLocation;
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public void setGoodsType(GoodsType goodsType) {
        this.goodsType = goodsType;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(WorkLocationPlan.getXMLElementTagName());
        element.setAttribute("ID", this.workLocation.getId());
        element.setAttribute("goodsType", this.goodsType.getId());
        return element;
    }

    public void readFromXMLElement(Element element) {
        String str = element.getAttribute("ID");
        this.workLocation = this.getAIMain().getGame().getFreeColGameObject(str, WorkLocation.class);
        str = element.getAttribute("goodsType");
        this.goodsType = this.getSpecification().getGoodsType(str);
    }

    public static String getXMLElementTagName() {
        return "workLocationPlan";
    }
}

