/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.ValuedAIObject;
import org.w3c.dom.Element;

public abstract class Wish
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(Wish.class.getName());
    protected Location destination;
    protected Transportable transportable;

    public Wish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.destination = null;
        this.transportable = null;
    }

    public Wish(AIMain aiMain, Element element) {
        super(aiMain, element);
    }

    public Wish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
    }

    public void dispose() {
        this.destination = null;
        this.transportable = null;
        super.dispose();
    }

    public boolean shouldBeStored() {
        return this.transportable != null;
    }

    public Transportable getTransportable() {
        return this.transportable;
    }

    public void setTransportable(Transportable transportable) {
        this.transportable = transportable;
    }

    public Location getDestination() {
        return this.destination;
    }

    public AIColony getDestinationAIColony() {
        return this.destination instanceof Colony ? this.getAIMain().getAIColony((Colony)this.destination) : null;
    }

    public boolean checkIntegrity() {
        return super.checkIntegrity() && this.destination != null && !((FreeColGameObject)((Object)this.destination)).isDisposed() && (this.transportable == null || ((AIObject)((Object)this.transportable)).checkIntegrity());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("destination", this.destination.getId());
        if (this.transportable != null) {
            out.writeAttribute("transportable", this.transportable.getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        AIMain aiMain = this.getAIMain();
        String str = in.getAttributeValue(null, "destination");
        this.destination = aiMain.getGame().getFreeColLocation(str);
        str = in.getAttributeValue(null, "transportable");
        if (str != null) {
            this.transportable = (AIUnit)aiMain.getAIObject(str);
            if (this.transportable == null) {
                this.transportable = new AIUnit(aiMain, str);
            }
        } else {
            this.transportable = null;
        }
    }
}

