/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.NativeAIPlayer;
import net.sf.freecol.server.ai.REFAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIMain
extends FreeColObject
implements FreeColGameObjectListener {
    private static final Logger logger = Logger.getLogger(AIMain.class.getName());
    private FreeColServer freeColServer;
    private int nextId = 1;
    private final HashMap<String, AIObject> aiObjects = new HashMap();

    public AIMain(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
        this.findNewObjects();
    }

    public AIMain(FreeColServer freeColServer, Element element) {
        this(freeColServer);
        this.readFromXMLElement(element);
    }

    public AIMain(FreeColServer freeColServer, XMLStreamReader in) throws XMLStreamException {
        this(freeColServer);
        this.readFromXML(in);
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public Game getGame() {
        return this.freeColServer.getGame();
    }

    public String getNextId() {
        String id = "am" + Integer.toString(this.nextId);
        ++this.nextId;
        return id;
    }

    public int getRandomSeed(String logMe) {
        return Utils.randomInt(logger, logMe, this.freeColServer.getServerRandom(), Integer.MAX_VALUE);
    }

    public boolean checkIntegrity() {
        boolean ok = true;
        for (AIObject ao : this.aiObjects.values()) {
            if (ao.checkIntegrity()) continue;
            logger.warning("Invalid AIObject: " + ao.getId() + " (" + ao.getClass() + ")");
            ok = false;
        }
        Iterator<FreeColGameObject> fit = this.getGame().getFreeColGameObjectIterator();
        while (fit.hasNext()) {
            FreeColGameObject f = fit.next();
            if (!(f instanceof Unit) && !(f instanceof Colony) && (!(f instanceof Player) || ((Player)f).isUnknownEnemy()) || this.aiObjects.containsKey(f.getId())) continue;
            logger.warning("Missing AIObject for: " + f.getId());
            ok = false;
        }
        return ok;
    }

    public boolean fixIntegrity() {
        for (AIObject ao : new ArrayList<AIObject>(this.aiObjects.values())) {
            if (ao.checkIntegrity()) continue;
            logger.warning("Dropping invalid AIObject: " + ao.getId() + " (" + ao.getClass() + ")");
            ao.fixIntegrity();
        }
        Iterator<FreeColGameObject> fit = this.getGame().getFreeColGameObjectIterator();
        while (fit.hasNext()) {
            FreeColGameObject f = fit.next();
            if (!(f instanceof Unit) && !(f instanceof Colony) && (!(f instanceof Player) || ((Player)f).isUnknownEnemy()) || this.aiObjects.containsKey(f.getId())) continue;
            logger.warning("Added missing AIObject for: " + f.getId());
            this.setFreeColGameObject(f.getId(), f);
        }
        return this.checkIntegrity();
    }

    private void findNewObjects() {
        this.findNewObjects(true);
    }

    public void findNewObjects(boolean overwrite) {
        Iterator<FreeColGameObject> i = this.freeColServer.getGame().getFreeColGameObjectIterator();
        while (i.hasNext()) {
            FreeColGameObject fcgo = i.next();
            if (!overwrite && this.getAIObject(fcgo) != null) continue;
            this.setFreeColGameObject(fcgo.getId(), fcgo);
        }
    }

    public AIObject getAIObject(FreeColGameObject fcgo) {
        return this.getAIObject(fcgo.getId());
    }

    public AIObject getAIObject(String id) {
        return this.aiObjects.get(id);
    }

    public AIColony getAIColony(Colony colony) {
        AIObject aio = this.getAIObject(colony.getId());
        return aio instanceof AIColony ? (AIColony)aio : null;
    }

    public AIPlayer getAIPlayer(Player player) {
        AIObject aio = this.getAIObject(player.getId());
        return aio instanceof AIPlayer ? (AIPlayer)aio : null;
    }

    public AIUnit getAIUnit(Unit unit) {
        AIObject aio = this.getAIObject(unit.getId());
        return aio instanceof AIUnit ? (AIUnit)aio : null;
    }

    public void addAIObject(String id, AIObject aiObject) {
        if (this.aiObjects.containsKey(id)) {
            throw new IllegalStateException("AIObject already created: " + id);
        }
        if (aiObject == null) {
            throw new NullPointerException("aiObject == null");
        }
        this.aiObjects.put(id, aiObject);
    }

    public void removeAIObject(String id) {
        this.aiObjects.remove(id);
    }

    @Override
    public void ownerChanged(FreeColGameObject source, Player oldOwner, Player newOwner) {
        AIObject ao = this.getAIObject(source);
        logger.finest("Owner changed for " + source.getId() + " with AI object: " + ao);
        if (ao != null) {
            ao.dispose();
            this.setFreeColGameObject(source.getId(), source);
        }
    }

    @Override
    public void setFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (this.aiObjects.containsKey(id)) {
            return;
        }
        if (!id.equals(fcgo.getId())) {
            throw new IllegalArgumentException("!id.equals(fcgo.getId())");
        }
        if (fcgo instanceof Colony) {
            new AIColony(this, (Colony)fcgo);
        } else if (fcgo instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)fcgo;
            if (p.isIndian()) {
                new NativeAIPlayer(this, p);
            } else if (p.isREF()) {
                new REFAIPlayer(this, p);
            } else if (p.isEuropean()) {
                new EuropeanAIPlayer(this, p);
            }
        } else if (fcgo instanceof Unit) {
            new AIUnit(this, (Unit)fcgo);
        }
    }

    @Override
    public void removeFreeColGameObject(String id) {
        AIObject o = this.getAIObject(id);
        if (o != null) {
            o.dispose();
        }
        this.removeAIObject(id);
    }

    public HashMap<String, String> getAIStatistics() {
        HashMap<String, String> stats = new HashMap<String, String>();
        HashMap<String, Long> objStats = new HashMap<String, Long>();
        for (AIObject obj : this.aiObjects.values()) {
            Long count;
            String className = obj.getClass().getSimpleName();
            if (objStats.containsKey(className)) {
                Long l = count = (Long)objStats.get(className);
                Long l2 = count = Long.valueOf(count + 1L);
                objStats.put(className, count);
                continue;
            }
            count = new Long(1L);
            objStats.put(className, count);
        }
        for (String k : objStats.keySet()) {
            stats.put(k, Long.toString((Long)objStats.get(k)));
        }
        return stats;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, AIMain.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        out.writeAttribute("nextID", Integer.toString(this.nextId));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (AIObject aio : new ArrayList<AIObject>(this.aiObjects.values())) {
            Wish wish;
            if (!aio.checkIntegrity()) {
                logger.warning("Integrity failure: " + aio);
                continue;
            }
            if (aio instanceof Wish && !(wish = (Wish)aio).shouldBeStored()) continue;
            try {
                if (aio.getId() == null) {
                    logger.warning("Null AI identifier for: " + aio.getClass().getName());
                    continue;
                }
                aio.toXML(out);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to write AI object: " + aio, e);
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        this.aiObjects.clear();
        if (!in.getLocalName().equals(AIMain.getXMLElementTagName())) {
            logger.warning("Expected element name, got: " + in.getLocalName());
        }
        this.nextId = this.getAttribute(in, "nextID", 0);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        String lastTag = "";
        while (in.nextTag() != 2) {
            String tagName = in.getLocalName();
            String oid = in.getAttributeValue(null, "ID");
            Wish wish = null;
            try {
                AIColony ac;
                if (oid != null && this.aiObjects.containsKey(oid)) {
                    this.getAIObject(oid).readFromXML(in);
                } else if (tagName.equals(AIUnit.getXMLElementTagName())) {
                    new AIUnit(this, in);
                } else if (tagName.equals(AIPlayer.getXMLElementTagName())) {
                    Player p = this.getGame().getFreeColGameObject(oid, Player.class);
                    if (p != null) {
                        if (p.isIndian()) {
                            new NativeAIPlayer(this, in);
                        } else if (p.isREF()) {
                            new REFAIPlayer(this, in);
                        } else if (p.isEuropean()) {
                            new EuropeanAIPlayer(this, in);
                        } else {
                            logger.warning("Bogus AIPlayer: " + p);
                            in.nextTag();
                        }
                    }
                } else if (tagName.equals("colonialAIPlayer")) {
                    new EuropeanAIPlayer(this, in);
                } else if (tagName.equals(AIColony.getXMLElementTagName())) {
                    new AIColony(this, in);
                } else if (tagName.equals(AIGoods.getXMLElementTagName())) {
                    new AIGoods(this, in);
                } else if (tagName.equals(WorkerWish.getXMLElementTagName())) {
                    wish = new WorkerWish(this, in);
                } else if (tagName.equals(GoodsWish.getXMLElementTagName()) || tagName.equals("GoodsWish")) {
                    wish = new GoodsWish(this, in);
                } else if (tagName.equals(TileImprovementPlan.getXMLElementTagName()) || tagName.equals("tileimprovementplan")) {
                    new TileImprovementPlan(this, in);
                } else {
                    throw new IllegalStateException("Unknown AI-object read: " + tagName + "(" + lastTag + ")");
                }
                if (wish != null && (ac = wish.getDestinationAIColony()) != null) {
                    ac.addWish(wish);
                }
                lastTag = in.getLocalName();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception reading AIObject(" + tagName + ", " + oid + ")", e);
                while (!in.getLocalName().equals(tagName) && !in.getLocalName().equals(AIMain.getXMLElementTagName())) {
                    in.nextTag();
                }
                if (in.getLocalName().equals(AIMain.getXMLElementTagName())) continue;
                in.nextTag();
            }
        }
        if (!in.getLocalName().equals(AIMain.getXMLElementTagName())) {
            logger.warning("Expected closing element name, got: " + in.getLocalName());
        }
        this.findNewObjects(false);
    }

    public static String getXMLElementTagName() {
        return "aiMain";
    }
}

