/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    public static String join(String delimiter, String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            result.append(delimiter);
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static String join(String delimiter, List<String> strings) {
        return Utils.join(delimiter, strings.toArray(new String[0]));
    }

    public static boolean equals(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }

    public static String lastPart(String s, String delim) {
        int last = s == null ? -1 : s.lastIndexOf(delim);
        return last > 0 ? s.substring(last + delim.length(), s.length()) : s;
    }

    public static <T, K> void appendToMapList(Map<K, List<T>> map, K key, T value) {
        List<T> l = map.get(key);
        if (l == null) {
            l = new ArrayList<T>();
            l.add(value);
            map.put(key, l);
        } else if (!l.contains(value)) {
            l.add(value);
        }
    }

    public static <T> Iterable<List<T>> getPermutations(final List<T> l) {
        if (l == null) {
            return null;
        }
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new Iterator<List<T>>(){
                    private final List<T> original;
                    private final int n;
                    private final int np;
                    private int index;
                    {
                        this.original = new ArrayList(l);
                        this.n = l.size();
                        this.np = this.factorial(this.n);
                        this.index = 0;
                    }

                    private int factorial(int n) {
                        int total = n;
                        while (--n > 1) {
                            total *= n;
                        }
                        return total;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.np;
                    }

                    @Override
                    public List<T> next() {
                        ArrayList pick = new ArrayList(this.original);
                        ArrayList result = new ArrayList();
                        int current = this.index++;
                        int divisor = this.np;
                        for (int i = this.n; i > 0; --i) {
                            int j = current / (divisor /= i);
                            result.add(pick.remove(j));
                            current -= j * divisor;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("remove() not implemented");
                    }
                };
            }
        };
    }

    public static String getUserDirectory() {
        return System.getProperty("user.home");
    }

    public static int randomInt(Logger logger, String logMe, Random random, int range) {
        int ret = random.nextInt(range);
        if (logger != null) {
            logger.finest(logMe + " random(" + range + ") = " + ret);
        }
        return ret;
    }

    public static int[] randomInts(Logger logger, String logMe, Random random, int range, int n) {
        int[] ret = new int[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = random.nextInt(range);
        }
        if (logger != null) {
            String msg = logMe + " random(" + range + ") = [";
            for (int i = 0; i < n; ++i) {
                msg = msg + " " + Integer.toString(ret[i]);
            }
            msg = msg + " ]";
            logger.finest(msg);
        }
        return ret;
    }

    public static double randomDouble(Logger logger, String logMe, Random random) {
        double ret = random.nextDouble();
        if (logger != null) {
            logger.finest(logMe + " random(1.0) = " + ret);
        }
        return ret;
    }

    public static <T> T getRandomMember(Logger logger, String logMe, List<T> list, Random random) {
        return list.get(Utils.randomInt(logger, logMe, random, list.size()));
    }

    public static synchronized String getRandomState(Random random) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(random);
            oos.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("IO exception in memory!?", e);
        }
        byte[] bytes = bos.toByteArray();
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static synchronized Random restoreRandomState(String state) {
        if (state == null || state.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[state.length() / 2];
        int pos = 0;
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)HEX_DIGITS.indexOf(state.charAt(pos++));
            int n = i;
            bytes[n] = (byte)(bytes[n] << 4);
            int n2 = i++;
            bytes[n2] = (byte)(bytes[n2] | (byte)HEX_DIGITS.indexOf(state.charAt(pos++)));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Random)ois.readObject();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to restore random state.", e);
            return null;
        }
    }
}

