/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.ModOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOption<T>
extends AbstractOption<List<AbstractOption<T>>> {
    private static Logger logger = Logger.getLogger(ListOption.class.getName());
    private List<AbstractOption<T>> value = new ArrayList<AbstractOption<T>>();
    private AbstractOption<T> template;
    private int maximumNumber = Integer.MAX_VALUE;

    public ListOption(String id) {
        super(id);
    }

    public ListOption(Specification specification) {
        super(specification);
    }

    @Override
    public ListOption<T> clone() {
        ListOption<T> result = new ListOption<T>(this.getId());
        return result;
    }

    public int getMaximumValue() {
        return this.maximumNumber;
    }

    public void setMaximumValue(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    @Override
    public List<AbstractOption<T>> getValue() {
        return this.value;
    }

    public List<T> getOptionValues() {
        ArrayList<T> result = new ArrayList<T>();
        for (AbstractOption<T> option : this.value) {
            if (option == null) continue;
            result.add(option.getValue());
        }
        return result;
    }

    @Override
    public void setValue(List<AbstractOption<T>> value) {
        if (value == null) {
            throw new IllegalArgumentException("ListOption value must not be 'null'!");
        }
        List<AbstractOption<T>> oldValue = this.value;
        this.value = value;
        if (!value.equals(oldValue) && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    public AbstractOption<T> getTemplate() {
        return this.template;
    }

    public void setTemplate(AbstractOption<T> template) {
        this.template = template;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out, ListOption.getXMLElementTagName());
    }

    protected void toXMLImpl(XMLStreamWriter out, String tag) throws XMLStreamException {
        out.writeStartElement(tag);
        out.writeAttribute("id", this.getId());
        out.writeAttribute("maximumNumber", Integer.toString(this.maximumNumber));
        if (this.template != null) {
            out.writeStartElement("template");
            this.template.toXML(out);
            out.writeEndElement();
        }
        for (AbstractOption<T> option : this.value) {
            option.toXML(out);
        }
        out.writeEndElement();
    }

    @Override
    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "id"));
        this.maximumNumber = this.getAttribute(in, "maximumNumber", 1);
        this.value.clear();
        while (in.nextTag() != 2) {
            if ("template".equals(in.getLocalName())) {
                in.nextTag();
                this.template = this.readOption(in);
                in.nextTag();
                continue;
            }
            if ("optionValue".equals(in.getLocalName())) {
                String modId = in.getAttributeValue(null, "id");
                logger.finest("found old-style mod value: " + modId);
                ModOption modOption = new ModOption(modId);
                modOption.setValue(Mods.getModFile(modId));
                this.value.add(modOption);
                continue;
            }
            this.value.add(this.readOption(in));
        }
    }

    public static String getXMLElementTagName() {
        return "listOption";
    }
}

