/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.SetTradeRoutesMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class UpdateTradeRouteMessage
extends DOMMessage {
    private TradeRoute tradeRoute;

    public UpdateTradeRouteMessage(TradeRoute tradeRoute) {
        this.tradeRoute = tradeRoute;
    }

    public UpdateTradeRouteMessage(Game game, Element element) {
        this.tradeRoute = element.getChildNodes().getLength() != 1 ? null : SetTradeRoutesMessage.tradeRouteFromElement(game, (Element)element.getChildNodes().item(0));
    }

    public Element handle(FreeColServer server, Connection connection) {
        TradeRoute realRoute;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (this.tradeRoute == null || this.tradeRoute.getId() == null || !SetTradeRoutesMessage.hasPrefix(this.tradeRoute)) {
            return DOMMessage.clientError("Bogus route");
        }
        String id = SetTradeRoutesMessage.removePrefix(this.tradeRoute);
        try {
            realRoute = serverPlayer.getFreeColGameObject(id, TradeRoute.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        realRoute.updateFrom(this.tradeRoute);
        this.tradeRoute.dispose();
        return null;
    }

    public Element toXMLElement() {
        Element result = UpdateTradeRouteMessage.createMessage(UpdateTradeRouteMessage.getXMLElementTagName(), new String[0]);
        result.appendChild(this.tradeRoute.toXMLElement(null, result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "updateTradeRoute";
    }
}

