/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class PayForBuildingMessage
extends DOMMessage {
    private String colonyId;

    public PayForBuildingMessage(Colony colony) {
        this.colonyId = colony.getId();
    }

    public PayForBuildingMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            colony = player.getFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().payForBuilding(serverPlayer, colony);
    }

    public Element toXMLElement() {
        return PayForBuildingMessage.createMessage(PayForBuildingMessage.getXMLElementTagName(), "colony", this.colonyId);
    }

    public static String getXMLElementTagName() {
        return "payForBuilding";
    }
}

