/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class MoveToMessage
extends DOMMessage {
    private String unitId;
    private String destinationId;

    public MoveToMessage(Unit unit, Location destination) {
        this.unitId = unit.getId();
        this.destinationId = destination.getId();
    }

    public MoveToMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.destinationId = element.getAttribute("destination");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = player.getGame();
        try {
            unit = player.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Location destination = game.getFreeColLocation(this.destinationId);
        if (destination == null) {
            return DOMMessage.clientError("Not a location: " + this.destinationId);
        }
        return server.getInGameController().moveTo(serverPlayer, unit, destination);
    }

    public Element toXMLElement() {
        return DOMMessage.createMessage(MoveToMessage.getXMLElementTagName(), "unit", this.unitId, "destination", this.destinationId);
    }

    public static String getXMLElementTagName() {
        return "moveTo";
    }
}

