/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class EmigrateUnitMessage
extends DOMMessage {
    private String slotString;

    public EmigrateUnitMessage(int slot) {
        this.slotString = Integer.toString(slot);
    }

    public EmigrateUnitMessage(Game game, Element element) {
        this.slotString = element.getAttribute("slot");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Europe.MigrationType type;
        int slot;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Europe europe = player.getEurope();
        if (europe == null) {
            return DOMMessage.clientError("No Europe to migrate from.");
        }
        try {
            slot = Integer.parseInt(this.slotString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad slot: " + this.slotString);
        }
        boolean selected = 1 <= slot && slot <= 3;
        int remaining = serverPlayer.getRemainingEmigrants();
        if (remaining > 0) {
            if (!selected) {
                return DOMMessage.clientError("Invalid slot for FoY migration.");
            }
            type = Europe.MigrationType.FOUNTAIN;
        } else if (player.checkEmigrate()) {
            if (selected) {
                if (!player.hasAbility("model.ability.selectRecruit")) {
                    return DOMMessage.clientError("selectRecruit ability absent.");
                }
            } else if (slot != 0) {
                return DOMMessage.clientError("Invalid slot for normal migration.");
            }
            type = Europe.MigrationType.NORMAL;
        } else if (player.checkGold(europe.getRecruitPrice())) {
            if (!selected && slot != 0) {
                return DOMMessage.clientError("Invalid slot for recruitment: " + slot);
            }
            type = Europe.MigrationType.RECRUIT;
        } else {
            return DOMMessage.clientError("No migrants available.");
        }
        return server.getInGameController().emigrate(serverPlayer, slot, type);
    }

    public Element toXMLElement() {
        return EmigrateUnitMessage.createMessage(EmigrateUnitMessage.getXMLElementTagName(), "slot", this.slotString);
    }

    public static String getXMLElementTagName() {
        return "emigrateUnit";
    }
}

