/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import org.w3c.dom.Element;

public final class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private final Connection c;
    private String host;
    private int port;

    public Client(String host, int port, MessageHandler handler, String name) throws IOException {
        this.host = host;
        this.port = port;
        this.c = new Connection(host, port, handler, name);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Connection getConnection() {
        return this.c;
    }

    public void setMessageHandler(MessageHandler mh) {
        this.c.setMessageHandler(mh);
    }

    public void disconnect() {
        this.c.close();
    }

    public void send(Element element) {
        try {
            this.c.sendDumping(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send: " + element, e);
        }
    }

    public void sendAndWait(Element element) {
        try {
            this.c.sendAndWait(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not sendAndWait: " + element, e);
        }
    }

    public Element ask(Element element) {
        try {
            return this.c.askDumping(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not ask: " + element, e);
            return null;
        }
    }

    public void handleReply(Element reply) {
        if (reply != null) {
            try {
                this.c.getMessageHandler().handle(this.c, reply);
            }
            catch (FreeColException e) {
                logger.log(Level.WARNING, "Could not handle reply: " + reply, e);
            }
        }
    }
}

