/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ClearSpecialityMessage
extends DOMMessage {
    private String unitId;

    public ClearSpecialityMessage(Unit unit) {
        this.unitId = unit.getId();
    }

    public ClearSpecialityMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().clearSpeciality(serverPlayer, unit);
    }

    public Element toXMLElement() {
        return ClearSpecialityMessage.createMessage(ClearSpecialityMessage.getXMLElementTagName(), "unit", this.unitId);
    }

    public static String getXMLElementTagName() {
        return "clearSpeciality";
    }
}

