/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitTypeChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitType
extends BuildableType
implements Comparable<UnitType>,
Consumer {
    public static final int DEFAULT_OFFENCE = 0;
    public static final int DEFAULT_DEFENCE = 1;
    private int offence = 0;
    private int defence = 1;
    private int space = 0;
    private int hitPoints = 0;
    private int spaceTaken = 1;
    private int skill = Integer.MIN_VALUE;
    private int price = Integer.MIN_VALUE;
    private int movement = 3;
    private int lineOfSight = 1;
    private int recruitProbability = 0;
    private GoodsType expertProduction = null;
    private int scoreValue = 0;
    private int maximumExperience = 0;
    private int maximumAttrition = Integer.MAX_VALUE;
    private UnitType skillTaught = null;
    private EquipmentType defaultEquipment = null;
    private List<UnitTypeChange> typeChanges = null;
    private TypeCountMap<GoodsType> consumption = null;
    private static final String CONSUMES_TAG = "consumes";
    private static final String DEFAULT_EQUIPMENT_TAG = "default-equipment";
    private static final String DEFENCE_TAG = "defence";
    private static final String EXPERT_PRODUCTION_TAG = "expert-production";
    private static final String HIT_POINTS_TAG = "hitPoints";
    private static final String LINE_OF_SIGHT_TAG = "lineOfSight";
    private static final String MOVEMENT_TAG = "movement";
    private static final String MAXIMUM_EXPERIENCE_TAG = "maximumExperience";
    private static final String MAXIMUM_ATTRITION_TAG = "maximumAttrition";
    private static final String OFFENCE_TAG = "offence";
    private static final String PRICE_TAG = "price";
    private static final String RECRUIT_PROBABILITY_TAG = "recruitProbability";
    private static final String SCORE_VALUE_TAG = "scoreValue";
    private static final String SKILL_TAG = "skill";
    private static final String SKILL_TAUGHT_TAG = "skillTaught";
    private static final String SPACE_TAG = "space";
    private static final String SPACE_TAKEN_TAG = "spaceTaken";
    private static final String DOWNGRADE_TAG = "downgrade";
    private static final String UNIT_TAG = "unit";
    private static final String UPGRADE_TAG = "upgrade";

    public UnitType(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.EXPERT_PRODUCTION_INDEX);
    }

    public final String getWorkingAsKey() {
        return this.getId() + ".workingAs";
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public int getScoreValue() {
        return this.scoreValue;
    }

    public int getOffence() {
        return this.offence;
    }

    public boolean isOffensive() {
        return this.getOffence() > 0;
    }

    public int getDefence() {
        return this.defence;
    }

    public boolean isDefensive() {
        return this.getDefence() > 1;
    }

    public int getLineOfSight() {
        return this.lineOfSight;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int newSpace) {
        this.space = newSpace;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public int getSpaceTaken() {
        return Math.max(this.spaceTaken, this.space + 1);
    }

    public void setSpaceTaken(int newSpaceTaken) {
        this.spaceTaken = newSpaceTaken;
    }

    public boolean isRecruitable() {
        return this.recruitProbability > 0;
    }

    public int getRecruitProbability() {
        return this.recruitProbability;
    }

    public int getSkill() {
        return this.skill;
    }

    public void setSkill(int newSkill) {
        this.skill = newSkill;
    }

    public int getPrice() {
        return this.price;
    }

    public int getMovement() {
        return this.movement;
    }

    public final int getMaximumExperience() {
        return this.maximumExperience;
    }

    public int getMaximumAttrition() {
        return this.maximumAttrition;
    }

    public GoodsType getExpertProduction() {
        return this.expertProduction;
    }

    public UnitType getSkillTaught() {
        return this.skillTaught;
    }

    public EquipmentType getDefaultEquipmentType() {
        return this.defaultEquipment;
    }

    public EquipmentType[] getDefaultEquipment() {
        if (this.hasAbility("model.ability.canBeEquipped") && this.defaultEquipment != null) {
            int count = this.defaultEquipment.getMaximumCount();
            EquipmentType[] result = new EquipmentType[count];
            for (int index = 0; index < count; ++index) {
                result[index] = this.defaultEquipment;
            }
            return result;
        }
        return EquipmentType.NO_EQUIPMENT;
    }

    public List<UnitTypeChange> getTypeChanges() {
        return this.typeChanges == null ? new ArrayList() : this.typeChanges;
    }

    public void setTypeChanges(List<UnitTypeChange> typeChanges) {
        this.typeChanges = typeChanges;
    }

    public UnitType getTargetType(UnitTypeChange.ChangeType changeType, Player player) {
        UnitTypeChange change = this.getUnitTypeChange(changeType, player);
        return change == null ? null : change.getNewUnitType();
    }

    public UnitTypeChange getUnitTypeChange(UnitTypeChange.ChangeType changeType, Player player) {
        for (UnitTypeChange change : this.getTypeChanges()) {
            UnitType result;
            if (!change.asResultOf(changeType) || !change.appliesTo(player) || !(result = change.getNewUnitType()).isAvailableTo(player)) continue;
            return change;
        }
        return null;
    }

    public UnitTypeChange getUnitTypeChange(UnitType newType) {
        for (UnitTypeChange change : this.getTypeChanges()) {
            if (change.getNewUnitType() != newType) continue;
            return change;
        }
        return null;
    }

    public boolean canBeUpgraded(UnitType newType, UnitTypeChange.ChangeType changeType) {
        for (UnitTypeChange change : this.getTypeChanges()) {
            if (newType != null && newType != change.getNewUnitType() || change.getProbability(changeType) <= 0) continue;
            return true;
        }
        return false;
    }

    public List<UnitType> getUnitTypesLearntInLostCity() {
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (UnitTypeChange change : this.getTypeChanges()) {
            if (!change.asResultOf(UnitTypeChange.ChangeType.LOST_CITY)) continue;
            unitTypes.add(change.getNewUnitType());
        }
        return unitTypes;
    }

    public UnitType getEducationUnit(int maximumSkill) {
        for (UnitTypeChange change : this.getTypeChanges()) {
            UnitType unitType;
            if (!change.canBeTaught() || !(unitType = change.getNewUnitType()).hasSkill() || unitType.getSkill() > maximumSkill) continue;
            return unitType;
        }
        return null;
    }

    public int getEducationTurns(UnitType unitType) {
        for (UnitTypeChange change : this.getTypeChanges()) {
            if (!change.asResultOf(UnitTypeChange.ChangeType.EDUCATION) || unitType != change.getNewUnitType()) continue;
            return change.getTurnsToLearn();
        }
        return Integer.MIN_VALUE;
    }

    public boolean isNaval() {
        return this.hasAbility("model.ability.navalUnit");
    }

    public boolean canMoveToHighSeas() {
        return this.isNaval();
    }

    public boolean hasSkill() {
        return this.skill != Integer.MIN_VALUE;
    }

    public boolean hasPrice() {
        return this.price != Integer.MIN_VALUE;
    }

    public int getConsumptionOf(GoodsType goodsType) {
        return this.consumption == null ? 0 : this.consumption.getCount(goodsType);
    }

    @Override
    public int compareTo(UnitType other) {
        return this.getIndex() - other.getIndex();
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        if (this.consumption != null) {
            for (GoodsType goodsType : this.consumption.keySet()) {
                result.add(new AbstractGoods(goodsType, this.consumption.getCount(goodsType)));
            }
        }
        return result;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    public boolean canBuildColony() {
        return this.hasAbility("model.ability.foundColony");
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, UnitType.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, OFFENCE_TAG, this.offence);
        this.writeAttribute(out, DEFENCE_TAG, this.defence);
        this.writeAttribute(out, MOVEMENT_TAG, this.movement);
        this.writeAttribute(out, LINE_OF_SIGHT_TAG, this.lineOfSight);
        this.writeAttribute(out, SCORE_VALUE_TAG, this.scoreValue);
        this.writeAttribute(out, SPACE_TAG, this.space);
        this.writeAttribute(out, SPACE_TAKEN_TAG, this.spaceTaken);
        this.writeAttribute(out, HIT_POINTS_TAG, this.hitPoints);
        this.writeAttribute(out, MAXIMUM_EXPERIENCE_TAG, this.maximumExperience);
        if (this.maximumAttrition < Integer.MAX_VALUE) {
            this.writeAttribute(out, MAXIMUM_ATTRITION_TAG, this.maximumAttrition);
        }
        this.writeAttribute(out, RECRUIT_PROBABILITY_TAG, this.recruitProbability);
        if (this.hasSkill()) {
            this.writeAttribute(out, SKILL_TAG, this.skill);
        }
        if (this.hasPrice()) {
            this.writeAttribute(out, PRICE_TAG, this.price);
        }
        this.writeAttribute(out, SKILL_TAUGHT_TAG, this.skillTaught);
        if (this.expertProduction != null) {
            this.writeAttribute(out, EXPERT_PRODUCTION_TAG, this.expertProduction);
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.defaultEquipment != null) {
            out.writeStartElement(DEFAULT_EQUIPMENT_TAG);
            this.writeAttribute(out, "id", this.defaultEquipment);
            out.writeEndElement();
        }
        if (this.typeChanges != null) {
            for (UnitTypeChange change : this.typeChanges) {
                change.toXMLImpl(out);
            }
        }
        if (this.consumption != null) {
            for (GoodsType goodsType : this.consumption.keySet()) {
                out.writeStartElement(CONSUMES_TAG);
                this.writeAttribute(out, "id", goodsType);
                this.writeAttribute(out, "value", this.consumption.getCount(goodsType));
                out.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        Specification spec = this.getSpecification();
        UnitType parent = spec.getType(in, "extends", UnitType.class, this);
        this.offence = this.getAttribute(in, OFFENCE_TAG, parent.offence);
        this.defence = this.getAttribute(in, DEFENCE_TAG, parent.defence);
        this.movement = this.getAttribute(in, MOVEMENT_TAG, parent.movement);
        this.lineOfSight = this.getAttribute(in, LINE_OF_SIGHT_TAG, parent.lineOfSight);
        this.scoreValue = this.getAttribute(in, SCORE_VALUE_TAG, parent.scoreValue);
        this.space = this.getAttribute(in, SPACE_TAG, parent.space);
        this.hitPoints = this.getAttribute(in, HIT_POINTS_TAG, parent.hitPoints);
        this.spaceTaken = this.getAttribute(in, SPACE_TAKEN_TAG, parent.spaceTaken);
        this.maximumExperience = this.getAttribute(in, MAXIMUM_EXPERIENCE_TAG, parent.maximumExperience);
        this.maximumAttrition = this.getAttribute(in, MAXIMUM_ATTRITION_TAG, parent.maximumAttrition);
        this.skillTaught = spec.getType(in, SKILL_TAUGHT_TAG, UnitType.class, this);
        this.recruitProbability = this.getAttribute(in, RECRUIT_PROBABILITY_TAG, parent.recruitProbability);
        this.skill = this.getAttribute(in, SKILL_TAG, parent.skill);
        this.price = this.getAttribute(in, PRICE_TAG, parent.price);
        this.expertProduction = spec.getType(in, EXPERT_PRODUCTION_TAG, GoodsType.class, parent.expertProduction);
        if (parent != this && !this.hasAttribute(in, "required-population")) {
            this.setRequiredPopulation(parent.getRequiredPopulation());
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        Specification spec;
        UnitType parent;
        if (this.readShouldClearContainers(in)) {
            this.consumption = null;
            this.defaultEquipment = null;
            this.typeChanges = null;
        }
        if ((parent = (spec = this.getSpecification()).getType(in, "extends", UnitType.class, this)) != this) {
            this.defaultEquipment = parent.defaultEquipment;
            if (parent.typeChanges != null) {
                if (this.typeChanges == null) {
                    this.typeChanges = new ArrayList<UnitTypeChange>();
                }
                this.typeChanges.addAll(parent.typeChanges);
            }
            if (parent.consumption != null) {
                if (this.consumption == null) {
                    this.consumption = new TypeCountMap();
                }
                this.consumption.putAll(parent.consumption);
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
        super.readChildren(in);
        if (this.hasAbility("model.ability.person")) {
            if (!this.containsModifierKey("model.modifier.conversionSkill")) {
                this.addModifier(new Modifier("model.modifier.conversionSkill", 8.0f, Modifier.Type.ADDITIVE));
                if (this.hasAbility("model.ability.expertMissionary")) {
                    this.addModifier(new Modifier("model.modifier.conversionSkill", 5.0f, Modifier.Type.ADDITIVE));
                }
            }
            if (!this.containsModifierKey("model.modifier.conversionAlarmRate")) {
                this.addModifier(new Modifier("model.modifier.conversionAlarmRate", 2.0f, Modifier.Type.PERCENTAGE));
            }
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = in.getLocalName();
        if (CONSUMES_TAG.equals(tag)) {
            GoodsType type = spec.getType(in, "id", GoodsType.class, null);
            int amount = this.getAttribute(in, "value", Integer.MIN_VALUE);
            if (type != null && amount != Integer.MIN_VALUE) {
                if (this.consumption == null) {
                    this.consumption = new TypeCountMap();
                }
                this.consumption.incrementCount(type, amount);
            }
            in.nextTag();
        } else if (DEFAULT_EQUIPMENT_TAG.equals(tag)) {
            this.defaultEquipment = spec.getType(in, "id", EquipmentType.class, null);
            in.nextTag();
        } else if (DOWNGRADE_TAG.equals(tag) || UPGRADE_TAG.equals(tag)) {
            if (this.getAttribute(in, "delete", false)) {
                if (this.typeChanges != null) {
                    String unitId = this.getAttribute(in, UNIT_TAG, null);
                    Iterator<UnitTypeChange> it = this.typeChanges.iterator();
                    while (it.hasNext()) {
                        if (!unitId.equals(it.next().getNewUnitType().getId())) continue;
                        it.remove();
                        break;
                    }
                }
                in.nextTag();
            } else {
                UnitTypeChange change = new UnitTypeChange(in, spec);
                if (DOWNGRADE_TAG.equals(tag) && change.getChangeTypes().isEmpty()) {
                    change.getChangeTypes().put(UnitTypeChange.ChangeType.CLEAR_SKILL, 100);
                }
                if (this.typeChanges == null) {
                    this.typeChanges = new ArrayList<UnitTypeChange>();
                }
                this.typeChanges.add(change);
            }
        } else {
            super.readChild(in);
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }

    public static String getXMLElementTagName() {
        return "unit-type";
    }
}

