/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;

public abstract class TradeItem
extends FreeColObject {
    protected Game game;
    private Player source;
    private Player destination;

    public TradeItem(Game game, String id, Player source, Player destination) {
        this.game = game;
        this.setId(id);
        this.source = source;
        this.destination = destination;
    }

    public TradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        this.game = game;
    }

    public final Player getSource() {
        return this.source;
    }

    public final void setSource(Player newSource) {
        this.source = newSource;
    }

    public final Player getDestination() {
        return this.destination;
    }

    public final void setDestination(Player newDestination) {
        this.destination = newDestination;
    }

    public abstract boolean isValid();

    public abstract boolean isUnique();

    public Colony getColony() {
        return null;
    }

    public void setColony(Colony colony) {
    }

    public Goods getGoods() {
        return null;
    }

    public void setGoods(Goods goods) {
    }

    public int getGold() {
        return 0;
    }

    public void setGold(int gold) {
    }

    public Player.Stance getStance() {
        return null;
    }

    public void setStance(Player.Stance stance) {
    }

    public Unit getUnit() {
        return null;
    }

    public void setUnit(Unit unit) {
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("source", this.source.getId());
        out.writeAttribute("destination", this.destination.getId());
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        String src = in.getAttributeValue(null, "source");
        this.source = this.game.getFreeColGameObject(src, Player.class);
        String dst = in.getAttributeValue(null, "destination");
        this.destination = this.game.getFreeColGameObject(dst, Player.class);
    }
}

