/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;

public abstract class TileItem
extends FreeColGameObject
implements Locatable {
    public static final int RESOURCE_ZINDEX = 400;
    public static final int RUMOUR_ZINDEX = 500;
    protected Tile tile;

    public TileItem(Game game, Tile tile) {
        super(game);
        if (tile == null) {
            throw new IllegalArgumentException("Parameter 'tile' must not be 'null'.");
        }
        this.tile = tile;
    }

    public TileItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public TileItem(Game game, String id) {
        super(game, id);
    }

    public void setLocation(Location newLocation) {
        if (!(newLocation instanceof Tile)) {
            throw new IllegalArgumentException("newLocation is not a Tile");
        }
        this.tile = (Tile)newLocation;
    }

    public Location getLocation() {
        return this.tile;
    }

    public boolean isInEurope() {
        return false;
    }

    public Tile getTile() {
        return this.tile;
    }

    public int getSpaceTaken() {
        return 0;
    }

    public abstract int getZIndex();

    public abstract boolean isTileTypeAllowed(TileType var1);
}

