/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitListOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Specification {
    public static final FreeColGameObjectType MOVEMENT_PENALTY_SOURCE = new FreeColGameObjectType("model.source.movementPenalty");
    public static final FreeColGameObjectType ARTILLERY_PENALTY_SOURCE = new FreeColGameObjectType("model.source.artilleryInTheOpen");
    public static final FreeColGameObjectType ATTACK_BONUS_SOURCE = new FreeColGameObjectType("model.source.attackBonus");
    public static final FreeColGameObjectType FORTIFICATION_BONUS_SOURCE = new FreeColGameObjectType("model.source.fortified");
    public static final FreeColGameObjectType INDIAN_RAID_BONUS_SOURCE = new FreeColGameObjectType("model.source.artilleryAgainstRaid");
    public static final FreeColGameObjectType AMPHIBIOUS_ATTACK_PENALTY_SOURCE = new FreeColGameObjectType("model.source.amphibiousAttack");
    public static final FreeColGameObjectType BASE_OFFENCE_SOURCE = new FreeColGameObjectType("model.source.baseOffence");
    public static final FreeColGameObjectType BASE_DEFENCE_SOURCE = new FreeColGameObjectType("model.source.baseDefence");
    public static final FreeColGameObjectType CARGO_PENALTY_SOURCE = new FreeColGameObjectType("model.source.cargoPenalty");
    public static final FreeColGameObjectType AMBUSH_BONUS_SOURCE = new FreeColGameObjectType("model.source.ambushBonus");
    public static final FreeColGameObjectType COLONY_GOODS_PARTY_SOURCE = new FreeColGameObjectType("model.source.colonyGoodsParty");
    public static final FreeColGameObjectType SHIP_TRADE_PENALTY_SOURCE = new FreeColGameObjectType("model.source.shipTradePenalty");
    private static final Logger logger = Logger.getLogger(Specification.class.getName());
    private final Map<String, FreeColGameObjectType> allTypes = new HashMap<String, FreeColGameObjectType>();
    private final Map<String, AbstractOption> allOptions = new HashMap<String, AbstractOption>();
    private final Map<String, OptionGroup> allOptionGroups = new HashMap<String, OptionGroup>();
    private final Map<GoodsType, UnitType> experts = new HashMap<GoodsType, UnitType>();
    private final Map<String, List<Ability>> allAbilities = new HashMap<String, List<Ability>>();
    private final Map<String, List<Modifier>> allModifiers = new HashMap<String, List<Modifier>>();
    private final List<BuildingType> buildingTypeList = new ArrayList<BuildingType>();
    private final List<GoodsType> goodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> farmedGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> foodGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> newWorldGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> libertyGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> immigrationGoodsTypeList = new ArrayList<GoodsType>();
    private final List<GoodsType> rawBuildingGoodsTypeList = new ArrayList<GoodsType>();
    private final List<ResourceType> resourceTypeList = new ArrayList<ResourceType>();
    private final List<TileType> tileTypeList = new ArrayList<TileType>();
    private final List<TileImprovementType> tileImprovementTypeList = new ArrayList<TileImprovementType>();
    private final List<UnitType> unitTypeList = new ArrayList<UnitType>();
    private final List<UnitType> unitTypesTrainedInEurope = new ArrayList<UnitType>();
    private final List<UnitType> unitTypesPurchasedInEurope = new ArrayList<UnitType>();
    private final List<FoundingFather> foundingFathers = new ArrayList<FoundingFather>();
    private final List<Nation> nations = new ArrayList<Nation>();
    private final List<Nation> europeanNations = new ArrayList<Nation>();
    private final List<Nation> REFNations = new ArrayList<Nation>();
    private final List<Nation> indianNations = new ArrayList<Nation>();
    private final List<NationType> nationTypes = new ArrayList<NationType>();
    private final List<EuropeanNationType> europeanNationTypes = new ArrayList<EuropeanNationType>();
    private final List<EuropeanNationType> REFNationTypes = new ArrayList<EuropeanNationType>();
    private final List<IndianNationType> indianNationTypes = new ArrayList<IndianNationType>();
    private final List<EquipmentType> equipmentTypes = new ArrayList<EquipmentType>();
    private final List<Role> roles = new ArrayList<Role>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<Disaster> disasters = new ArrayList<Disaster>();
    private final List<Modifier> specialModifiers = new ArrayList<Modifier>();
    private final Map<String, ChildReader> readerMap = new HashMap<String, ChildReader>();
    private int storableTypes = 0;
    private boolean initialized = false;
    private String id;
    private String difficultyLevel;
    private UnitType cachedFastestLandUnitType = null;
    private UnitType cachedFastestNavalUnitType = null;

    public Specification(InputStream in) {
        this();
        this.initialized = false;
        this.load(in);
        this.clean();
        this.initialized = true;
    }

    public Specification() {
        logger.fine("Initializing Specification");
        for (FreeColGameObjectType source : new FreeColGameObjectType[]{MOVEMENT_PENALTY_SOURCE, ARTILLERY_PENALTY_SOURCE, ATTACK_BONUS_SOURCE, FORTIFICATION_BONUS_SOURCE, INDIAN_RAID_BONUS_SOURCE, AMPHIBIOUS_ATTACK_PENALTY_SOURCE, BASE_OFFENCE_SOURCE, BASE_DEFENCE_SOURCE, CARGO_PENALTY_SOURCE, AMBUSH_BONUS_SOURCE, COLONY_GOODS_PARTY_SOURCE}) {
            this.allTypes.put(source.getId(), source);
        }
        this.readerMap.put("nations", new TypeReader<Nation>(Nation.class, this.nations));
        this.readerMap.put("building-types", new TypeReader<BuildingType>(BuildingType.class, this.buildingTypeList));
        this.readerMap.put("european-nation-types", new TypeReader<EuropeanNationType>(EuropeanNationType.class, this.europeanNationTypes));
        this.readerMap.put("roles", new TypeReader<Role>(Role.class, this.roles));
        this.readerMap.put("equipment-types", new TypeReader<EquipmentType>(EquipmentType.class, this.equipmentTypes));
        this.readerMap.put("events", new TypeReader<Event>(Event.class, this.events));
        this.readerMap.put("disasters", new TypeReader<Disaster>(Disaster.class, this.disasters));
        this.readerMap.put("founding-fathers", new TypeReader<FoundingFather>(FoundingFather.class, this.foundingFathers));
        this.readerMap.put("goods-types", new TypeReader<GoodsType>(GoodsType.class, this.goodsTypeList));
        this.readerMap.put("indian-nation-types", new TypeReader<IndianNationType>(IndianNationType.class, this.indianNationTypes));
        this.readerMap.put("resource-types", new TypeReader<ResourceType>(ResourceType.class, this.resourceTypeList));
        this.readerMap.put("tile-types", new TypeReader<TileType>(TileType.class, this.tileTypeList));
        this.readerMap.put("tileimprovement-types", new TypeReader<TileImprovementType>(TileImprovementType.class, this.tileImprovementTypeList));
        this.readerMap.put("unit-types", new TypeReader<UnitType>(UnitType.class, this.unitTypeList));
        this.readerMap.put("modifiers", new ModifierReader());
        this.readerMap.put("options", new OptionReader());
    }

    private void load(InputStream in) {
        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in);
            xsr.nextTag();
            this.readFromXML(xsr);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Load exception", e);
            throw new RuntimeException("Error parsing specification: " + e.getMessage());
        }
    }

    public void loadFragment(InputStream in) {
        this.initialized = false;
        this.load(in);
        this.initialized = true;
    }

    public void clean() {
        logger.finest("Cleaning up specification.");
        Iterator<FreeColGameObjectType> typeIterator = this.allTypes.values().iterator();
        while (typeIterator.hasNext()) {
            FreeColGameObjectType type = typeIterator.next();
            if (!type.isAbstractType()) continue;
            typeIterator.remove();
        }
        for (Nation nation : this.nations) {
            if (nation.getType().isEuropean()) {
                if (nation.getType().isREF()) {
                    this.REFNations.add(nation);
                    continue;
                }
                this.europeanNations.add(nation);
                continue;
            }
            this.indianNations.add(nation);
        }
        this.nationTypes.addAll(this.indianNationTypes);
        this.nationTypes.addAll(this.europeanNationTypes);
        Iterator<EuropeanNationType> iterator = this.europeanNationTypes.iterator();
        while (iterator.hasNext()) {
            EuropeanNationType nationType = iterator.next();
            if (!nationType.isREF()) continue;
            this.REFNationTypes.add(nationType);
            iterator.remove();
        }
        for (UnitType unitType : this.unitTypeList) {
            if (unitType.getExpertProduction() != null) {
                this.experts.put(unitType.getExpertProduction(), unitType);
            }
            if (!unitType.hasPrice()) continue;
            if (unitType.getSkill() > 0) {
                this.unitTypesTrainedInEurope.add(unitType);
                continue;
            }
            if (unitType.hasSkill()) continue;
            this.unitTypesPurchasedInEurope.add(unitType);
        }
        for (GoodsType goodsType : this.goodsTypeList) {
            if (goodsType.isFarmed()) {
                this.farmedGoodsTypeList.add(goodsType);
            }
            if (goodsType.isFoodType()) {
                this.foodGoodsTypeList.add(goodsType);
            }
            if (goodsType.isNewWorldGoodsType()) {
                this.newWorldGoodsTypeList.add(goodsType);
            }
            if (goodsType.isLibertyType()) {
                this.libertyGoodsTypeList.add(goodsType);
            }
            if (goodsType.isImmigrationType()) {
                this.immigrationGoodsTypeList.add(goodsType);
            }
            if (goodsType.isRawBuildingMaterial() && !goodsType.isFoodType()) {
                this.rawBuildingGoodsTypeList.add(goodsType);
            }
            if (!goodsType.isStorable()) continue;
            ++this.storableTypes;
        }
        for (AbstractOption option : this.allOptions.values()) {
            option.generateChoices();
        }
        if (this.difficultyLevel != null) {
            this.applyDifficultyLevel(this.difficultyLevel);
        }
        try {
            int startingYear = this.getInteger("model.option.startingYear");
            int seasonYear = this.getInteger("model.option.seasonYear");
            if (seasonYear < startingYear) {
                seasonYear = startingYear;
            }
            Turn.setStartingYear(startingYear);
            Turn.setSeasonYear(seasonYear);
            logger.info("Initialized turn, starting year=" + Integer.toString(Turn.getStartingYear()) + ", season year=" + Integer.toString(Turn.getSeasonYear()));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set year options", e);
        }
        OptionGroup prices = new OptionGroup("gameOptions.prices", this);
        for (GoodsType goodsType : this.goodsTypeList) {
            String name = goodsType.getSuffix("model.goods.");
            if (goodsType.getInitialSellPrice() > 0) {
                int diff = goodsType.isNewWorldGoodsType() || goodsType.isNewWorldLuxuryType() ? 3 : 0;
                IntegerOption minimum = new IntegerOption("model.option." + name + ".minimumPrice", this);
                minimum.setValue(goodsType.getInitialSellPrice());
                minimum.setMinimumValue(1);
                minimum.setMaximumValue(100);
                prices.add(minimum);
                this.addAbstractOption(minimum);
                IntegerOption maximum = new IntegerOption("model.option." + name + ".maximumPrice", this);
                maximum.setValue(goodsType.getInitialSellPrice() + diff);
                maximum.setMinimumValue(1);
                maximum.setMaximumValue(100);
                prices.add(maximum);
                this.addAbstractOption(maximum);
                IntegerOption spread = new IntegerOption("model.option." + name + ".spread", this);
                spread.setValue(goodsType.getPriceDifference());
                spread.setMinimumValue(1);
                spread.setMaximumValue(100);
                prices.add(spread);
                this.addAbstractOption(spread);
                continue;
            }
            if (goodsType.getPrice() >= Integer.MAX_VALUE) continue;
            IntegerOption price = new IntegerOption("model.option." + name + ".price", this);
            price.setValue(goodsType.getPrice());
            price.setMinimumValue(1);
            price.setMaximumValue(100);
            prices.add(price);
            this.addAbstractOption(price);
        }
        this.getOptionGroup("gameOptions").add(prices);
        this.allOptionGroups.put(this.id, prices);
        logger.info("Specification initialization complete. " + this.allTypes.size() + " FreeColGameObjectTypes,\n" + this.allOptions.size() + " Options, " + this.allAbilities.size() + " Abilities, " + this.allModifiers.size() + " Modifiers read.");
    }

    public String getId() {
        return this.id;
    }

    public void addAbility(Ability ability) {
        String id = ability.getId();
        this.addAbility(id);
        this.allAbilities.get(id).add(ability);
    }

    public void addAbility(String id) {
        if (!this.allAbilities.containsKey(id)) {
            this.allAbilities.put(id, new ArrayList());
        }
    }

    public List<Ability> getAbilities(String id) {
        return this.allAbilities.get(id);
    }

    public List<FreeColGameObjectType> getTypesProviding(String id, boolean value) {
        ArrayList<FreeColGameObjectType> result = new ArrayList<FreeColGameObjectType>();
        for (Ability ability : this.getAbilities(id)) {
            if (ability.getValue() != value || !(ability.getSource() instanceof FreeColGameObjectType)) continue;
            result.add((FreeColGameObjectType)ability.getSource());
        }
        return result;
    }

    public void addModifier(Modifier modifier) {
        String id = modifier.getId();
        if (!this.allModifiers.containsKey(id)) {
            this.allModifiers.put(id, new ArrayList());
        }
        this.allModifiers.get(id).add(modifier);
    }

    public List<Modifier> getModifiers(String id) {
        return this.allModifiers.get(id);
    }

    public <T extends FreeColGameObjectType> T getType(String Id, Class<T> type) throws IllegalArgumentException {
        if (Id == null) {
            throw new IllegalArgumentException("Trying to retrieve FreeColGameObjectType with ID 'null'.");
        }
        if (this.allTypes.containsKey(Id)) {
            try {
                return (T)((FreeColGameObjectType)type.cast(this.allTypes.get(Id)));
            }
            catch (ClassCastException cce) {
                logger.warning(Id + " caused ClassCastException!");
                throw cce;
            }
        }
        if (this.allTypes.containsKey(this.mangle(Id))) {
            return (T)((FreeColGameObjectType)type.cast(this.allTypes.get(this.mangle(Id))));
        }
        if (this.initialized) {
            throw new IllegalArgumentException("Undefined FreeColGameObjectType with ID '" + Id + "'.");
        }
        try {
            Constructor<T> c = type.getConstructor(String.class, Specification.class);
            FreeColGameObjectType result = (FreeColGameObjectType)c.newInstance(Id, this);
            this.allTypes.put(Id, result);
            return (T)result;
        }
        catch (Exception e) {
            logger.warning(e.toString());
            return null;
        }
    }

    private String mangle(String id) {
        int index = id.lastIndexOf(46);
        if (index == -1) {
            return id;
        }
        return id.substring(0, index + 1) + id.substring(index + 1, index + 2).toLowerCase(Locale.US) + id.substring(index + 2);
    }

    public FreeColGameObjectType getType(String Id) throws IllegalArgumentException {
        return this.getType(Id, FreeColGameObjectType.class);
    }

    public <T extends FreeColGameObjectType> List<T> getTypesWithAbility(Class<T> resultType, String ... abilities) {
        ArrayList<T> result = new ArrayList<T>();
        block0: for (FreeColGameObjectType type : this.allTypes.values()) {
            if (!resultType.isInstance(type)) continue;
            for (String ability : abilities) {
                if (!type.hasAbility(ability)) continue;
                result.add(resultType.cast(type));
                continue block0;
            }
        }
        return result;
    }

    public <T extends FreeColGameObjectType> List<T> getTypesWithoutAbility(Class<T> resultType, String ... abilities) {
        ArrayList<T> result = new ArrayList<T>();
        block0: for (FreeColGameObjectType type : this.allTypes.values()) {
            if (!resultType.isInstance(type)) continue;
            for (String ability : abilities) {
                if (type.hasAbility(ability)) continue block0;
            }
            result.add(resultType.cast(type));
        }
        return result;
    }

    public boolean hasOption(String Id) {
        return Id != null && this.allOptions.containsKey(Id);
    }

    public AbstractOption getOption(String Id) throws IllegalArgumentException {
        if (Id == null) {
            throw new IllegalArgumentException("Trying to retrieve AbstractOption with ID 'null'.");
        }
        if (!this.allOptions.containsKey(Id)) {
            throw new IllegalArgumentException("Trying to retrieve AbstractOption with ID '" + Id + "' returned 'null'.");
        }
        return this.allOptions.get(Id);
    }

    public OptionGroup getOptionGroup(String Id) throws IllegalArgumentException {
        if (Id == null) {
            throw new IllegalArgumentException("Trying to retrieve OptionGroup with ID 'null'.");
        }
        if (!this.allOptionGroups.containsKey(Id)) {
            throw new IllegalArgumentException("Trying to retrieve OptionGroup with ID '" + Id + "' returned 'null'.");
        }
        return this.allOptionGroups.get(Id);
    }

    public void fixOptionGroup(OptionGroup optionGroup, boolean difficulty) {
        if (difficulty) {
            for (Option option : this.allOptionGroups.get("difficultyLevels").getOptions()) {
                if (!(option instanceof OptionGroup)) continue;
                OptionGroup level = (OptionGroup)option;
                if (level.hasOptionGroup()) {
                    level.add(optionGroup);
                    continue;
                }
                for (Option o : optionGroup.getOptions()) {
                    level.add(o);
                }
            }
        } else if (!this.allOptionGroups.containsKey(optionGroup.getId())) {
            this.allOptionGroups.put(optionGroup.getId(), optionGroup);
        }
    }

    public void addOptionGroup(OptionGroup optionGroup, boolean recursive) {
        Iterator<Option> iter = optionGroup.iterator();
        while (iter.hasNext()) {
            Option option = iter.next();
            if (option instanceof OptionGroup) {
                this.allOptionGroups.put(option.getId(), (OptionGroup)option);
                if (!recursive) continue;
                this.addOptionGroup((OptionGroup)option, true);
                continue;
            }
            this.addAbstractOption((AbstractOption)option);
        }
    }

    public void addAbstractOption(AbstractOption abstractOption) {
        this.allOptions.put(abstractOption.getId(), abstractOption);
    }

    public IntegerOption getIntegerOption(String Id) {
        return (IntegerOption)this.getOption(Id);
    }

    public RangeOption getRangeOption(String Id) {
        return (RangeOption)this.getOption(Id);
    }

    public BooleanOption getBooleanOption(String Id) {
        return (BooleanOption)this.getOption(Id);
    }

    public StringOption getStringOption(String Id) {
        return (StringOption)this.getOption(Id);
    }

    public boolean getBoolean(String id) {
        try {
            return ((BooleanOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No boolean value associated with the specified option.");
        }
    }

    public int getInteger(String id) {
        try {
            return ((IntegerOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No integer value associated with the specified option.");
        }
    }

    public String getString(String id) {
        try {
            return ((StringOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No string value associated with the specified option.");
        }
    }

    public List<BuildingType> getBuildingTypeList() {
        return this.buildingTypeList;
    }

    public int numberOfBuildingTypes() {
        return this.buildingTypeList.size();
    }

    public BuildingType getBuildingType(int buildingTypeIndex) {
        return this.buildingTypeList.get(buildingTypeIndex);
    }

    public BuildingType getBuildingType(String id) {
        return this.getType(id, BuildingType.class);
    }

    public List<GoodsType> getGoodsTypeList() {
        return this.goodsTypeList;
    }

    public int numberOfGoodsTypes() {
        return this.goodsTypeList.size();
    }

    public int numberOfStoredGoodsTypes() {
        return this.storableTypes;
    }

    public List<GoodsType> getFarmedGoodsTypeList() {
        return this.farmedGoodsTypeList;
    }

    public List<GoodsType> getNewWorldGoodsTypeList() {
        return this.newWorldGoodsTypeList;
    }

    public List<GoodsType> getLibertyGoodsTypeList() {
        return this.libertyGoodsTypeList;
    }

    public List<GoodsType> getImmigrationGoodsTypeList() {
        return this.immigrationGoodsTypeList;
    }

    public List<GoodsType> getFoodGoodsTypeList() {
        return this.foodGoodsTypeList;
    }

    public int numberOfFarmedGoodsTypes() {
        return this.farmedGoodsTypeList.size();
    }

    public final List<GoodsType> getRawBuildingGoodsTypeList() {
        return this.rawBuildingGoodsTypeList;
    }

    public GoodsType getGoodsType(String id) {
        return this.getType(id, GoodsType.class);
    }

    public GoodsType getPrimaryFoodType() {
        return this.getGoodsType("model.goods.food");
    }

    public int getInitialPrice(GoodsType goodsType) {
        String suffix = goodsType.getSuffix("model.goods.");
        if (this.hasOption("model.option." + suffix + ".minimumPrice") && this.hasOption("model.option." + suffix + ".maximumPrice")) {
            return Math.min(this.getInteger("model.option." + suffix + ".maximumPrice"), this.getInteger("model.option." + suffix + ".minimumPrice"));
        }
        return goodsType.getInitialSellPrice();
    }

    public List<ResourceType> getResourceTypeList() {
        return this.resourceTypeList;
    }

    public int numberOfResourceTypes() {
        return this.resourceTypeList.size();
    }

    public ResourceType getResourceType(String id) {
        return this.getType(id, ResourceType.class);
    }

    public List<TileType> getTileTypeList() {
        return this.tileTypeList;
    }

    public int numberOfTileTypes() {
        return this.tileTypeList.size();
    }

    public TileType getTileType(String id) {
        return this.getType(id, TileType.class);
    }

    public List<TileImprovementType> getTileImprovementTypeList() {
        return this.tileImprovementTypeList;
    }

    public TileImprovementType getTileImprovementType(String id) {
        return this.getType(id, TileImprovementType.class);
    }

    public List<UnitType> getUnitTypeList() {
        return this.unitTypeList;
    }

    public int numberOfUnitTypes() {
        return this.unitTypeList.size();
    }

    public UnitType getUnitType(String id) {
        return this.getType(id, UnitType.class);
    }

    public UnitType getDefaultUnitType() {
        return this.getUnitType("model.unit.freeColonist");
    }

    public UnitType getExpertForProducing(GoodsType goodsType) {
        return this.experts.get(goodsType);
    }

    public List<UnitType> getUnitTypesWithAbility(String ... abilities) {
        return this.getTypesWithAbility(UnitType.class, abilities);
    }

    public List<UnitType> getUnitTypesWithoutAbility(String ... abilities) {
        return this.getTypesWithoutAbility(UnitType.class, abilities);
    }

    public List<UnitType> getUnitTypesTrainedInEurope() {
        return this.unitTypesTrainedInEurope;
    }

    public List<UnitType> getUnitTypesPurchasedInEurope() {
        return this.unitTypesPurchasedInEurope;
    }

    public UnitType getFastestLandUnitType() {
        if (this.cachedFastestLandUnitType == null) {
            int bestValue = -1;
            for (UnitType t : this.unitTypeList) {
                if (t.isNaval() || t.getMovement() <= bestValue) continue;
                bestValue = t.getMovement();
                this.cachedFastestLandUnitType = t;
            }
        }
        return this.cachedFastestLandUnitType;
    }

    public UnitType getFastestNavalUnitType() {
        if (this.cachedFastestNavalUnitType == null) {
            int bestValue = -1;
            for (UnitType t : this.unitTypeList) {
                if (!t.isNaval() || t.getMovement() <= bestValue) continue;
                bestValue = t.getMovement();
                this.cachedFastestNavalUnitType = t;
            }
        }
        return this.cachedFastestNavalUnitType;
    }

    public List<FoundingFather> getFoundingFathers() {
        return this.foundingFathers;
    }

    public int numberOfFoundingFathers() {
        return this.foundingFathers.size();
    }

    public FoundingFather getFoundingFather(String id) {
        return this.getType(id, FoundingFather.class);
    }

    public List<NationType> getNationTypes() {
        return this.nationTypes;
    }

    public List<EuropeanNationType> getEuropeanNationTypes() {
        return this.europeanNationTypes;
    }

    public List<EuropeanNationType> getREFNationTypes() {
        return this.REFNationTypes;
    }

    public List<IndianNationType> getIndianNationTypes() {
        return this.indianNationTypes;
    }

    public int numberOfNationTypes() {
        return this.nationTypes.size();
    }

    public NationType getNationType(String id) {
        return this.getType(id, NationType.class);
    }

    public List<Nation> getNations() {
        return this.nations;
    }

    public Nation getNation(String id) {
        return this.getType(id, Nation.class);
    }

    public List<Nation> getEuropeanNations() {
        return this.europeanNations;
    }

    public List<Nation> getIndianNations() {
        return this.indianNations;
    }

    public List<Nation> getREFNations() {
        return this.REFNations;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Role getRole(String id) {
        return this.getType(id, Role.class);
    }

    public List<EquipmentType> getEquipmentTypeList() {
        return this.equipmentTypes;
    }

    public EquipmentType getEquipmentType(String id) {
        return this.getType(id, EquipmentType.class);
    }

    public List<OptionGroup> getDifficultyLevels() {
        ArrayList<OptionGroup> result = new ArrayList<OptionGroup>();
        for (Option option : this.allOptionGroups.get("difficultyLevels").getOptions()) {
            if (!(option instanceof OptionGroup)) continue;
            result.add((OptionGroup)option);
        }
        return result;
    }

    public OptionGroup getDifficultyLevel() {
        return this.allOptionGroups.get(this.difficultyLevel);
    }

    public OptionGroup getDifficultyLevel(String id) {
        return this.allOptionGroups.get(id);
    }

    public OptionGroup getDifficultyLevel(int level) {
        return this.getDifficultyLevels().get(level);
    }

    public void applyDifficultyLevel(int difficultyLevel) {
        this.applyDifficultyLevel(this.getDifficultyLevel(difficultyLevel));
    }

    public void applyDifficultyLevel(String difficultyLevel) {
        this.applyDifficultyLevel(this.getDifficultyLevel(difficultyLevel));
    }

    public void applyDifficultyLevel(OptionGroup level) {
        logger.fine("Applying difficulty level " + level.getId());
        this.addOptionGroup(level, true);
        for (FreeColGameObjectType type : this.allTypes.values()) {
            type.applyDifficultyLevel(level);
        }
        this.difficultyLevel = level.getId();
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public Event getEvent(String id) {
        return this.getType(id, Event.class);
    }

    public List<Disaster> getDisasters() {
        return this.disasters;
    }

    public Disaster getDisaster(String id) {
        return this.getType(id, Disaster.class);
    }

    public <T extends FreeColGameObjectType> T getType(XMLStreamReader in, String attributeName, Class<T> returnClass, T defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return this.getType(attributeString, returnClass);
        }
        return defaultValue;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(Specification.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        if (this.difficultyLevel != null) {
            out.writeAttribute("difficultyLevel", this.difficultyLevel);
        }
        this.writeSection(out, "modifiers", this.specialModifiers);
        this.writeSection(out, "events", this.events);
        this.writeSection(out, "disasters", this.disasters);
        this.writeSection(out, "goods-types", this.goodsTypeList);
        this.writeSection(out, "resource-types", this.resourceTypeList);
        this.writeSection(out, "tile-types", this.tileTypeList);
        this.writeSection(out, "roles", this.roles);
        this.writeSection(out, "equipment-types", this.equipmentTypes);
        this.writeSection(out, "tileimprovement-types", this.tileImprovementTypeList);
        this.writeSection(out, "unit-types", this.unitTypeList);
        this.writeSection(out, "building-types", this.buildingTypeList);
        this.writeSection(out, "founding-fathers", this.foundingFathers);
        this.writeSection(out, "european-nation-types", this.europeanNationTypes);
        this.writeSection(out, "european-nation-types", this.REFNationTypes);
        this.writeSection(out, "indian-nation-types", this.indianNationTypes);
        this.writeSection(out, "nations", this.nations);
        out.writeStartElement("options");
        for (OptionGroup item : this.allOptionGroups.values()) {
            if (!"".equals(item.getGroup())) continue;
            item.toXML(out);
        }
        out.writeEndElement();
        out.writeEndElement();
    }

    private <T extends FreeColObject> void writeSection(XMLStreamWriter out, String section, Collection<T> items) throws XMLStreamException {
        out.writeStartElement(section);
        for (FreeColObject item : items) {
            item.toXMLImpl(out);
        }
        out.writeEndElement();
    }

    public void readFromXML(XMLStreamReader xsr) throws XMLStreamException {
        EquipmentType missionaryEquipment;
        AbstractUnitOption menOfWar;
        AbstractUnitOption artillery;
        AbstractUnitOption dragoons;
        AbstractUnitOption regulars;
        String newId = xsr.getAttributeValue(null, "id");
        if (this.difficultyLevel == null) {
            this.difficultyLevel = xsr.getAttributeValue(null, "difficultyLevel");
        }
        logger.fine("Difficulty level is " + this.difficultyLevel);
        if (this.id == null) {
            this.id = newId;
        }
        logger.fine("Reading specification " + newId);
        String parentId = xsr.getAttributeValue(null, "extends");
        if (parentId != null) {
            try {
                FreeColTcFile parent = new FreeColTcFile(parentId);
                this.load(parent.getSpecificationInputStream());
                this.initialized = false;
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to open parent specification: " + e);
            }
        }
        while (xsr.nextTag() != 2) {
            String childName = xsr.getLocalName();
            logger.finest("Found child named " + childName);
            ChildReader reader = this.readerMap.get(childName);
            if (reader == null) {
                if ("improvementaction-types".equals(childName)) {
                    while (xsr.nextTag() != 2) {
                        while ("action".equals(xsr.getLocalName())) {
                            xsr.nextTag();
                        }
                    }
                    continue;
                }
                throw new RuntimeException("unexpected: " + childName);
            }
            reader.readChildren(xsr);
        }
        if (this.difficultyLevel != null) {
            this.applyDifficultyLevel(this.difficultyLevel);
        }
        for (BuildingType bt : this.getBuildingTypeList()) {
            bt.fixup09x();
        }
        if (this.getModifiers("model.modifier.nativeTreasureModifier") != null) {
            for (FoundingFather ff : this.getFoundingFathers()) {
                ff.fixup09x();
            }
        }
        String[] years = new String[]{"startingYear", "seasonYear", "mandatoryColonyYear", "lastYear", "lastColonialYear"};
        int[] values = new int[]{1492, 1600, 1600, 1850, 1800};
        for (int index = 0; index < years.length; ++index) {
            String id = "model.option." + years[index];
            if (this.allOptions.get(id) != null) continue;
            IntegerOption option = new IntegerOption(id);
            option.setValue(values[index]);
            this.allOptions.put(id, option);
        }
        String id = "model.option.interventionBells";
        if (this.allOptions.get(id) == null) {
            IntegerOption interventionBells = new IntegerOption(id);
            interventionBells.setValue(5000);
            this.allOptions.put(id, interventionBells);
        }
        if (this.allOptions.get(id = "model.option.interventionTurns") == null) {
            IntegerOption interventionTurns = new IntegerOption(id);
            interventionTurns.setValue(52);
            this.allOptions.put(id, interventionTurns);
        }
        if (this.allOptions.get(id = "model.option.interventionForce") == null) {
            UnitListOption interventionForce = new UnitListOption(id);
            regulars = new AbstractUnitOption(id + ".regulars");
            regulars.setValue(new AbstractUnit("model.unit.colonialRegular", Unit.Role.SOLDIER, 2));
            interventionForce.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons");
            dragoons.setValue(new AbstractUnit("model.unit.colonialRegular", Unit.Role.DRAGOON, 2));
            interventionForce.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery");
            artillery.setValue(new AbstractUnit("model.unit.artillery", Unit.Role.DEFAULT, 2));
            interventionForce.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar");
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", Unit.Role.DEFAULT, 2));
            interventionForce.getValue().add(menOfWar);
            this.allOptions.put(id, interventionForce);
        }
        if (this.allOptions.get(id = "model.option.mercenaryForce") == null) {
            UnitListOption mercenaryForce = new UnitListOption(id);
            regulars = new AbstractUnitOption(id + ".regulars");
            regulars.setValue(new AbstractUnit("model.unit.veteranSoldier", Unit.Role.SOLDIER, 2));
            mercenaryForce.getValue().add(regulars);
            dragoons = new AbstractUnitOption(id + ".dragoons");
            dragoons.setValue(new AbstractUnit("model.unit.veteranSoldier", Unit.Role.DRAGOON, 2));
            mercenaryForce.getValue().add(dragoons);
            artillery = new AbstractUnitOption(id + ".artillery");
            artillery.setValue(new AbstractUnit("model.unit.artillery", Unit.Role.DEFAULT, 2));
            mercenaryForce.getValue().add(artillery);
            menOfWar = new AbstractUnitOption(id + ".menOfWar");
            menOfWar.setValue(new AbstractUnit("model.unit.manOWar", Unit.Role.DEFAULT, 2));
            mercenaryForce.getValue().add(menOfWar);
            this.allOptions.put(id, mercenaryForce);
        }
        if (this.allOptions.get(id = "model.option.goodGovernmentLimit") == null) {
            IntegerOption goodGovernmentLimit = new IntegerOption(id);
            goodGovernmentLimit.setValue(50);
            this.allOptions.put(id, goodGovernmentLimit);
        }
        if (this.allOptions.get(id = "model.option.veryGoodGovernmentLimit") == null) {
            IntegerOption veryGoodGovernmentLimit = new IntegerOption(id);
            veryGoodGovernmentLimit.setValue(100);
            this.allOptions.put(id, veryGoodGovernmentLimit);
        }
        if ((missionaryEquipment = this.getEquipmentType("model.equipment.missionary")) != null) {
            for (String as : new String[]{"model.ability.establishMission", "model.ability.denounceHeresy", "model.ability.inciteNatives"}) {
                List<Ability> al = this.allAbilities.get(as);
                if (al == null) continue;
                for (Ability a : al) {
                    missionaryEquipment.addAbility(a);
                }
            }
        }
        this.initialized = true;
    }

    public static String getXMLElementTagName() {
        return "freecol-specification";
    }

    private class OptionReader
    implements ChildReader {
        private OptionReader() {
        }

        public void readChildren(XMLStreamReader xsr) throws XMLStreamException {
            while (xsr.nextTag() != 2) {
                boolean recursive;
                String optionType = xsr.getLocalName();
                String recursiveString = xsr.getAttributeValue(null, "recursive");
                boolean bl = recursive = !"false".equals(recursiveString);
                if (OptionGroup.getXMLElementTagName().equals(optionType)) {
                    String id = xsr.getAttributeValue(null, "id");
                    OptionGroup group = (OptionGroup)Specification.this.allOptionGroups.get(id);
                    if (group == null) {
                        group = new OptionGroup(id, Specification.this);
                        Specification.this.allOptionGroups.put(id, group);
                    }
                    group.readFromXML(xsr);
                    Specification.this.addOptionGroup(group, recursive);
                    continue;
                }
                logger.finest("Parsing of " + optionType + " is not implemented yet");
                xsr.nextTag();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeReader<T extends FreeColGameObjectType>
    implements ChildReader {
        private Class<T> type;
        private List<T> result;
        private int index = 0;

        public TypeReader(Class<T> type, List<T> listToFill) {
            this.result = listToFill;
            this.type = type;
        }

        @Override
        public void readChildren(XMLStreamReader xsr) throws XMLStreamException {
            while (xsr.nextTag() != 2) {
                FreeColGameObjectType object;
                String id = xsr.getAttributeValue(null, "id");
                if (id == null) {
                    logger.warning("ID is 'null', element name is " + xsr.getLocalName());
                    continue;
                }
                if ("delete".equals(xsr.getLocalName())) {
                    object = (FreeColGameObjectType)Specification.this.allTypes.remove(id);
                    if (object == null) continue;
                    this.result.remove(object);
                    continue;
                }
                object = Specification.this.getType(xsr.getAttributeValue(null, "id"), this.type);
                if (object.getId() != null && xsr.getAttributeValue(null, "preserve") != null) {
                    object.readChildren(xsr);
                } else {
                    object.readFromXML(xsr);
                }
                if (object.isAbstractType() || this.result.contains(object)) continue;
                this.result.add(object);
                object.setIndex(this.index);
                ++this.index;
            }
        }
    }

    private class ModifierReader
    implements ChildReader {
        private ModifierReader() {
        }

        public void readChildren(XMLStreamReader xsr) throws XMLStreamException {
            while (xsr.nextTag() != 2) {
                Modifier modifier = new Modifier(xsr, Specification.this);
                Specification.this.addModifier(modifier);
                Specification.this.specialModifiers.add(modifier);
            }
        }
    }

    private static interface ChildReader {
        public void readChildren(XMLStreamReader var1) throws XMLStreamException;
    }
}

