/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role
extends BuildableType {
    private Role downgrade;
    private int maximumCount = 1;
    private UnitType expertUnit = null;
    public static final Comparator<Role> defensiveComparator = new Comparator<Role>(){

        @Override
        public int compare(Role role1, Role role2) {
            float defence2;
            float defence1 = role1.getDefence();
            if (defence1 > (defence2 = role2.getDefence())) {
                return -1;
            }
            if (defence1 < defence2) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<Role> offensiveComparator = new Comparator<Role>(){

        @Override
        public int compare(Role role1, Role role2) {
            float offence2;
            float offence1 = role1.getOffence();
            if (offence1 > (offence2 = role2.getOffence())) {
                return -1;
            }
            if (offence1 < offence2) {
                return 1;
            }
            return 0;
        }
    };
    private static final String DOWNGRADE_TAG = "downgrade";
    private static final String EXPERT_UNIT_TAG = "expertUnit";
    private static final String MAXIMUM_COUNT_TAG = "maximumCount";

    public Role(String id, Specification specification) {
        super(id, specification);
    }

    public final Role getDowngrade() {
        return this.downgrade;
    }

    public final void setDowngrade(Role newDowngrade) {
        this.downgrade = newDowngrade;
    }

    public final int getMaximumCount() {
        return this.maximumCount;
    }

    public final void setMaximumCount(int newMaximumCount) {
        this.maximumCount = newMaximumCount;
    }

    public final UnitType getExpertUnit() {
        return this.expertUnit;
    }

    public final void setExpertUnit(UnitType newExpertUnit) {
        this.expertUnit = newExpertUnit;
    }

    private float getOffence() {
        return this.getFeatureContainer().applyModifier(1.0f, "model.modifier.offence", null, null);
    }

    public boolean isOffensive() {
        return this.getOffence() > 1.0f;
    }

    private float getDefence() {
        return this.getFeatureContainer().applyModifier(1.0f, "model.modifier.defence", null, null);
    }

    public boolean isDefensive() {
        return this.getDefence() > 1.0f;
    }

    public boolean isCompatibleWith(Role other) {
        return Role.isCompatibleWith(this, other);
    }

    public static boolean isCompatibleWith(Role role1, Role role2) {
        if (role1 == null) {
            return role2 == null;
        }
        if (role2 == null) {
            return false;
        }
        return role1 == role2 || role1.getDowngrade() == role2 || role2.getDowngrade() == role1;
    }

    public List<AbstractGoods> getDowngradeGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        if (this.downgrade != null) {
            for (AbstractGoods ag : this.getRequiredGoods()) {
                int amount = ag.getAmount() - this.downgrade.getRequiredAmountOf(ag.getType());
                if (amount <= 0) continue;
                result.add(new AbstractGoods(ag.getType(), amount));
            }
        }
        return result;
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.downgrade != null) {
            this.writeAttribute(out, DOWNGRADE_TAG, this.downgrade);
        }
        if (this.expertUnit != null) {
            this.writeAttribute(out, EXPERT_UNIT_TAG, this.expertUnit);
        }
        if (this.maximumCount > 1) {
            this.writeAttribute(out, MAXIMUM_COUNT_TAG, this.maximumCount);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        super.readAttributes(in);
        this.downgrade = spec.getType(in, DOWNGRADE_TAG, Role.class, null);
        this.expertUnit = spec.getType(in, EXPERT_UNIT_TAG, UnitType.class, null);
        this.maximumCount = this.getAttribute(in, MAXIMUM_COUNT_TAG, 1);
    }

    public static String getXMLElementTagName() {
        return "role";
    }
}

