/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NationOptions
extends FreeColObject {
    public static final int DEFAULT_NO_OF_EUROPEANS = 4;
    private Advantages nationalAdvantages;
    private Map<Nation, NationState> nations = new HashMap<Nation, NationState>();
    private Specification specification;

    public NationOptions(Specification specification, Advantages advantages) {
        this.specification = specification;
        this.setNationalAdvantages(advantages);
        if (specification != null) {
            int counter = 0;
            HashMap<Nation, NationState> defaultNations = new HashMap<Nation, NationState>();
            for (Nation nation : specification.getNations()) {
                if (nation.getType().isREF()) continue;
                if (nation.getType().isEuropean() && nation.isSelectable()) {
                    if (counter < 4) {
                        defaultNations.put(nation, NationState.AVAILABLE);
                        ++counter;
                        continue;
                    }
                    defaultNations.put(nation, NationState.NOT_AVAILABLE);
                    continue;
                }
                defaultNations.put(nation, NationState.AI_ONLY);
            }
            this.setNations(defaultNations);
        }
    }

    public final Map<Nation, NationState> getNations() {
        return this.nations;
    }

    public final void setNations(Map<Nation, NationState> newNations) {
        this.nations = newNations;
    }

    public final Advantages getNationalAdvantages() {
        return this.nationalAdvantages;
    }

    public final void setNationalAdvantages(Advantages newNationalAdvantages) {
        this.nationalAdvantages = newNationalAdvantages;
    }

    public final NationState getNationState(Nation nation) {
        return this.nations.get(nation);
    }

    public final void setNationState(Nation nation, NationState state) {
        this.nations.put(nation, state);
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(NationOptions.getXMLElementTagName());
        out.writeAttribute("nationalAdvantages", this.nationalAdvantages.toString());
        out.writeStartElement("Nations");
        for (Map.Entry<Nation, NationState> entry : this.nations.entrySet()) {
            out.writeStartElement("Nation");
            out.writeAttribute("id", entry.getKey().getId());
            out.writeAttribute("state", entry.getValue().toString());
            out.writeEndElement();
        }
        out.writeEndElement();
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String advantages = this.getAttribute(in, "nationalAdvantages", "selectable").toUpperCase(Locale.US);
        this.nationalAdvantages = Enum.valueOf(Advantages.class, advantages);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (in.getLocalName().equals("Nations")) {
            this.nations.clear();
            while (in.nextTag() != 2) {
                if (in.getLocalName().equals("Nation")) {
                    String nationId = in.getAttributeValue(null, "id");
                    Nation nation = this.specification.getNation(nationId);
                    NationState state = Enum.valueOf(NationState.class, in.getAttributeValue(null, "state"));
                    this.nations.put(nation, state);
                }
                in.nextTag();
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("nationalAdvantages: " + this.nationalAdvantages.toString() + "\n");
        result.append("Nations:\n");
        for (Map.Entry<Nation, NationState> entry : this.nations.entrySet()) {
            result.append("   " + entry.getKey().getId() + " " + entry.getValue().toString() + "\n");
        }
        return result.toString();
    }

    public static String getXMLElementTagName() {
        return "nationOptions";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NationState {
        AVAILABLE,
        AI_ONLY,
        NOT_AVAILABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Advantages {
        NONE,
        FIXED,
        SELECTABLE;

    }
}

