/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;

public class Nation
extends FreeColGameObjectType {
    public static String UNKNOWN_NATION_ID = "model.nation.unknownEnemy";
    public static final String[] EUROPEAN_NATIONS = new String[]{"english", "french", "spanish", "dutch", "portuguese", "danish", "swedish", "russian", "german", "austrian", "prussian", "turkish"};
    private NationType type;
    private boolean selectable;
    private Nation refNation;
    private int preferredLatitude = 0;
    private boolean startsOnEastCoast = true;

    public Nation(String id, Specification specification) {
        super(id, specification);
    }

    public final NationType getType() {
        return this.type;
    }

    public final void setType(NationType newType) {
        this.type = newType;
    }

    public final String getRulerNameKey() {
        return this.getId() + ".ruler";
    }

    public final boolean isSelectable() {
        return this.selectable;
    }

    public final Nation getRefNation() {
        return this.refNation;
    }

    public final void setRefNation(Nation newRefNation) {
        this.refNation = newRefNation;
    }

    public final void setSelectable(boolean newSelectable) {
        this.selectable = newSelectable;
    }

    public final int getPreferredLatitude() {
        return this.preferredLatitude;
    }

    public final void setPreferredLatitude(int newPreferredLatitude) {
        this.preferredLatitude = newPreferredLatitude;
    }

    public final boolean startsOnEastCoast() {
        return this.startsOnEastCoast;
    }

    public final void setStartsOnEastCoast(boolean newStartsOnEastCoast) {
        this.startsOnEastCoast = newStartsOnEastCoast;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Nation.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("nation-type", this.type.getId());
        out.writeAttribute("selectable", Boolean.toString(this.selectable));
        out.writeAttribute("preferredLatitude", Integer.toString(this.preferredLatitude));
        out.writeAttribute("startsOnEastCoast", Boolean.toString(this.startsOnEastCoast));
        if (this.refNation != null) {
            out.writeAttribute("ref", this.refNation.getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.type = this.getSpecification().getNationType(in.getAttributeValue(null, "nation-type"));
        this.selectable = this.getAttribute(in, "selectable", false);
        this.preferredLatitude = this.getAttribute(in, "preferredLatitude", 0);
        this.startsOnEastCoast = this.getAttribute(in, "startsOnEastCoast", true);
        String refId = this.getAttribute(in, "ref", null);
        if (refId != null) {
            this.refNation = this.getSpecification().getNation(refId);
        }
    }

    public static String getXMLElementTagName() {
        return "nation";
    }
}

