/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modifier
extends Feature
implements Comparable<Modifier> {
    public static final String OFFENCE = "model.modifier.offence";
    public static final String DEFENCE = "model.modifier.defence";
    public static final String OFFENCE_AGAINST = "model.modifier.offenceAgainst";
    public static final String DEFENCE_AGAINST = "model.modifier.defenceAgainst";
    public static final String TILE_TYPE_CHANGE_PRODUCTION = "model.modifier.tileTypeChangeProduction";
    public static final float UNKNOWN = Float.MIN_VALUE;
    public static int BASIC_PRODUCTION_INDEX = 0;
    public static int COLONY_PRODUCTION_INDEX = 10;
    public static int EXPERT_PRODUCTION_INDEX = 20;
    public static int FATHER_PRODUCTION_INDEX = 30;
    public static int IMPROVEMENT_PRODUCTION_INDEX = 40;
    public static int AUTO_PRODUCTION_INDEX = 50;
    public static int BUILDING_PRODUCTION_INDEX = 60;
    public static int NATION_PRODUCTION_INDEX = 70;
    private float value;
    private float increment;
    private Type type;
    private Type incrementType;
    private int index = -1;
    private static final String INCREMENT_TAG = "increment";
    private static final String INCREMENT_TYPE_TAG = "incrementType";
    private static final String INDEX_TAG = "index";
    private static final String TYPE_TAG = "type";

    protected Modifier() {
    }

    public Modifier(Specification specification) {
        this.setSpecification(specification);
    }

    public Modifier(String id, float value, Type type) {
        this.setId(id);
        this.setType(type);
        this.setValue(value);
    }

    public Modifier(String id, FreeColObject source, float value, Type type) {
        this.setId(id);
        this.setSource(source);
        this.setType(type);
        this.setValue(value);
    }

    public Modifier(Modifier template) {
        super.copy(template);
        this.setType(template.getType());
        this.setValue(template.getValue());
        if (template.hasIncrement()) {
            this.setIncrement(template.getIncrement(), template.getIncrementType(), template.getFirstTurn(), template.getLastTurn());
        }
    }

    public Modifier(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.setSpecification(specification);
        this.readFromXML(in);
    }

    public static Modifier makeTimedModifier(String id, Modifier template, Turn start) {
        Modifier modifier = new Modifier(id, template.getSource(), template.getValue(), template.getType());
        float inc = template.getIncrement();
        int duration = template.getDuration();
        modifier.setTemporary(template.isTemporary());
        if (duration == 0) {
            duration = (int)(template.getValue() / -inc);
        }
        modifier.setIncrement(inc, template.getIncrementType(), start, new Turn(start.getNumber() + duration));
        return modifier;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newType) {
        this.type = newType;
    }

    public Type getIncrementType() {
        return this.incrementType;
    }

    public void setIncrementType(Type newIncrementType) {
        this.incrementType = newIncrementType;
    }

    public float getValue() {
        return this.value;
    }

    public float getValue(Turn turn) {
        if (this.appliesTo(turn)) {
            if (this.hasIncrement()) {
                return this.apply(this.value, (float)(turn.getNumber() - this.getFirstTurn().getNumber()) * this.increment, this.incrementType);
            }
            return this.value;
        }
        return 0.0f;
    }

    public void setValue(float newValue) {
        this.value = newValue;
    }

    public float getIncrement() {
        return this.increment;
    }

    public void setIncrement(float newIncrement, Type type, Turn firstTurn, Turn lastTurn) {
        if (firstTurn == null) {
            throw new IllegalArgumentException("Parameter firstTurn must not be 'null'.");
        }
        this.increment = newIncrement;
        this.incrementType = type;
        this.setFirstTurn(firstTurn);
        this.setLastTurn(lastTurn);
    }

    public boolean hasIncrement() {
        return this.incrementType != null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public float apply(float base, float value) {
        return this.apply(base, value, this.type);
    }

    private float apply(float base, float value, Type type) {
        switch (type) {
            case ADDITIVE: {
                return base + value;
            }
            case MULTIPLICATIVE: {
                return base * value;
            }
            case PERCENTAGE: {
                return base + base * value / 100.0f;
            }
        }
        return base;
    }

    public float applyTo(float number) {
        return this.apply(number, this.value);
    }

    public float applyTo(float number, Turn turn) {
        if (this.incrementType == null) {
            return this.apply(number, this.value);
        }
        return this.apply(number, this.getValue(turn), this.type);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash += 31 * Float.floatToIntBits(this.value);
        hash += 31 * Float.floatToIntBits(this.increment);
        hash += 31 * (this.type == null ? 0 : this.type.hashCode());
        hash += 31 * (this.incrementType == null ? 0 : this.incrementType.hashCode());
        return hash += 31 * this.index;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Modifier) {
            Modifier modifier = (Modifier)o;
            if (!super.equals(o)) {
                return false;
            }
            if (this.value != modifier.value) {
                return false;
            }
            if (this.increment != modifier.increment) {
                return false;
            }
            if (this.type == null) {
                if (modifier.type != null) {
                    return false;
                }
            } else {
                if (modifier.type == null) {
                    return false;
                }
                if (!this.type.equals((Object)modifier.type)) {
                    return false;
                }
            }
            if (this.incrementType == null) {
                if (modifier.incrementType != null) {
                    return false;
                }
            } else {
                if (modifier.incrementType == null) {
                    return false;
                }
                if (!this.incrementType.equals((Object)modifier.incrementType)) {
                    return false;
                }
            }
            return this.index == modifier.index;
        }
        return false;
    }

    @Override
    public int compareTo(Modifier modifier) {
        return this.index == modifier.index ? this.type.compareTo(modifier.type) : this.index - modifier.index;
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Modifier.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, "value", this.value);
        this.writeAttribute(out, TYPE_TAG, this.type);
        if (this.incrementType != null) {
            this.writeAttribute(out, INCREMENT_TYPE_TAG, this.incrementType);
            this.writeAttribute(out, INCREMENT_TAG, this.increment);
        }
        if (this.index >= 0) {
            this.writeAttribute(out, INDEX_TAG, this.index);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.type = this.getAttribute(in, TYPE_TAG, Type.class, null);
        this.value = this.getAttribute(in, "value", Float.MIN_VALUE);
        if (this.hasAttribute(in, INCREMENT_TYPE_TAG)) {
            this.incrementType = this.getAttribute(in, INCREMENT_TYPE_TAG, Type.class, null);
            this.increment = this.getAttribute(in, INCREMENT_TAG, Float.MIN_VALUE);
        }
        this.index = this.getAttribute(in, INDEX_TAG, -1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[Modifier ");
        sb.append(this.getId());
        if (this.getSource() != null) {
            sb.append(" (" + this.getSource().getId() + ")");
        }
        sb.append(" ").append((Object)this.type).append(" ").append(this.value);
        for (Scope s : this.getScopes()) {
            sb.append(" ").append(s.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String getXMLElementTagName() {
        return "modifier";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADDITIVE,
        MULTIPLICATIVE,
        PERCENTAGE;

    }
}

