/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Operand;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;

public final class Limit
extends FreeColGameObjectType {
    private Operator operator;
    private Operand leftHandSide;
    private Operand rightHandSide;
    private static final String LEFT_HAND_SIDE_TAG = "leftHandSide";
    private static final String OPERATOR_TAG = "operator";
    private static final String RIGHT_HAND_SIDE_TAG = "rightHandSide";

    public Limit(Specification specification) {
        super(specification);
    }

    public Limit(String id, Operand lhs, Operator op, Operand rhs) {
        this.setId(id);
        this.leftHandSide = lhs;
        this.rightHandSide = rhs;
        this.operator = op;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator newOperator) {
        this.operator = newOperator;
    }

    public Operand getLeftHandSide() {
        return this.leftHandSide;
    }

    public void setLeftHandSide(Operand newLeftHandSide) {
        this.leftHandSide = newLeftHandSide;
    }

    public Operand getRightHandSide() {
        return this.rightHandSide;
    }

    public void setRightHandSide(Operand newRightHandSide) {
        this.rightHandSide = newRightHandSide;
    }

    public boolean appliesTo(FreeColObject object) {
        return this.leftHandSide.appliesTo(object);
    }

    public boolean evaluate(Game game) {
        Integer lhs = null;
        switch (this.leftHandSide.getScopeLevel()) {
            case GAME: {
                lhs = this.leftHandSide.getValue(game);
                break;
            }
            default: {
                lhs = this.leftHandSide.getValue();
            }
        }
        Integer rhs = null;
        switch (this.rightHandSide.getScopeLevel()) {
            case GAME: {
                rhs = this.rightHandSide.getValue(game);
                break;
            }
            default: {
                rhs = this.rightHandSide.getValue();
            }
        }
        return this.evaluate(lhs, rhs);
    }

    public boolean evaluate(Player player) {
        Integer lhs = null;
        switch (this.leftHandSide.getScopeLevel()) {
            case PLAYER: {
                lhs = this.leftHandSide.getValue(player);
                break;
            }
            case GAME: {
                lhs = this.leftHandSide.getValue(player.getGame());
                break;
            }
            default: {
                lhs = this.leftHandSide.getValue();
            }
        }
        Integer rhs = null;
        switch (this.rightHandSide.getScopeLevel()) {
            case PLAYER: {
                rhs = this.rightHandSide.getValue(player);
                break;
            }
            case GAME: {
                rhs = this.rightHandSide.getValue(player.getGame());
                break;
            }
            default: {
                rhs = this.rightHandSide.getValue();
            }
        }
        return this.evaluate(lhs, rhs);
    }

    public boolean evaluate(Settlement settlement) {
        Specification spec = this.getSpecification();
        Integer lhs = null;
        switch (this.leftHandSide.getScopeLevel()) {
            case SETTLEMENT: {
                lhs = this.leftHandSide.getValue(settlement);
                lhs = lhs + spec.getInteger("model.option.settlementLimitModifier");
                break;
            }
            case PLAYER: {
                lhs = this.leftHandSide.getValue(settlement.getOwner());
                break;
            }
            case GAME: {
                lhs = this.leftHandSide.getValue(settlement.getGame());
                break;
            }
            default: {
                lhs = this.leftHandSide.getValue();
            }
        }
        Integer rhs = null;
        switch (this.rightHandSide.getScopeLevel()) {
            case SETTLEMENT: {
                rhs = this.rightHandSide.getValue(settlement);
                break;
            }
            case PLAYER: {
                rhs = this.rightHandSide.getValue(settlement.getOwner());
                break;
            }
            case GAME: {
                rhs = this.rightHandSide.getValue(settlement.getGame());
                break;
            }
            default: {
                rhs = this.rightHandSide.getValue();
            }
        }
        return this.evaluate(lhs, rhs);
    }

    public boolean hasOperandType(Operand.OperandType type) {
        return this.leftHandSide.getOperandType() == type || this.rightHandSide.getOperandType() == type;
    }

    private boolean evaluate(Integer lhs, Integer rhs) {
        if (lhs == null || rhs == null) {
            return true;
        }
        switch (this.operator) {
            case EQ: {
                return lhs == rhs;
            }
            case LT: {
                return lhs < rhs;
            }
            case GT: {
                return lhs > rhs;
            }
            case LE: {
                return lhs <= rhs;
            }
            case GE: {
                return lhs >= rhs;
            }
        }
        return false;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Limit.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, OPERATOR_TAG, this.operator.toString());
    }

    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        this.leftHandSide.toXML(out, LEFT_HAND_SIDE_TAG);
        this.rightHandSide.toXML(out, RIGHT_HAND_SIDE_TAG);
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.operator = this.getAttribute(in, OPERATOR_TAG, Operator.class, null);
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String tag = in.getLocalName();
        if (LEFT_HAND_SIDE_TAG.equals(tag)) {
            this.leftHandSide = new Operand();
            this.leftHandSide.readFromXML(in);
        } else if (RIGHT_HAND_SIDE_TAG.equals(tag)) {
            this.rightHandSide = new Operand();
            this.rightHandSide.readFromXML(in);
        } else {
            super.readChild(in);
        }
    }

    public String toString() {
        return this.leftHandSide.toString() + " " + this.operator.toString() + " " + this.rightHandSide.toString();
    }

    public static String getXMLElementTagName() {
        return "limit";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        EQ,
        LT,
        GT,
        LE,
        GE;

    }
}

