/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GoodsLocation
extends UnitLocation {
    private static final Logger logger = Logger.getLogger(GoodsLocation.class.getName());
    private GoodsContainer goodsContainer;

    protected GoodsLocation() {
    }

    public GoodsLocation(Game game) {
        super(game);
    }

    public GoodsLocation(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public GoodsLocation(Game game, Element e) {
        super(game, e);
    }

    public GoodsLocation(Game game, String id) {
        super(game, id);
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        if (this.goodsContainer != null) {
            objects.addAll(this.goodsContainer.disposeList());
            this.goodsContainer = null;
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    public final void setGoodsContainer(GoodsContainer goodsContainer) {
        this.goodsContainer = goodsContainer;
    }

    public final boolean addGoods(AbstractGoods goods) {
        return this.addGoods(goods.getType(), goods.getAmount());
    }

    public final Goods removeGoods(AbstractGoods goods) {
        return this.removeGoods(goods.getType(), goods.getAmount());
    }

    public final Goods removeGoods(GoodsType type) {
        return this.removeGoods(type, this.getGoodsCount(type));
    }

    public final int getGoodsCount(GoodsType type) {
        return this.goodsContainer.getGoodsCount(type);
    }

    public final Iterator<Goods> getGoodsIterator() {
        return this.goodsContainer.getGoodsIterator();
    }

    public final List<Goods> getGoods() {
        return this.goodsContainer.getGoods();
    }

    public final List<Goods> getCompactGoods() {
        return this.goodsContainer.getCompactGoods();
    }

    @Override
    public boolean add(Locatable locatable) {
        return locatable instanceof Goods ? this.addGoods((Goods)locatable) : super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        return locatable instanceof Goods ? this.removeGoods((Goods)locatable) != null : super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        return locatable instanceof Goods ? this.goodsContainer.contains((Goods)locatable) : super.contains(locatable);
    }

    @Override
    public final GoodsContainer getGoodsContainer() {
        return this.goodsContainer;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            return goods.getSpaceTaken() + this.goodsContainer.getSpaceTaken() > this.getGoodsCapacity() ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : UnitLocation.NoAddReason.NONE;
        }
        return super.getNoAddReason(locatable);
    }

    public abstract int getGoodsCapacity();

    public boolean addGoods(GoodsType type, int amount) {
        return this.goodsContainer.addGoods(type, amount);
    }

    public Goods removeGoods(GoodsType type, int amount) {
        return this.goodsContainer.removeGoods(type, amount);
    }

    @Override
    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        super.writeChildren(out, player, showAll, toSavedGame);
        if (this.goodsContainer != null) {
            this.goodsContainer.toXML(out, player, showAll, toSavedGame);
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (GoodsContainer.getXMLElementTagName().equals(in.getLocalName())) {
            this.goodsContainer = this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"), GoodsContainer.class);
            if (this.goodsContainer == null) {
                this.goodsContainer = new GoodsContainer(this.getGame(), (Location)this, in);
            } else {
                this.goodsContainer.readFromXML(in);
            }
        } else {
            super.readChild(in);
        }
    }
}

