/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Feature
extends FreeColObject {
    private FreeColObject source;
    private Turn firstTurn;
    private Turn lastTurn;
    private int duration = 0;
    private boolean temporary;
    private List<Scope> scopes = null;
    private static final String DURATION_TAG = "duration";
    private static final String FIRST_TURN_TAG = "firstTurn";
    private static final String LAST_TURN_TAG = "lastTurn";
    private static final String SOURCE_TAG = "source";
    private static final String TEMPORARY_TAG = "temporary";

    protected void copy(Feature other) {
        this.setId(other.getId());
        this.source = other.source;
        this.firstTurn = other.firstTurn;
        this.lastTurn = other.lastTurn;
        this.duration = other.duration;
        this.temporary = other.temporary;
        this.setScopes(other.getScopes());
    }

    public String getNameKey() {
        return this.getId() + ".name";
    }

    public final boolean hasTimeLimit() {
        return this.firstTurn != null || this.lastTurn != null;
    }

    public final Turn getFirstTurn() {
        return this.firstTurn;
    }

    public final void setFirstTurn(Turn newFirstTurn) {
        this.firstTurn = newFirstTurn;
    }

    public final Turn getLastTurn() {
        return this.lastTurn;
    }

    public final void setLastTurn(Turn newLastTurn) {
        this.lastTurn = newLastTurn;
    }

    public final boolean hasScope() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public final List<Scope> getScopes() {
        return this.scopes == null ? new ArrayList() : this.scopes;
    }

    public final void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public final FreeColObject getSource() {
        return this.source;
    }

    public final void setSource(FreeColObject newSource) {
        this.source = newSource;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int newDuration) {
        this.duration = newDuration;
    }

    public final boolean isTemporary() {
        return this.temporary;
    }

    public final void setTemporary(boolean newTemporary) {
        this.temporary = newTemporary;
    }

    public boolean appliesTo(FreeColGameObjectType objectType) {
        if (!this.hasScope()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(objectType)) continue;
            return true;
        }
        return false;
    }

    protected boolean appliesTo(Turn turn) {
        return turn == null || (this.firstTurn == null || turn.getNumber() >= this.firstTurn.getNumber()) && (this.lastTurn == null || turn.getNumber() <= this.lastTurn.getNumber());
    }

    protected boolean appliesTo(FreeColGameObjectType objectType, Turn turn) {
        return this.appliesTo(turn) && this.appliesTo(objectType);
    }

    public boolean isOutOfDate(Turn turn) {
        return turn != null && this.lastTurn != null && turn.getNumber() > this.lastTurn.getNumber();
    }

    public int hashCode() {
        int hash = 7;
        hash += 31 * hash + (this.getId() == null ? 0 : this.getId().hashCode());
        hash += 31 * hash + (this.source == null ? 0 : this.source.hashCode());
        hash += 31 * hash + (this.firstTurn == null ? 0 : this.firstTurn.getNumber());
        hash += 31 * hash + (this.lastTurn == null ? 0 : this.lastTurn.getNumber());
        hash += 31 * hash + this.duration;
        hash += 31 * (this.temporary ? 1 : 0);
        if (this.scopes != null) {
            for (Scope scope : this.scopes) {
                hash += scope.hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Feature) {
            Feature feature = (Feature)o;
            if (this.getId() == null) {
                if (feature.getId() != null) {
                    return false;
                }
            } else {
                if (feature.getId() == null) {
                    return false;
                }
                if (!this.getId().equals(feature.getId())) {
                    return false;
                }
            }
            if (this.source != feature.source) {
                return false;
            }
            if (this.firstTurn == null) {
                if (feature.firstTurn != null) {
                    return false;
                }
            } else {
                if (feature.firstTurn == null) {
                    return false;
                }
                if (this.firstTurn.getNumber() != feature.firstTurn.getNumber()) {
                    return false;
                }
            }
            if (this.duration != feature.duration) {
                return false;
            }
            if (this.temporary != feature.temporary) {
                return false;
            }
            if (this.scopes == null) {
                if (feature.scopes != null) {
                    return false;
                }
            } else {
                if (feature.scopes == null) {
                    return false;
                }
                for (Scope scope : this.scopes) {
                    if (feature.scopes.contains(scope)) continue;
                    return false;
                }
                for (Scope scope : feature.scopes) {
                    if (this.scopes.contains(scope)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.getSource() != null) {
            this.writeAttribute(out, SOURCE_TAG, this.getSource());
        }
        if (this.getFirstTurn() != null) {
            this.writeAttribute(out, FIRST_TURN_TAG, this.getFirstTurn().getNumber());
        }
        if (this.getLastTurn() != null) {
            this.writeAttribute(out, LAST_TURN_TAG, this.getLastTurn().getNumber());
        }
        if (this.duration != 0) {
            this.writeAttribute(out, DURATION_TAG, this.duration);
        }
        if (this.temporary) {
            this.writeAttribute(out, TEMPORARY_TAG, this.temporary);
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.scopes != null) {
            for (Scope scope : this.scopes) {
                scope.toXMLImpl(out);
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        int lastTurn;
        super.readAttributes(in);
        Specification spec = this.getSpecification();
        String str = this.getAttribute(in, SOURCE_TAG, null);
        if (!this.hasAttribute(in, "id") && "model.colony.colonyGoodsParty".equals(str)) {
            this.setId("model.modifier.colonyGoodsParty");
            this.setSource(spec.getType("model.source.colonyGoodsParty"));
        } else if (str == null) {
            this.setSource(null);
        } else if ("model.monarch.colonyGoodsParty".equals(str)) {
            this.setSource(spec.getType("model.source.colonyGoodsParty"));
        } else if (spec != null) {
            this.setSource(spec.getType(str));
        }
        int firstTurn = this.getAttribute(in, FIRST_TURN_TAG, Integer.MIN_VALUE);
        if (firstTurn != Integer.MIN_VALUE) {
            this.setFirstTurn(new Turn(firstTurn));
        }
        if ((lastTurn = this.getAttribute(in, LAST_TURN_TAG, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            this.setLastTurn(new Turn(lastTurn));
        }
        this.duration = this.getAttribute(in, DURATION_TAG, 0);
        this.temporary = this.getAttribute(in, TEMPORARY_TAG, false);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.scopes = null;
        super.readChildren(in);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String tag = in.getLocalName();
        if (Scope.getXMLElementTagName().equals(tag)) {
            Scope scope = new Scope(in);
            if (scope != null) {
                if (this.scopes == null) {
                    this.scopes = new ArrayList<Scope>();
                }
                this.scopes.add(scope);
            }
        } else {
            super.readChild(in);
        }
    }
}

