/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuropeanNationType
extends NationType {
    private boolean ref = false;
    private List<AbstractUnit> startingUnits = null;
    private Map<String, Map<String, AbstractUnit>> startingUnitMap = new HashMap<String, Map<String, AbstractUnit>>();
    private final boolean expert = true;
    private static final String EXPERT_STARTING_UNITS_TAG = "expert-starting-units";
    private static final String REF_TAG = "ref";
    private static final String ROLE_TAG = "role";
    private static final String TYPE_TAG = "type";
    private static final String UNIT_TAG = "unit";

    public EuropeanNationType(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public final boolean isREF() {
        return this.ref;
    }

    @Override
    public boolean isEuropean() {
        return true;
    }

    @Override
    public boolean isIndian() {
        return false;
    }

    public List<AbstractUnit> getStartingUnits() {
        return this.startingUnits == null ? new ArrayList() : this.startingUnits;
    }

    public List<AbstractUnit> getStartingUnits(String key) {
        HashMap<String, AbstractUnit> result = new HashMap<String, AbstractUnit>();
        Map<String, AbstractUnit> defaultMap = this.startingUnitMap.get(null);
        Map<String, AbstractUnit> difficultyMap = this.startingUnitMap.get(key);
        if (defaultMap != null) {
            result.putAll(defaultMap);
        }
        if (difficultyMap != null) {
            result.putAll(difficultyMap);
        }
        return new ArrayList<AbstractUnit>(result.values());
    }

    @Override
    public void applyDifficultyLevel(OptionGroup difficulty) {
        boolean ex = difficulty.getBoolean("model.option.expertStartingUnits");
        this.startingUnits = this.getStartingUnits(String.valueOf(ex));
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, EuropeanNationType.getXMLElementTagName());
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, REF_TAG, this.ref);
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.startingUnitMap != null && !this.startingUnitMap.isEmpty()) {
            Map<String, AbstractUnit> map = this.startingUnitMap.get(null);
            if (map != null) {
                for (Map.Entry<String, AbstractUnit> entry : map.entrySet()) {
                    this.writeUnit(out, entry.getKey(), entry.getValue(), false);
                }
            }
            if ((map = this.startingUnitMap.get(Boolean.TRUE.toString())) != null) {
                for (Map.Entry<String, AbstractUnit> entry : map.entrySet()) {
                    this.writeUnit(out, entry.getKey(), entry.getValue(), true);
                }
            }
        }
    }

    private void writeUnit(XMLStreamWriter out, String id, AbstractUnit unit, boolean expert) throws XMLStreamException {
        out.writeStartElement(UNIT_TAG);
        this.writeAttribute(out, "id", id);
        this.writeAttribute(out, TYPE_TAG, unit);
        this.writeAttribute(out, ROLE_TAG, unit.getRole());
        if (expert) {
            this.writeAttribute(out, EXPERT_STARTING_UNITS_TAG, expert);
        }
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        Specification spec = this.getSpecification();
        EuropeanNationType parent = spec.getType(in, "extends", EuropeanNationType.class, this);
        this.ref = this.getAttribute(in, REF_TAG, parent.ref);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        Specification spec;
        EuropeanNationType parent;
        if (this.readShouldClearContainers(in)) {
            this.startingUnitMap.clear();
        }
        if ((parent = (spec = this.getSpecification()).getType(in, "extends", EuropeanNationType.class, this)) != this) {
            for (Map.Entry<String, Map<String, AbstractUnit>> entry : parent.startingUnitMap.entrySet()) {
                this.startingUnitMap.put(entry.getKey(), new HashMap<String, AbstractUnit>(entry.getValue()));
            }
        }
        super.readChildren(in);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String tag = in.getLocalName();
        if (UNIT_TAG.equals(tag)) {
            String id = this.getAttribute(in, "id", null);
            String type = this.getAttribute(in, TYPE_TAG, null);
            Unit.Role role = this.getAttribute(in, ROLE_TAG, Unit.Role.class, Unit.Role.DEFAULT);
            boolean ex = this.getAttribute(in, EXPERT_STARTING_UNITS_TAG, false);
            String exTag = ex ? Boolean.TRUE.toString() : null;
            AbstractUnit unit = new AbstractUnit(type, role, 1);
            Map<String, AbstractUnit> units = this.startingUnitMap.get(exTag);
            if (units == null) {
                units = new HashMap<String, AbstractUnit>();
                this.startingUnitMap.put(exTag, units);
            }
            units.put(id, unit);
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "european-nation-type";
    }
}

