/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;

public class EquipmentType
extends BuildableType {
    public static final EquipmentType[] NO_EQUIPMENT = new EquipmentType[0];
    private int maximumCount = 1;
    private int combatLossPriority = -1;
    private String captureEquipmentId = null;
    private boolean captureEquipmentByIndians = false;
    private Unit.Role role = Unit.Role.DEFAULT;
    private boolean militaryEquipment = false;
    private List<String> compatibleEquipment = null;
    private static final String BY_INDIANS_TAG = "by-indians";
    private static final String CAPTURE_EQUIPMENT_TAG = "capture-equipment";
    private static final String COMBAT_LOSS_PRIORITY_TAG = "combat-loss-priority";
    private static final String COMPATIBLE_EQUIPMENT_TAG = "compatible-equipment";
    private static final String MAXIMUM_COUNT_TAG = "maximum-count";
    private static final String REQUIRED_LOCATION_ABILITY_TAG = "required-location-ability";
    private static final String ROLE_TAG = "role";

    public EquipmentType(String id, Specification specification) {
        super(id, specification);
    }

    public final int getMaximumCount() {
        return this.maximumCount;
    }

    public final int getCombatLossPriority() {
        return this.combatLossPriority;
    }

    public boolean canBeCaptured() {
        return this.combatLossPriority > 0;
    }

    public EquipmentType getCaptureEquipment(boolean byIndians) {
        return this.captureEquipmentId != null && byIndians == this.captureEquipmentByIndians ? this.getSpecification().getEquipmentType(this.captureEquipmentId) : this;
    }

    public boolean isCompatibleWith(EquipmentType otherType) {
        if (this.getId().equals(otherType.getId())) {
            return true;
        }
        return this.compatibleEquipment != null && this.compatibleEquipment.contains(otherType.getId()) && otherType.compatibleEquipment.contains(this.getId());
    }

    public final Unit.Role getRole() {
        return this.role;
    }

    public final boolean isMilitaryEquipment() {
        return this.militaryEquipment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compatibleEquipment == null ? 0 : this.compatibleEquipment.hashCode());
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EquipmentType other = (EquipmentType)obj;
        if (this.compatibleEquipment == null ? other.compatibleEquipment != null : !this.compatibleEquipment.equals(other.compatibleEquipment)) {
            return false;
        }
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, EquipmentType.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, MAXIMUM_COUNT_TAG, this.maximumCount);
        this.writeAttribute(out, COMBAT_LOSS_PRIORITY_TAG, this.combatLossPriority);
        this.writeAttribute(out, ROLE_TAG, this.role);
    }

    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.captureEquipmentId != null) {
            out.writeStartElement(CAPTURE_EQUIPMENT_TAG);
            this.writeAttribute(out, "id", this.captureEquipmentId);
            this.writeAttribute(out, BY_INDIANS_TAG, this.captureEquipmentByIndians);
            out.writeEndElement();
        }
        if (this.compatibleEquipment != null) {
            for (String compatible : this.compatibleEquipment) {
                out.writeStartElement(COMPATIBLE_EQUIPMENT_TAG);
                this.writeAttribute(out, "id", compatible);
                out.writeEndElement();
            }
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.maximumCount = this.getAttribute(in, MAXIMUM_COUNT_TAG, 1);
        this.combatLossPriority = this.getAttribute(in, COMBAT_LOSS_PRIORITY_TAG, -1);
        this.role = this.getAttribute(in, ROLE_TAG, Unit.Role.class, Unit.Role.DEFAULT);
    }

    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        if (this.readShouldClearContainers(in)) {
            this.captureEquipmentId = null;
            this.captureEquipmentByIndians = false;
            this.compatibleEquipment = null;
        }
        super.readChildren(in);
        for (Modifier modifier : this.getModifiers()) {
            if (!modifier.getId().equals("model.modifier.offence") && !modifier.getId().equals("model.modifier.defence")) continue;
            this.militaryEquipment = true;
            for (AbstractGoods goods : this.getRequiredGoods()) {
                goods.getType().setMilitaryGoods(true);
            }
        }
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = in.getLocalName();
        if (CAPTURE_EQUIPMENT_TAG.equals(tag)) {
            this.captureEquipmentId = this.getAttribute(in, "id", null);
            this.captureEquipmentByIndians = this.getAttribute(in, BY_INDIANS_TAG, false);
            in.nextTag();
        } else if (COMPATIBLE_EQUIPMENT_TAG.equals(tag)) {
            String equipmentId = this.getAttribute(in, "id", null);
            if (equipmentId != null) {
                if (this.compatibleEquipment == null) {
                    this.compatibleEquipment = new ArrayList<String>();
                }
                this.compatibleEquipment.add(equipmentId);
            }
            in.nextTag();
        } else if (REQUIRED_LOCATION_ABILITY_TAG.equals(tag)) {
            String abilityId = this.getAttribute(in, "id", null);
            Map<String, Boolean> required = this.getRequiredAbilities();
            required.put(abilityId, this.getAttribute(in, "value", true));
            this.setRequiredAbilities(required);
            spec.addAbility(abilityId);
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "equipment-type";
    }
}

