/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Effect
extends FreeColGameObjectType {
    public static final String DAMAGED_UNIT = "model.disaster.effect.damageUnit";
    public static final String LOSS_OF_UNIT = "model.disaster.effect.lossOfUnit";
    public static final String LOSS_OF_MONEY = "model.disaster.effect.lossOfMoney";
    public static final String LOSS_OF_GOODS = "model.disaster.effect.lossOfGoods";
    public static final String LOSS_OF_TILE_PRODUCTION = "model.disaster.effect.lossOfTileProduction";
    public static final String LOSS_OF_BUILDING_PRODUCTION = "model.disaster.effect.lossOfBuildingProduction";
    private int probability;
    private List<Scope> scopes;

    protected Effect() {
    }

    public Effect(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.setSpecification(specification);
        this.readFromXML(in);
    }

    public Effect(Effect template) {
        this.setSpecification(template.getSpecification());
        this.setId(template.getId());
        this.probability = template.probability;
        this.scopes = template.scopes;
        this.addFeatures(template);
    }

    public final int getProbability() {
        return this.probability;
    }

    public final void setProbability(int newProbability) {
        this.probability = newProbability;
    }

    public final List<Scope> getScopes() {
        return this.scopes;
    }

    public final void setScopes(List<Scope> newScopes) {
        this.scopes = newScopes;
    }

    public boolean appliesTo(FreeColGameObjectType objectType) {
        if (this.scopes.isEmpty()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(objectType)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.probability = this.getAttribute(in, "probability", 0);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if (Scope.getXMLElementTagName().equals(childName)) {
            Scope scope = new Scope(in);
            if (this.scopes == null) {
                this.scopes = new ArrayList<Scope>();
            }
            this.scopes.add(scope);
        } else {
            super.readChild(in);
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Effect.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("probability", Integer.toString(this.probability));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.getScopes() != null) {
            for (Scope scope : this.getScopes()) {
                scope.toXMLImpl(out);
            }
        }
    }

    public static String getXMLElementTagName() {
        return "effect";
    }

    @Override
    public String toString() {
        String result = this.getId() + " [probability: " + this.probability + "%]";
        if (this.getScopes() != null) {
            for (Scope scope : this.getScopes()) {
                result = result + " " + scope;
            }
        }
        return result;
    }
}

