/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonyTile
extends WorkLocation
implements Ownable {
    private static final Logger logger = Logger.getLogger(ColonyTile.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    public static final int UNIT_CAPACITY = 1;
    protected Tile workTile;

    protected ColonyTile() {
    }

    protected ColonyTile(Game game, Colony colony, Tile workTile) {
        super(game);
        this.setColony(colony);
        this.workTile = workTile;
    }

    public ColonyTile(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public ColonyTile(Game game, String id) {
        super(game, id);
    }

    public StringTemplate getLabel() {
        return this.workTile.getLabel();
    }

    public boolean isColonyCenterTile() {
        return this.getWorkTile() == this.getTile();
    }

    public Tile getWorkTile() {
        return this.workTile;
    }

    public void relocateWorkers() {
        block0: for (Unit unit : this.getUnitList()) {
            for (WorkLocation wl : this.getColony().getCurrentWorkLocations()) {
                if (wl == this || !wl.canAdd(unit)) continue;
                unit.setLocation(wl);
                continue block0;
            }
        }
    }

    public Unit getOccupyingUnit() {
        return this.workTile.getOccupyingUnit();
    }

    public boolean isOccupied() {
        return this.workTile.isOccupied();
    }

    private AbstractGoods getPrimaryProduction() {
        if (this.workTile.getType().getPrimaryGoods() == null) {
            return null;
        }
        AbstractGoods primaryProduction = new AbstractGoods(this.workTile.getType().getPrimaryGoods());
        int potential = primaryProduction.getAmount();
        if (this.workTile.getTileItemContainer() != null) {
            potential = this.workTile.getTileItemContainer().getTotalBonusPotential(primaryProduction.getType(), null, potential, false);
        }
        primaryProduction.setAmount(potential + Math.max(0, this.getColony().getProductionBonus()));
        return primaryProduction;
    }

    private AbstractGoods getSecondaryProduction() {
        if (this.workTile.getType().getSecondaryGoods() == null) {
            return null;
        }
        AbstractGoods secondaryProduction = new AbstractGoods(this.workTile.getType().getSecondaryGoods());
        int potential = secondaryProduction.getAmount();
        if (this.workTile.getTileItemContainer() != null) {
            potential = this.workTile.getTileItemContainer().getTotalBonusPotential(secondaryProduction.getType(), null, potential, true);
        }
        secondaryProduction.setAmount(potential + Math.max(0, this.getColony().getProductionBonus()));
        return secondaryProduction;
    }

    public ProductionInfo getBasicProductionInfo() {
        ProductionInfo pi = new ProductionInfo();
        if (this.isColonyCenterTile()) {
            AbstractGoods secondaryProduction;
            AbstractGoods primaryProduction = this.getPrimaryProduction();
            if (primaryProduction != null) {
                pi.addProduction(primaryProduction);
            }
            if ((secondaryProduction = this.getSecondaryProduction()) != null) {
                pi.addProduction(secondaryProduction);
            }
        } else {
            for (Unit unit : this.getUnitList()) {
                GoodsType goodsType = unit.getWorkType();
                if (goodsType == null) continue;
                pi.addProduction(new AbstractGoods(goodsType, this.getProductionOf(unit, goodsType)));
            }
        }
        return pi;
    }

    @Override
    public StringTemplate getLocationName() {
        String name = this.getColony().getName();
        if (this.isColonyCenterTile()) {
            return StringTemplate.name(name);
        }
        return StringTemplate.template("nearLocation").add("%direction%", "direction." + this.getTile().getDirection(this.workTile).toString()).addName("%location%", name);
    }

    @Override
    public boolean add(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoAddReason(locatable);
        if (reason != UnitLocation.NoAddReason.NONE) {
            throw new IllegalStateException("Can not add " + locatable + " to " + this.toString() + " because " + (Object)((Object)reason));
        }
        Unit unit = (Unit)locatable;
        if (this.contains(unit)) {
            return true;
        }
        if (super.add(unit)) {
            unit.setState(Unit.UnitState.IN_COLONY);
            if (unit.getWorkType() == null) {
                AbstractGoods goods = this.workTile.getType().getPrimaryGoods();
                if (goods == null && (goods = this.workTile.getType().getSecondaryGoods()) == null && !this.workTile.getType().getProduction().isEmpty()) {
                    goods = this.workTile.getType().getProduction().get(0);
                }
                if (goods != null) {
                    unit.setWorkType(goods.getType());
                }
            }
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (!this.contains(unit)) {
            return true;
        }
        if (super.remove(unit)) {
            unit.setState(Unit.UnitState.ACTIVE);
            unit.setMovesLeft(0);
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoWorkReason();
        return reason != UnitLocation.NoAddReason.NONE ? reason : super.getNoAddReason(locatable);
    }

    @Override
    public int getUnitCapacity() {
        return this.isColonyCenterTile() ? 0 : 1;
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        Player.NoClaimReason claim;
        Tile tile = this.getWorkTile();
        UnitLocation.NoAddReason noAddReason = this.isColonyCenterTile() ? UnitLocation.NoAddReason.COLONY_CENTER : (!this.getColony().hasAbility("model.ability.produceInWater") && !tile.isLand() ? UnitLocation.NoAddReason.MISSING_ABILITY : (tile.getOwningSettlement() == this.getColony() ? UnitLocation.NoAddReason.NONE : ((claim = this.getOwner().canClaimForSettlementReason(tile)) == Player.NoClaimReason.NONE ? UnitLocation.NoAddReason.CLAIM_REQUIRED : (claim == Player.NoClaimReason.TERRAIN || claim == Player.NoClaimReason.RUMOUR || claim == Player.NoClaimReason.WATER ? UnitLocation.NoAddReason.MISSING_ABILITY : (claim == Player.NoClaimReason.SETTLEMENT ? (tile.getSettlement().getOwner() == this.getOwner() ? UnitLocation.NoAddReason.ANOTHER_COLONY : UnitLocation.NoAddReason.OWNED_BY_ENEMY) : (claim == Player.NoClaimReason.OCCUPIED ? UnitLocation.NoAddReason.OCCUPIED_BY_ENEMY : (claim == Player.NoClaimReason.WORKED ? UnitLocation.NoAddReason.ANOTHER_COLONY : (claim == Player.NoClaimReason.EUROPEANS ? UnitLocation.NoAddReason.OWNED_BY_ENEMY : (claim == Player.NoClaimReason.NATIVES ? UnitLocation.NoAddReason.CLAIM_REQUIRED : UnitLocation.NoAddReason.WRONG_TYPE)))))))));
        return noAddReason;
    }

    @Override
    public boolean canAutoProduce() {
        return this.isColonyCenterTile();
    }

    @Override
    public int getProductionOf(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit.");
        }
        return this.getPotentialProduction(goodsType, unit.getType());
    }

    @Override
    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        List<Modifier> mods;
        int production = 0;
        TileType tileType = this.workTile.getType();
        if (this.isColonyCenterTile()) {
            production = unitType != null ? 0 : (tileType.getPrimaryGoods() != null && tileType.getPrimaryGoods().getType() == goodsType ? this.getPrimaryProduction().getAmount() : (tileType.getSecondaryGoods() != null && tileType.getSecondaryGoods().getType() == goodsType ? this.getSecondaryProduction().getAmount() : 0));
        } else if ((this.workTile.isLand() || this.getColony().hasAbility("model.ability.produceInWater")) && !(mods = this.getProductionModifiers(goodsType, unitType)).isEmpty()) {
            production = (int)FeatureContainer.applyModifiers(0.0f, this.getGame().getTurn(), mods);
        }
        return Math.max(0, production);
    }

    @Override
    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("Null GoodsType.");
        }
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        Colony colony = this.getColony();
        Player owner = colony.getOwner();
        TileType tileType = this.getWorkTile().getType();
        String id = goodsType.getId();
        Turn turn = this.getGame().getTurn();
        if (this.isColonyCenterTile()) {
            if (tileType.isPrimaryGoodsType(goodsType) || tileType.isSecondaryGoodsType(goodsType)) {
                result.addAll(this.workTile.getProductionModifiers(goodsType, null));
                result.addAll(colony.getModifierSet(id, null, turn));
                result.add(colony.getProductionModifier(goodsType));
                if (owner != null) {
                    result.addAll(owner.getModifierSet(id, null, turn));
                }
            }
        } else {
            result.addAll(this.workTile.getProductionModifiers(goodsType, unitType));
            if (FeatureContainer.applyModifiers(0.0f, turn, result) > 0.0f) {
                result.addAll(colony.getModifierSet(id, null, turn));
                if (unitType != null) {
                    result.add(colony.getProductionModifier(goodsType));
                    result.addAll(unitType.getModifierSet(id, tileType, turn));
                    if (owner != null) {
                        result.addAll(owner.getModifierSet(id, null, turn));
                    }
                } else if (owner != null) {
                    result.addAll(owner.getModifierSet(id, tileType, turn));
                }
            }
        }
        return result;
    }

    @Override
    public GoodsType getBestWorkType(Unit unit) {
        GoodsType workType = null;
        int amount = 0;
        for (GoodsType g : this.getSpecification().getFarmedGoodsTypeList()) {
            int newAmount = this.getPotentialProduction(g, unit.getType());
            if (newAmount <= amount) continue;
            amount = newAmount;
            workType = g;
        }
        return workType;
    }

    @Override
    public StringTemplate getClaimTemplate() {
        return this.isColonyCenterTile() ? super.getClaimTemplate() : StringTemplate.template("workClaimColonyTile").add("%direction%", "direction." + this.getTile().getDirection(this.workTile).toString());
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(ColonyTile.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("workTile", this.workTile.getId());
        super.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.workTile = this.getFreeColGameObject(in, "workTile", Tile.class);
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    public void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        return "ColonyTile" + this.getWorkTile().getPosition().toString() + "/" + this.getColony().getName();
    }

    public static String getXMLElementTagName() {
        return "colonyTile";
    }
}

