/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.ProductionCache;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colony
extends Settlement
implements Nameable {
    private static final Logger logger = Logger.getLogger(Colony.class.getName());
    public static final String BUILD_QUEUE_TAG = "buildQueueItem";
    public static final String POPULATION_QUEUE_TAG = "populationQueueItem";
    public static final String REARRANGE_WORKERS = "rearrangeWorkers";
    public static final int LIBERTY_PER_REBEL = 200;
    public static final Ability HAS_PORT = new Ability("model.ability.hasPort");
    public static final FreeColGameObjectType SOL_MODIFIER_SOURCE = new FreeColGameObjectType("model.source.solModifier");
    protected final List<ColonyTile> colonyTiles = new ArrayList<ColonyTile>();
    protected final Map<String, Building> buildingMap = new HashMap<String, Building>();
    protected final Map<String, ExportData> exportData = new HashMap<String, ExportData>();
    protected int sonsOfLiberty;
    protected int oldSonsOfLiberty;
    protected int tories;
    protected int oldTories;
    protected int productionBonus;
    protected int immigration;
    protected int liberty;
    protected boolean landLocked = true;
    protected int unitCount = -1;
    protected int displayUnitCount = -1;
    protected String stockadeKey = null;
    protected Turn established = new Turn(0);
    protected BuildQueue<BuildableType> buildQueue = new BuildQueue(this, BuildQueue.CompletionAction.REMOVE_EXCEPT_LAST, 500);
    protected BuildQueue<UnitType> populationQueue = new BuildQueue(this, BuildQueue.CompletionAction.SHUFFLE, 300);
    private ProductionCache productionCache = new ProductionCache(this);

    protected Colony() {
    }

    protected Colony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public Colony(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Colony(Game game, String id) {
        super(game, id);
    }

    public Colony getScratchColony() {
        Game game = this.getGame();
        Player owner = this.getOwner();
        Colony scratch = new Colony(game, owner, "scratch" + this.getName(), this.getTile().getScratchTile());
        GoodsContainer container = new GoodsContainer(game, scratch);
        for (Goods g : this.getCompactGoods()) {
            container.addGoods(g.getType(), g.getAmount());
        }
        scratch.setGoodsContainer(container);
        FeatureContainer fc = scratch.getFeatureContainer();
        FeatureContainer.addFeatures(fc, this);
        scratch.colonyTiles.clear();
        for (ColonyTile colonyTile : this.colonyTiles) {
            Tile t;
            Tile wt = colonyTile.getWorkTile();
            if (colonyTile.isColonyCenterTile()) {
                t = scratch.getTile();
                t.setSettlement(scratch);
            } else {
                t = wt.getScratchTile();
            }
            if (owner.owns(wt)) {
                t.setOwner(owner);
                t.setOwningSettlement(scratch);
            }
            scratch.colonyTiles.add(new ColonyTile(game, scratch, t));
        }
        scratch.buildingMap.clear();
        for (Map.Entry entry : this.buildingMap.entrySet()) {
            scratch.buildingMap.put((String)entry.getKey(), new Building(game, scratch, ((Building)entry.getValue()).getType()));
        }
        scratch.exportData.clear();
        scratch.established = this.established;
        scratch.sonsOfLiberty = this.sonsOfLiberty;
        scratch.oldSonsOfLiberty = this.oldSonsOfLiberty;
        scratch.tories = this.tories;
        scratch.oldTories = this.oldTories;
        scratch.productionBonus = this.productionBonus;
        scratch.immigration = this.immigration;
        scratch.liberty = this.liberty;
        scratch.landLocked = this.landLocked;
        scratch.buildQueue.clear();
        scratch.populationQueue = this.populationQueue;
        return scratch;
    }

    public void disposeScratchColony() {
        this.populationQueue = null;
        for (ColonyTile ct : this.colonyTiles) {
            ct.getWorkTile().disposeScratchTile();
        }
        this.colonyTiles.clear();
        this.dispose();
    }

    public WorkLocation getCorrespondingWorkLocation(WorkLocation wl) {
        block2: {
            block3: {
                Colony original = wl.getColony();
                if (!this.getName().equals("scratch" + original.getName()) && !original.getName().equals("scratch" + this.getName())) break block2;
                if (!(wl instanceof Building)) break block3;
                BuildingType type = ((Building)wl).getType();
                for (Building b : this.getBuildings()) {
                    if (b.getType() != type) continue;
                    return b;
                }
                break block2;
            }
            if (!(wl instanceof ColonyTile)) break block2;
            Tile workTile = ((ColonyTile)wl).getWorkTile();
            for (ColonyTile c : this.getColonyTiles()) {
                if (c.getWorkTile().getTileItemContainer() != workTile.getTileItemContainer()) continue;
                return c;
            }
        }
        return null;
    }

    public boolean isAutomaticBuild(BuildingType buildingType) {
        float value = this.owner.applyModifier(100.0f, "model.modifier.buildingPriceBonus", buildingType, this.getGame().getTurn());
        return value == 0.0f && this.canBuild(buildingType);
    }

    public void addBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        this.buildingMap.put(buildingType.getId(), building);
        this.addFeatures(building.getType());
        this.invalidateCache();
    }

    public boolean removeBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        boolean result = this.buildingMap.remove(buildingType.getId()) != null;
        this.removeFeatures(building.getType());
        this.invalidateCache();
        return result;
    }

    @Override
    public boolean canProvideEquipment(EquipmentType equipmentType) {
        BuildableType buildable = this.getCurrentlyBuilding();
        for (AbstractGoods goods : equipmentType.getRequiredGoods()) {
            int available = this.getGoodsCount(goods.getType());
            int breedingNumber = goods.getType().getBreedingNumber();
            if (breedingNumber != Integer.MAX_VALUE) {
                available -= breedingNumber;
            }
            if (buildable != null) {
                for (AbstractGoods ag : buildable.getRequiredGoods()) {
                    if (ag.getType() != goods.getType()) continue;
                    available -= ag.getAmount();
                    break;
                }
            }
            if (available >= goods.getAmount()) continue;
            return false;
        }
        return true;
    }

    public void addEquipmentGoods(EquipmentType type, int n) {
        for (AbstractGoods ag : type.getRequiredGoods()) {
            if (!ag.getType().isStorable()) continue;
            this.addGoods(ag.getType(), n * ag.getAmount());
        }
    }

    public boolean canReducePopulation() {
        return (float)this.getUnitCount() > FeatureContainer.applyModifierSet(0.0f, this.getGame().getTurn(), this.getModifierSet("model.modifier.minimumColonySize"));
    }

    public String getReducePopulationMessage() {
        if (this.canReducePopulation()) {
            return null;
        }
        String message = "";
        Set<Modifier> modifierSet = this.getModifierSet("model.modifier.minimumColonySize");
        Iterator<Modifier> i$ = modifierSet.iterator();
        if (i$.hasNext()) {
            Modifier modifier = i$.next();
            FreeColObject source = modifier.getSource();
            if (source instanceof BuildingType) {
                source = this.getBuilding((BuildingType)source).getType();
            }
            return Messages.message(StringTemplate.template("colonyPanel.minimumColonySize").addName("%object%", source));
        }
        return message;
    }

    public void updatePopulation(int difference) {
        int population = this.getUnitCount();
        if (population > 0) {
            this.getTile().updatePlayerExploredTiles();
            this.updateSoL();
            this.updateProductionBonus();
        }
    }

    public ExportData getExportData(GoodsType goodsType) {
        ExportData result = this.exportData.get(goodsType.getId());
        if (result == null) {
            result = new ExportData(goodsType);
            this.setExportData(result);
        }
        return result;
    }

    public final void setExportData(ExportData newExportData) {
        this.exportData.put(newExportData.getId(), newExportData);
    }

    public int getExportAmount(GoodsType goodsType) {
        int exportable;
        int present = this.getGoodsCount(goodsType);
        return present < (exportable = this.getExportData(goodsType).getExportLevel()) ? 0 : present - exportable;
    }

    public int getImportAmount(GoodsType goodsType) {
        int present = this.getGoodsCount(goodsType);
        if (goodsType.isFoodType()) {
            return Integer.MAX_VALUE;
        }
        int capacity = this.getWarehouseCapacity();
        return present > capacity ? 0 : capacity - present;
    }

    public boolean isLandLocked() {
        return this.landLocked;
    }

    public boolean isUndead() {
        Iterator<Unit> unitIterator = this.getUnitIterator();
        return unitIterator.hasNext() && unitIterator.next().isUndead();
    }

    @Override
    public void changeOwner(Player owner) {
        super.changeOwner(owner);
        for (ExportData exportDatum : this.exportData.values()) {
            exportDatum.setExported(false);
        }
        this.updatePopulation(0);
    }

    public List<Building> getBuildingsForProducing(GoodsType goodsType) {
        ArrayList<Building> buildings = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (building.getGoodsOutputType() != goodsType) continue;
            buildings.add(building);
        }
        return buildings;
    }

    public List<Building> getBuildingsForConsuming(GoodsType goodsType) {
        ArrayList<Building> buildings = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (building.getGoodsInputType() != goodsType) continue;
            buildings.add(building);
        }
        return buildings;
    }

    public Building getBuildingForProducing(GoodsType goodsType) {
        List<Building> buildings = this.getBuildingsForProducing(goodsType);
        return buildings.isEmpty() ? null : buildings.get(0);
    }

    public Building getBuildingForConsuming(GoodsType goodsType) {
        List<Building> buildings = this.getBuildingsForConsuming(goodsType);
        return buildings.isEmpty() ? null : buildings.get(0);
    }

    public List<WorkLocation> getAllWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.buildingMap.values());
        result.addAll(this.colonyTiles);
        return result;
    }

    public List<WorkLocation> getAvailableWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.buildingMap.values());
        for (ColonyTile ct : this.colonyTiles) {
            Tile tile = ct.getWorkTile();
            if (tile.getOwningSettlement() != this && !this.getOwner().canClaimForSettlement(tile)) continue;
            result.add(ct);
        }
        return result;
    }

    public List<WorkLocation> getCurrentWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.buildingMap.values());
        for (ColonyTile ct : this.colonyTiles) {
            Tile tile = ct.getWorkTile();
            if (tile.getOwningSettlement() != this) continue;
            result.add(ct);
        }
        return result;
    }

    public List<Building> getBuildings() {
        return new ArrayList<Building>(this.buildingMap.values());
    }

    public List<ColonyTile> getColonyTiles() {
        return this.colonyTiles;
    }

    public List<RandomChoice<Disaster>> getDisasters() {
        ArrayList<RandomChoice<Disaster>> disasters = new ArrayList<RandomChoice<Disaster>>();
        for (ColonyTile tile : this.colonyTiles) {
            disasters.addAll(tile.getWorkTile().getDisasters());
        }
        return disasters;
    }

    public boolean isTileInUse(Tile tile) {
        ColonyTile colonyTile = this.getColonyTile(tile);
        return colonyTile != null && !colonyTile.isEmpty();
    }

    public Building getBuilding(BuildingType type) {
        return this.buildingMap.get(type.getFirstLevel().getId());
    }

    public Building getBuildingWithAbility(String ability) {
        for (Building building : this.buildingMap.values()) {
            if (!building.getType().hasAbility(ability)) continue;
            return building;
        }
        return null;
    }

    public ColonyTile getColonyTile(Tile t) {
        for (ColonyTile c : this.colonyTiles) {
            if (c.getWorkTile() != t) continue;
            return c;
        }
        return null;
    }

    public void incrementLiberty(int amount) {
        this.liberty += amount;
    }

    public void incrementImmigration(int amount) {
        this.immigration += amount;
    }

    public Turn getEstablished() {
        return this.established;
    }

    public void setEstablished(Turn newEstablished) {
        this.established = newEstablished;
    }

    public WorkLocation getWorkLocationFor(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit);
        if (occupation == null) {
            logger.warning("Could not find a WorkLocation for: " + unit.toString() + " in: " + this.getName());
            return null;
        }
        if (occupation.workType != null) {
            unit.setWorkType(occupation.workType);
        }
        return occupation.workLocation;
    }

    public boolean addUnit(Unit unit, WorkLocation loc) {
        if (!unit.isPerson()) {
            return false;
        }
        if (loc == null && (loc = this.getWorkLocationFor(unit)) == null) {
            return false;
        }
        if (!loc.add(unit)) {
            return false;
        }
        Player owner = unit.getOwner();
        owner.modifyScore(unit.getType().getScoreValue());
        this.updatePopulation(1);
        unit.setState(Unit.UnitState.IN_COLONY);
        if (owner.isAI()) {
            this.firePropertyChange(REARRANGE_WORKERS, true, false);
        }
        return true;
    }

    public boolean removeUnit(Unit unit) {
        Player owner = unit.getOwner();
        for (WorkLocation w : this.getCurrentWorkLocations()) {
            if (!w.contains(unit) || !w.remove(unit)) continue;
            Unit teacher = unit.getTeacher();
            if (teacher != null) {
                teacher.setStudent(null);
                unit.setTeacher(null);
            }
            owner.modifyScore(-unit.getType().getScoreValue());
            this.updatePopulation(-1);
            unit.setState(Unit.UnitState.ACTIVE);
            if (owner.isAI()) {
                this.firePropertyChange(REARRANGE_WORKERS, true, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addGoods(GoodsType type, int amount) {
        super.addGoods(type, amount);
        this.productionCache.invalidate(type);
        this.modifySpecialGoods(type, amount);
        return true;
    }

    @Override
    public Goods removeGoods(GoodsType type, int amount) {
        Goods removed = super.removeGoods(type, amount);
        this.productionCache.invalidate(type);
        if (removed != null) {
            this.modifySpecialGoods(type, -removed.getAmount());
        }
        return removed;
    }

    protected void modifySpecialGoods(GoodsType goodsType, int amount) {
        Set<Modifier> immigrationModifiers;
        Set<Modifier> libertyModifiers = goodsType.getModifierSet("model.modifier.liberty");
        if (!libertyModifiers.isEmpty()) {
            int newLiberty = (int)FeatureContainer.applyModifierSet(amount, this.getGame().getTurn(), libertyModifiers);
            this.incrementLiberty(newLiberty);
            this.getOwner().incrementLiberty(newLiberty);
        }
        if (!(immigrationModifiers = goodsType.getModifierSet("model.modifier.immigration")).isEmpty()) {
            int newImmigration = (int)FeatureContainer.applyModifierSet(amount, this.getGame().getTurn(), immigrationModifiers);
            this.incrementImmigration(newImmigration);
            this.getOwner().incrementImmigration(newImmigration);
        }
    }

    public int getWorkLocationUnitCount() {
        int count = 0;
        for (WorkLocation w : this.getCurrentWorkLocations()) {
            count += w.getUnitCount();
        }
        return count;
    }

    public int getDisplayUnitCount() {
        return this.displayUnitCount > 0 ? this.displayUnitCount : this.getUnitCount();
    }

    public void setDisplayUnitCount(int displayUnitCount) {
        this.displayUnitCount = displayUnitCount;
    }

    public boolean canTrain(Unit unit) {
        return this.canTrain(unit.getType());
    }

    public boolean canTrain(UnitType unitType) {
        if (!this.hasAbility("model.ability.teach")) {
            return false;
        }
        for (Building building : this.buildingMap.values()) {
            if (!building.canTeach() || !building.canAddType(unitType)) continue;
            return true;
        }
        return false;
    }

    public List<Unit> getTeachers() {
        ArrayList<Unit> teachers = new ArrayList<Unit>();
        for (Building building : this.buildingMap.values()) {
            if (!building.canTeach()) continue;
            teachers.addAll(building.getUnitList());
        }
        return teachers;
    }

    public Unit findTeacher(Unit student) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        for (Building building : this.getBuildings()) {
            if (!building.canTeach()) continue;
            for (Unit unit : building.getUnitList()) {
                if (unit.getStudent() != null || !student.canBeStudent(unit)) continue;
                return unit;
            }
        }
        return null;
    }

    public Unit findStudent(Unit teacher) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        Unit student = null;
        GoodsType expertProduction = teacher.getType().getExpertProduction();
        int skillLevel = Integer.MAX_VALUE;
        for (Unit potentialStudent : this.getUnitList()) {
            if (potentialStudent.getTeacher() != null || !potentialStudent.canBeStudent(teacher) || student != null && potentialStudent.getSkillLevel() >= skillLevel && (potentialStudent.getSkillLevel() != skillLevel || potentialStudent.getWorkType() != expertProduction)) continue;
            student = potentialStudent;
            skillLevel = student.getSkillLevel();
        }
        return student;
    }

    public UnitType getBestDefenderType() {
        UnitType bestDefender = null;
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (unitType.getDefence() <= 0 || bestDefender != null && bestDefender.getDefence() >= unitType.getDefence() || unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(this.getOwner())) continue;
            bestDefender = unitType;
        }
        return bestDefender;
    }

    public float getTotalDefencePower() {
        CombatModel cm = this.getGame().getCombatModel();
        float defence = 0.0f;
        for (Unit unit : this.getTile().getUnitList()) {
            if (!unit.isDefensiveUnit()) continue;
            defence += cm.getDefencePower(null, unit);
        }
        return defence;
    }

    public boolean canBePillaged(Unit attacker) {
        return !this.hasStockade() && attacker.hasAbility("model.ability.pillageUnprotectedColony") && (!this.getBurnableBuildingList().isEmpty() || !this.getShipList().isEmpty() || !this.getLootableGoodsList().isEmpty() && attacker.getType().canCarryGoods() && attacker.hasSpaceLeft() || this.canBePlundered());
    }

    public boolean canBePlundered() {
        return this.owner.checkGold(1);
    }

    public boolean isUnderSiege() {
        int friendlyUnits = 0;
        int enemyUnits = 0;
        for (ColonyTile colonyTile : this.colonyTiles) {
            for (Unit unit : colonyTile.getWorkTile().getUnitList()) {
                if (unit.getOwner() == this.getOwner()) {
                    if (!unit.isDefensiveUnit()) continue;
                    ++friendlyUnits;
                    continue;
                }
                if (!this.getOwner().atWarWith(unit.getOwner()) || !unit.isOffensiveUnit()) continue;
                ++enemyUnits;
            }
        }
        return enemyUnits > friendlyUnits;
    }

    public List<Building> getBurnableBuildingList() {
        ArrayList<Building> buildingList = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (!building.canBeDamaged()) continue;
            buildingList.add(building);
        }
        return buildingList;
    }

    public List<Unit> getShipList() {
        ArrayList<Unit> shipList = new ArrayList<Unit>();
        for (Unit u : this.getTile().getUnitList()) {
            if (!u.isNaval()) continue;
            shipList.add(u);
        }
        return shipList;
    }

    public List<Goods> getLootableGoodsList() {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (Goods goods : this.getGoodsContainer().getGoods()) {
            if (!goods.getType().isStorable()) continue;
            goodsList.add(goods);
        }
        return goodsList;
    }

    public List<UnitType> getBuildableUnits() {
        ArrayList<UnitType> buildableUnits = new ArrayList<UnitType>();
        List<UnitType> unitTypes = this.getSpecification().getUnitTypeList();
        for (UnitType unitType : unitTypes) {
            if (!unitType.needsGoodsToBuild() || !this.canBuild(unitType)) continue;
            buildableUnits.add(unitType);
        }
        return buildableUnits;
    }

    public BuildableType getCurrentlyBuilding() {
        return this.buildQueue.getCurrentlyBuilding();
    }

    public void setCurrentlyBuilding(BuildableType buildable) {
        this.buildQueue.setCurrentlyBuilding(buildable);
    }

    public int getTurnsToComplete(BuildableType buildable) {
        return this.getTurnsToComplete(buildable, null);
    }

    public int getTurnsToComplete(BuildableType buildable, AbstractGoods needed) {
        int result = 0;
        boolean goodsMissing = false;
        boolean goodsBeingProduced = false;
        boolean productionMissing = false;
        ProductionInfo info = this.productionCache.getProductionInfo(this.buildQueue);
        for (AbstractGoods ag : buildable.getRequiredGoods()) {
            int amountNeeded = ag.getAmount();
            int amountAvailable = this.getGoodsCount(ag.getType());
            if (amountAvailable >= amountNeeded) continue;
            goodsMissing = true;
            int amountProduced = this.productionCache.getNetProductionOf(ag.getType());
            if (info != null) {
                for (AbstractGoods consumed : info.getConsumption()) {
                    if (consumed.getType() != ag.getType()) continue;
                    amountProduced += consumed.getAmount();
                    break;
                }
            }
            if (amountProduced <= 0) {
                productionMissing = true;
                if (needed == null) continue;
                needed.setType(ag.getType());
                needed.setAmount(ag.getAmount());
                continue;
            }
            goodsBeingProduced = true;
            int amountRemaining = amountNeeded - amountAvailable;
            int eta = amountRemaining / amountProduced;
            if (amountRemaining % amountProduced != 0) {
                ++eta;
            }
            result = Math.max(result, eta);
        }
        return !goodsMissing ? 0 : (!goodsBeingProduced ? Integer.MIN_VALUE : (productionMissing ? -result : result));
    }

    public List<BuildableType> getBuildQueue() {
        return this.buildQueue.getValues();
    }

    public void setBuildQueue(List<BuildableType> newBuildQueue) {
        this.buildQueue.setValues(newBuildQueue);
    }

    public int getLiberty() {
        return this.liberty;
    }

    public void addLiberty(int amount) {
        this.getOwner().incrementLiberty(amount);
        List<GoodsType> libertyTypeList = this.getSpecification().getLibertyGoodsTypeList();
        int uc = this.getUnitCount();
        if (Colony.calculateRebels(uc, this.sonsOfLiberty) <= uc + 1 && amount > 0 && !libertyTypeList.isEmpty()) {
            this.addGoods(libertyTypeList.get(0), amount);
        }
        this.updateSoL();
    }

    public int getImmigration() {
        return this.immigration;
    }

    @Override
    public int getConsumptionOf(GoodsType goodsType) {
        Specification spec = this.getSpecification();
        int result = super.getConsumptionOf(goodsType);
        if (spec.getGoodsType("model.goods.bells").equals(goodsType)) {
            result -= spec.getInteger("model.option.unitsThatUseNoBells");
        }
        return Math.max(0, result);
    }

    public void updateSoL() {
        int uc = this.getUnitCount();
        this.oldSonsOfLiberty = this.sonsOfLiberty;
        this.oldTories = this.tories;
        this.sonsOfLiberty = Colony.calculateSoL(uc, this.liberty);
        this.tories = uc - Colony.calculateRebels(uc, this.sonsOfLiberty);
    }

    private static int calculateSoL(int uc, int liberty) {
        if (uc <= 0) {
            return 0;
        }
        int membership = liberty * 100 / (200 * uc);
        if (membership < 0) {
            membership = 0;
        } else if (membership > 100) {
            membership = 100;
        }
        return membership;
    }

    public static int calculateRebels(int uc, int solPercent) {
        return (int)Math.floor(0.01 * (double)solPercent * (double)uc);
    }

    public int getTory() {
        return 100 - this.getSoL();
    }

    public int getProductionBonus() {
        return this.productionBonus;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public int getFoodProduction() {
        int result = 0;
        for (GoodsType foodType : this.getSpecification().getFoodGoodsTypeList()) {
            result += this.getTotalProductionOf(foodType);
        }
        return result;
    }

    public WorkLocation getVacantWorkLocationFor(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit);
        if (occupation == null) {
            return null;
        }
        return occupation.workLocation;
    }

    private Occupation getOccupationFor(Unit unit) {
        ColonyTile colonyTile;
        for (AbstractGoods consumption : unit.getType().getConsumedGoods()) {
            if (!consumption.getType().isFoodType() || this.productionCache.getNetProductionOf(consumption.getType()) >= consumption.getAmount()) continue;
            ArrayList<GoodsType> rawTypes = new ArrayList<GoodsType>();
            for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
                if (type.getStoredAs() != consumption.getType()) continue;
                rawTypes.add(type);
            }
            rawTypes.add(consumption.getType());
            ColonyTile bestTile = null;
            GoodsType bestWork = null;
            int bestAmount = 0;
            block8: for (ColonyTile tile : this.colonyTiles) {
                switch (tile.getNoAddReason(unit)) {
                    case NONE: 
                    case ALREADY_PRESENT: {
                        for (GoodsType type : rawTypes) {
                            int amount = tile.getPotentialProduction(type, unit.getType());
                            if (amount <= bestAmount) continue;
                            bestAmount = amount;
                            bestWork = type;
                            bestTile = tile;
                        }
                        continue block8;
                    }
                }
            }
            if (bestAmount > 0) {
                return new Occupation(bestTile, bestWork);
            }
            for (GoodsType type : rawTypes) {
                for (Building building : this.getBuildingsForProducing(type)) {
                    switch (building.getNoAddReason(unit)) {
                        case NONE: 
                        case ALREADY_PRESENT: {
                            return new Occupation(building, type);
                        }
                    }
                }
            }
        }
        GoodsType expertProduction = unit.getType().getExpertProduction();
        if (expertProduction == null) {
            if (unit.getExperience() > 0 && (expertProduction = unit.getWorkType()) != null && expertProduction.isFarmed() && (colonyTile = this.getVacantColonyTileFor(unit, false, expertProduction)) != null) {
                return new Occupation(colonyTile, expertProduction);
            }
        } else if (expertProduction.isFarmed()) {
            colonyTile = this.getVacantColonyTileFor(unit, false, expertProduction);
            if (colonyTile != null) {
                return new Occupation(colonyTile, expertProduction);
            }
        } else {
            Building building = this.getBuildingFor(unit);
            if (building != null) {
                return new Occupation(building, building.getGoodsOutputType());
            }
        }
        ColonyTile bestTile = null;
        GoodsType bestType = null;
        int bestProduction = 0;
        for (GoodsType foodType : this.getSpecification().getFoodGoodsTypeList()) {
            int production;
            ColonyTile colonyTile2 = this.getVacantColonyTileFor(unit, false, foodType);
            if (colonyTile2 == null || (production = colonyTile2.getPotentialProduction(foodType, unit.getType())) <= bestProduction) continue;
            bestProduction = production;
            bestTile = colonyTile2;
            bestType = foodType;
        }
        if (bestTile != null) {
            return new Occupation(bestTile, bestType);
        }
        Building building = this.getBuildingFor(unit);
        if (building != null) {
            return new Occupation(building, building.getGoodsOutputType());
        }
        return null;
    }

    public Building getBuildingFor(Unit unit) {
        Building best;
        GoodsType expertProduction = unit.getType().getExpertProduction();
        if (expertProduction != null && !expertProduction.isFarmed() && (best = this.getBuildingFor(unit, expertProduction)) != null) {
            return best;
        }
        ArrayList<Building> buildings = new ArrayList<Building>(this.getBuildings());
        for (Building building : buildings) {
            switch (building.getNoAddReason(unit)) {
                case NONE: 
                case ALREADY_PRESENT: {
                    if (building.getGoodsInputType() != null && this.getGoodsCount(building.getGoodsInputType()) <= 0) break;
                    return building;
                }
            }
        }
        return null;
    }

    public Building getBuildingFor(Unit unit, GoodsType goodsType) {
        ArrayList<Building> buildings = new ArrayList<Building>(this.getBuildingsForProducing(goodsType));
        Building best = null;
        int bestProd = 0;
        for (Building building : buildings) {
            switch (building.getNoAddReason(unit)) {
                case NONE: 
                case ALREADY_PRESENT: {
                    int prod = building.getPotentialProduction(goodsType, unit.getType());
                    if (prod <= bestProd) break;
                    bestProd = prod;
                    best = building;
                    break;
                }
            }
        }
        return best;
    }

    public ColonyTile getVacantColonyTileFor(Unit unit, boolean allowClaim, GoodsType ... goodsTypes) {
        ColonyTile best = null;
        int bestProd = 0;
        block4: for (ColonyTile colonyTile : this.colonyTiles) {
            Tile workTile = colonyTile.getWorkTile();
            switch (colonyTile.getNoAddReason(unit)) {
                case CLAIM_REQUIRED: {
                    if (this.owner.getLandPrice(workTile) < 0) {
                        allowClaim = false;
                    }
                }
                case NONE: 
                case ALREADY_PRESENT: {
                    if (workTile.getOwningSettlement() != this && !allowClaim) break;
                    for (GoodsType goodsType : goodsTypes) {
                        int prod = colonyTile.getPotentialProduction(goodsType, unit.getType());
                        if (prod <= bestProd) continue;
                        bestProd = prod;
                        best = colonyTile;
                    }
                    continue block4;
                }
            }
        }
        return best;
    }

    public boolean canBreed(GoodsType goodsType) {
        int breedingNumber = goodsType.getBreedingNumber();
        return breedingNumber < Integer.MAX_VALUE && breedingNumber <= this.getGoodsCount(goodsType);
    }

    public boolean canBuild() {
        return this.canBuild(this.getCurrentlyBuilding());
    }

    public boolean canBuild(BuildableType buildableType) {
        return this.getNoBuildReason(buildableType) == NoBuildReason.NONE;
    }

    public NoBuildReason getNoBuildReason(BuildableType buildableType) {
        if (buildableType == null) {
            return NoBuildReason.NOT_BUILDING;
        }
        if (!buildableType.needsGoodsToBuild()) {
            return NoBuildReason.NOT_BUILDABLE;
        }
        if (buildableType.getRequiredPopulation() > this.getUnitCount()) {
            return NoBuildReason.POPULATION_TOO_SMALL;
        }
        for (Map.Entry<String, Boolean> entry : buildableType.getRequiredAbilities().entrySet()) {
            if (this.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return NoBuildReason.MISSING_ABILITY;
        }
        if (buildableType.getLimits() != null) {
            for (Limit limit : buildableType.getLimits()) {
                if (limit.evaluate(this)) continue;
                return NoBuildReason.LIMIT_EXCEEDED;
            }
        }
        if (buildableType instanceof BuildingType) {
            BuildingType newBuildingType = (BuildingType)buildableType;
            Building colonyBuilding = this.getBuilding(newBuildingType);
            if (colonyBuilding == null ? newBuildingType.getUpgradesFrom() != null : colonyBuilding.getType().getUpgradesTo() != newBuildingType) {
                return NoBuildReason.WRONG_UPGRADE;
            }
        } else if (buildableType instanceof UnitType && !buildableType.hasAbility("model.ability.person") && !this.hasAbility("model.ability.build", buildableType)) {
            return NoBuildReason.MISSING_BUILD_ABILITY;
        }
        return NoBuildReason.NONE;
    }

    public int getPriceForBuilding() {
        return this.getPriceForBuilding(this.getCurrentlyBuilding());
    }

    public int getPriceForBuilding(BuildableType type) {
        return this.priceGoodsForBuilding(this.getGoodsForBuilding(type));
    }

    public int priceGoodsForBuilding(HashMap<GoodsType, Integer> required) {
        int price = 0;
        Market market = this.getOwner().getMarket();
        for (GoodsType goodsType : required.keySet()) {
            int amount = required.get(goodsType);
            if (goodsType.isStorable()) {
                price += market.getBidPrice(goodsType, amount) * 110 / 100;
                continue;
            }
            price += goodsType.getPrice() * amount;
        }
        return price;
    }

    public HashMap<GoodsType, Integer> getGoodsForBuilding(BuildableType type) {
        HashMap<GoodsType, Integer> result = new HashMap<GoodsType, Integer>();
        for (AbstractGoods goods : type.getRequiredGoods()) {
            GoodsType goodsType = goods.getType();
            int remaining = goods.getAmount() - this.getGoodsCount(goodsType);
            if (remaining <= 0) continue;
            result.put(goodsType, new Integer(remaining));
        }
        return result;
    }

    public boolean canPayToFinishBuilding() {
        return this.canPayToFinishBuilding(this.getCurrentlyBuilding());
    }

    public boolean canPayToFinishBuilding(BuildableType buildableType) {
        return buildableType != null && this.getOwner().checkGold(this.getPriceForBuilding(buildableType));
    }

    public Collection<StringTemplate> getWarnings(GoodsType goodsType, int amount, int production) {
        BuildableType currentlyBuilding;
        LinkedList<StringTemplate> result = new LinkedList<StringTemplate>();
        if (goodsType.isFoodType() && goodsType.isStorable()) {
            if (amount + production < 0) {
                result.add(StringTemplate.template("model.colony.famineFeared").addName("%colony%", this.getName()).addAmount("%number%", 0));
            }
        } else {
            int waste = amount + production - this.getWarehouseCapacity();
            if (waste > 0 && !this.getExportData(goodsType).isExported() && !goodsType.limitIgnored()) {
                result.add(StringTemplate.template("model.building.warehouseSoonFull").add("%goods%", goodsType.getNameKey()).addName("%colony%", this.getName()).addAmount("%amount%", waste));
            }
        }
        if ((currentlyBuilding = this.getCurrentlyBuilding()) != null) {
            for (AbstractGoods goods : currentlyBuilding.getRequiredGoods()) {
                if (!goods.getType().equals(goodsType) || amount >= goods.getAmount()) continue;
                result.add(StringTemplate.template("model.colony.buildableNeedsGoods").addName("%colony%", this.getName()).add("%buildable%", currentlyBuilding.getNameKey()).addAmount("%amount%", goods.getAmount() - amount).add("%goodsType%", goodsType.getNameKey()));
            }
        }
        for (Building b : this.getBuildingsForProducing(goodsType)) {
            this.addInsufficientProductionMessage(result, this.productionCache.getProductionInfo(b));
        }
        Building buildingForConsuming = this.getBuildingForConsuming(goodsType);
        if (buildingForConsuming != null && !buildingForConsuming.getGoodsOutputType().isStorable()) {
            this.addInsufficientProductionMessage(result, this.productionCache.getProductionInfo(buildingForConsuming));
        }
        return result;
    }

    private void addInsufficientProductionMessage(List<StringTemplate> warnings, ProductionInfo info) {
        int missingOutput;
        if (info != null && !info.getMaximumProduction().isEmpty() && (missingOutput = info.getMaximumProduction().get(0).getAmount() - info.getProduction().get(0).getAmount()) > 0) {
            GoodsType outputType = info.getProduction().get(0).getType();
            GoodsType inputType = info.getConsumption().isEmpty() ? null : info.getConsumption().get(0).getType();
            int missingInput = info.getMaximumConsumption().get(0).getAmount() - info.getConsumption().get(0).getAmount();
            warnings.add(StringTemplate.template("model.colony.insufficientProduction").addAmount("%outputAmount%", missingOutput).add("%outputType%", outputType.getNameKey()).addName("%colony%", this.getName()).addAmount("%inputAmount%", missingInput).add("%inputType%", inputType.getNameKey()));
        }
    }

    public int governmentChange(int unitCount) {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int rebelPercent = Colony.calculateSoL(unitCount, this.liberty);
        int rebelCount = Colony.calculateRebels(unitCount, rebelPercent);
        int loyalistCount = unitCount - rebelCount;
        int result = 0;
        if (rebelPercent >= veryGoodGovernment) {
            if (this.sonsOfLiberty < veryGoodGovernment) {
                result = 1;
            }
        } else if (rebelPercent >= goodGovernment) {
            if (this.sonsOfLiberty >= veryGoodGovernment) {
                result = -1;
            } else if (this.sonsOfLiberty < goodGovernment) {
                result = 1;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            result = -1;
        } else if (loyalistCount > veryBadGovernment) {
            if (this.tories <= veryBadGovernment) {
                result = -1;
            }
        } else if (loyalistCount > badGovernment) {
            if (this.tories <= badGovernment) {
                result = -1;
            } else if (this.tories > veryBadGovernment) {
                result = 1;
            }
        } else if (this.tories > badGovernment) {
            result = 1;
        }
        return result;
    }

    public ModelMessage checkForGovMgtChangeMessage() {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        String msgId = null;
        int number = 0;
        ModelMessage.MessageType msgType = ModelMessage.MessageType.GOVERNMENT_EFFICIENCY;
        if (this.sonsOfLiberty >= veryGoodGovernment) {
            if (this.oldSonsOfLiberty < veryGoodGovernment) {
                msgId = "model.colony.veryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            if (this.oldSonsOfLiberty == veryGoodGovernment) {
                msgId = "model.colony.lostVeryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            } else if (this.oldSonsOfLiberty < goodGovernment) {
                msgId = "model.colony.goodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
        } else {
            if (this.oldSonsOfLiberty >= goodGovernment) {
                msgId = "model.colony.lostGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
            if (this.tories > veryBadGovernment) {
                if (this.oldTories <= veryBadGovernment) {
                    msgId = "model.colony.veryBadGovernment";
                }
            } else if (this.tories > badGovernment) {
                if (this.oldTories <= badGovernment) {
                    msgId = "model.colony.badGovernment";
                } else if (this.oldTories > veryBadGovernment) {
                    msgId = "model.colony.governmentImproved1";
                }
            } else if (this.oldTories > badGovernment) {
                msgId = "model.colony.governmentImproved2";
            }
        }
        GoodsType bells = this.getSpecification().getGoodsType("model.goods.bells");
        return msgId == null ? null : new ModelMessage(msgType, msgId, this, bells).addName("%colony%", this.getName()).addAmount("%number%", number);
    }

    protected void updateProductionBonus() {
        int newBonus;
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int n = this.sonsOfLiberty >= veryGoodGovernment ? 2 : (this.sonsOfLiberty >= goodGovernment ? 1 : (this.tories > veryBadGovernment ? -2 : (newBonus = this.tories > badGovernment ? -1 : 0)));
        if (this.productionBonus != newBonus) {
            this.invalidateCache();
        }
        this.productionBonus = newBonus;
    }

    public int getPreferredSizeChange() {
        int i;
        int pop = this.getUnitCount();
        if (this.productionBonus < 0) {
            int i2;
            int limit = pop;
            for (i2 = 1; i2 < limit && this.governmentChange(pop - i2) != 1; ++i2) {
            }
            return -i2;
        }
        Specification spec = this.getSpecification();
        int limit = spec.getInteger("model.option.badGovernmentLimit");
        for (i = 1; i < limit && this.governmentChange(pop + i) != -1; ++i) {
        }
        return i - 1;
    }

    public Building getWarehouse() {
        for (Building building : this.buildingMap.values()) {
            if (building.getType().getModifierSet("model.modifier.warehouseStorage").isEmpty()) continue;
            return building;
        }
        return null;
    }

    public boolean hasStockade() {
        return this.getStockade() != null;
    }

    public Building getStockade() {
        for (Building building : this.buildingMap.values()) {
            if (building.getType().getModifierSet("model.modifier.defence").isEmpty()) continue;
            return building;
        }
        return null;
    }

    public String getStockadeKey() {
        return this.stockadeKey != null ? this.stockadeKey : this.getTrueStockadeKey();
    }

    public String getTrueStockadeKey() {
        Building stockade = this.getStockade();
        return stockade == null ? null : stockade.getType().getId().substring("model.building".length());
    }

    @Override
    public boolean hasAbility(String id, FreeColGameObjectType type, Turn turn) {
        if (turn == null) {
            turn = this.getGame().getTurn();
        }
        return super.hasAbility(id, type, turn) || this.owner != null && this.owner.hasAbility(id, type, turn);
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        Modifier result = new Modifier(goodsType.getId(), SOL_MODIFIER_SOURCE, this.productionBonus, Modifier.Type.ADDITIVE);
        result.setIndex(Modifier.COLONY_PRODUCTION_INDEX);
        return result;
    }

    public boolean canBombardEnemyShip() {
        if (this.isLandLocked()) {
            return false;
        }
        return this.hasAbility("model.ability.bombardShips");
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        for (WorkLocation workLocation : this.getAllWorkLocations()) {
            objects.addAll(((FreeColGameObject)workLocation).disposeList());
        }
        TileImprovement road = this.getTile().getRoad();
        if (road != null && road.isVirtual()) {
            this.getTile().getTileItemContainer().removeTileItem(road);
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public int getNetProductionOf(GoodsType goodsType) {
        return this.productionCache.getNetProductionOf(goodsType);
    }

    public boolean isProductive(WorkLocation workLocation) {
        ProductionInfo info = this.productionCache.getProductionInfo(workLocation);
        return info != null && info.getProduction() != null && !info.getProduction().isEmpty() && info.getProduction().get(0).getAmount() > 0;
    }

    public int getAdjustedNetProductionOf(GoodsType goodsType) {
        int result = this.productionCache.getNetProductionOf(goodsType);
        block0: for (BuildQueue queue : new BuildQueue[]{this.buildQueue, this.populationQueue}) {
            ProductionInfo info = this.productionCache.getProductionInfo(queue);
            if (info == null) continue;
            for (AbstractGoods goods : info.getConsumption()) {
                if (goods.getType() != goodsType) continue;
                result += goods.getAmount();
                continue block0;
            }
        }
        return result;
    }

    public ProductionInfo getProductionInfo(Object object) {
        return this.productionCache.getProductionInfo(object);
    }

    public void invalidateCache() {
        this.productionCache.invalidate();
    }

    protected TypeCountMap<GoodsType> getProductionMap() {
        return this.productionCache.getProductionMap();
    }

    public List<Consumer> getConsumers() {
        ArrayList<Consumer> result = new ArrayList<Consumer>();
        result.addAll(this.getUnitList());
        result.addAll(this.buildingMap.values());
        result.add(this.buildQueue);
        result.add(this.populationQueue);
        Collections.sort(result, Consumer.COMPARATOR);
        return result;
    }

    public void getColonyTileTodo(List<Tile> exploreTiles, List<Tile> clearTiles, List<Tile> plowTiles, List<Tile> roadTiles) {
        Specification spec = this.getSpecification();
        TileImprovementType clearImprovement = spec.getTileImprovementType("model.improvement.clearForest");
        TileImprovementType plowImprovement = spec.getTileImprovementType("model.improvement.plow");
        TileImprovementType roadImprovement = spec.getTileImprovementType("model.improvement.road");
        for (Tile t : this.getTile().getSurroundingTiles(1)) {
            if (!t.hasLostCityRumour()) continue;
            exploreTiles.add(t);
        }
        block1: for (ColonyTile ct : this.getColonyTiles()) {
            TileType newType;
            Tile t = ct.getWorkTile();
            if (t == null) continue;
            if ((t.getTileItemContainer() == null || t.getTileItemContainer().getImprovement(plowImprovement) == null) && plowImprovement.isTileTypeAllowed(t.getType())) {
                if (ct.isColonyCenterTile()) {
                    plowTiles.add(t);
                } else {
                    for (Unit u : ct.getUnitList()) {
                        if (u == null || u.getWorkType() == null || plowImprovement.getBonus(u.getWorkType()) <= 0) continue;
                        plowTiles.add(t);
                        break;
                    }
                }
            }
            if (ct.isColonyCenterTile() || ct.isEmpty()) continue;
            TileType oldType = t.getType();
            if ((t.getTileItemContainer() == null || t.getTileItemContainer().getImprovement(clearImprovement) == null) && clearImprovement.isTileTypeAllowed(t.getType()) && (newType = clearImprovement.getChange(oldType)) != null) {
                for (Unit u : ct.getUnitList()) {
                    if (newType.getProductionOf(u.getWorkType(), u.getType()) <= oldType.getProductionOf(u.getWorkType(), u.getType())) continue;
                    clearTiles.add(t);
                    break;
                }
            }
            if (t.getRoad() != null || !roadImprovement.isTileTypeAllowed(t.getType())) continue;
            for (Unit u : ct.getUnitList()) {
                if (roadImprovement.getBonus(u.getWorkType()) <= 0) continue;
                roadTiles.add(t);
                continue block1;
            }
        }
    }

    public Unit getBetterExpert(Unit expert) {
        GoodsType production = expert.getWorkType();
        GoodsType expertise = expert.getType().getExpertProduction();
        Unit bestExpert = null;
        int bestImprovement = 0;
        if (production == null || expertise == null || production == expertise) {
            return null;
        }
        for (Unit nonExpert : this.getUnitList()) {
            int improvement;
            ColonyTile nwl;
            if (nonExpert.getWorkType() != expertise || nonExpert.getType() == expert.getType()) continue;
            int expertProductionNow = 0;
            int nonExpertProductionNow = 0;
            int expertProductionPotential = 0;
            int nonExpertProductionPotential = 0;
            Building ewl = expert.getWorkLocation();
            if (ewl != null) {
                expertProductionNow = ((WorkLocation)ewl).getPotentialProduction(expertise, expert.getType());
                nonExpertProductionPotential = ((WorkLocation)ewl).getPotentialProduction(expertise, nonExpert.getType());
            }
            if ((nwl = nonExpert.getWorkTile()) != null) {
                nonExpertProductionNow = ((WorkLocation)nwl).getPotentialProduction(expertise, nonExpert.getType());
                expertProductionPotential = ((WorkLocation)nwl).getPotentialProduction(expertise, expert.getType());
            }
            if ((improvement = expertProductionPotential + nonExpertProductionPotential - expertProductionNow - nonExpertProductionNow) <= bestImprovement) continue;
            bestImprovement = improvement;
            bestExpert = nonExpert;
        }
        return bestExpert;
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.addUnit((Unit)locatable, null);
        }
        return super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.removeUnit((Unit)locatable);
        }
        return super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            throw new UnsupportedOperationException();
        }
        return super.contains(locatable);
    }

    @Override
    public int getUnitCount() {
        return this.unitCount >= 0 ? this.unitCount : this.getUnitList().size();
    }

    @Override
    public List<Unit> getUnitList() {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            units.addAll(wl.getUnitList());
        }
        return units;
    }

    @Override
    public final Colony getColony() {
        return this;
    }

    @Override
    public int getGoodsCapacity() {
        return (int)this.applyModifier(0.0f, "model.modifier.warehouseStorage", null, this.getGame().getTurn());
    }

    @Override
    public String getImageKey() {
        if (this.isUndead()) {
            return "undead";
        }
        int count = this.getDisplayUnitCount();
        String key = count <= 3 ? "small" : (count <= 7 ? "medium" : "large");
        String stockade = this.getStockadeKey();
        if (stockade != null) {
            key = key + stockade;
        }
        return "model.settlement." + key + ".image";
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return StringTemplate.name(this.getName());
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        List<Unit> unitList = this.getUnitList();
        if (this.unitCount >= 0 && unitList.isEmpty()) {
            return null;
        }
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : unitList) {
            float unitPower;
            if (!Unit.betterDefender(defender, defencePower, nextUnit, unitPower = this.getGame().getCombatModel().getDefencePower(attacker, nextUnit))) continue;
            defender = nextUnit;
            defencePower = unitPower;
        }
        if (defender == null) {
            throw new IllegalStateException("Colony " + this.getName() + " contains no units!");
        }
        return defender;
    }

    @Override
    public float getDefenceRatio() {
        return this.getTotalDefencePower() / (float)(1 + this.getWorkLocationUnitCount());
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        int upper;
        if (this.canBePlundered() && (upper = this.owner.getGold() * (this.getUnitCount() + 1) / (this.owner.getColoniesPopulation() + 1)) > 0) {
            return new RandomRange(100, 1, upper + 1, 1);
        }
        return null;
    }

    @Override
    public int getSoL() {
        return this.sonsOfLiberty;
    }

    @Override
    public int getUpkeep() {
        int upkeep = 0;
        for (Building building : this.buildingMap.values()) {
            upkeep += building.getType().getUpkeep();
        }
        return upkeep;
    }

    @Override
    public boolean propagateAlarm(Player player, int addToAlarm) {
        return false;
    }

    @Override
    public int getTotalProductionOf(GoodsType goodsType) {
        int amount = 0;
        for (WorkLocation workLocation : this.getCurrentWorkLocations()) {
            amount += workLocation.getTotalProductionOf(goodsType);
        }
        return amount;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Colony.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("established", Integer.toString(this.established.getNumber()));
        if (showAll || toSavedGame || player.owns(this)) {
            out.writeAttribute("sonsOfLiberty", Integer.toString(this.sonsOfLiberty));
            out.writeAttribute("oldSonsOfLiberty", Integer.toString(this.oldSonsOfLiberty));
            out.writeAttribute("tories", Integer.toString(this.tories));
            out.writeAttribute("oldTories", Integer.toString(this.oldTories));
            out.writeAttribute("liberty", Integer.toString(this.liberty));
            out.writeAttribute("immigration", Integer.toString(this.immigration));
            out.writeAttribute("productionBonus", Integer.toString(this.productionBonus));
            out.writeAttribute("landLocked", Boolean.toString(this.landLocked));
        } else {
            PlayerExploredTile pet = this.getTile().getPlayerExploredTile(player);
            if (pet != null) {
                if (pet.getColonyUnitCount() > 0) {
                    out.writeAttribute("unitCount", Integer.toString(pet.getColonyUnitCount()));
                }
                if (pet.getColonyStockadeKey() != null) {
                    out.writeAttribute("stockadeKey", pet.getColonyStockadeKey());
                }
            }
        }
        this.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (showAll || toSavedGame || player.owns(this)) {
            for (ExportData data : this.exportData.values()) {
                data.toXML(out);
            }
            Turn turn = this.getGame().getTurn();
            for (Modifier modifier : this.getModifiers()) {
                if (!modifier.hasIncrement() || modifier.isOutOfDate(turn)) continue;
                modifier.toXML(out);
            }
            for (WorkLocation workLocation : this.getAllWorkLocations()) {
                workLocation.toXML(out, player, showAll, toSavedGame);
            }
            for (BuildableType buildableType : this.buildQueue.getValues()) {
                out.writeStartElement(BUILD_QUEUE_TAG);
                out.writeAttribute("id", buildableType.getId());
                out.writeEndElement();
            }
            for (BuildableType buildableType : this.populationQueue.getValues()) {
                out.writeStartElement(POPULATION_QUEUE_TAG);
                out.writeAttribute("id", buildableType.getId());
                out.writeEndElement();
            }
            super.writeChildren(out, player, showAll, toSavedGame);
        }
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.owner.addSettlement(this);
        this.established = new Turn(this.getAttribute(in, "established", 0));
        this.sonsOfLiberty = this.getAttribute(in, "sonsOfLiberty", 0);
        this.oldSonsOfLiberty = this.getAttribute(in, "oldSonsOfLiberty", 0);
        this.tories = this.getAttribute(in, "tories", 0);
        this.oldTories = this.getAttribute(in, "oldTories", 0);
        this.liberty = this.getAttribute(in, "liberty", 0);
        this.immigration = this.getAttribute(in, "immigration", 0);
        this.productionBonus = this.getAttribute(in, "productionBonus", 0);
        this.landLocked = this.getAttribute(in, "landLocked", true);
        if (!this.landLocked) {
            this.addAbility(HAS_PORT);
        }
        this.unitCount = this.getAttribute(in, "unitCount", -1);
        this.stockadeKey = in.getAttributeValue(null, "stockadeKey");
    }

    @Override
    public void readChildren(XMLStreamReader in) throws XMLStreamException {
        int oldUnitCount = this.getUnitCount();
        this.colonyTiles.clear();
        this.buildingMap.clear();
        this.exportData.clear();
        this.buildQueue.clear();
        this.populationQueue.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(ColonyTile.getXMLElementTagName())) {
                ColonyTile ct = this.updateFreeColGameObject(in, ColonyTile.class);
                this.colonyTiles.add(ct);
                continue;
            }
            if (in.getLocalName().equals(Building.getXMLElementTagName())) {
                Building building = this.updateFreeColGameObject(in, Building.class);
                this.addBuilding(building);
                continue;
            }
            if (in.getLocalName().equals(ExportData.getXMLElementTagName())) {
                ExportData data = new ExportData();
                data.readFromXML(in);
                this.exportData.put(data.getId(), data);
                continue;
            }
            if (Modifier.getXMLElementTagName().equals(in.getLocalName())) {
                Modifier m = new Modifier(in, this.getSpecification());
                if (m.hasIncrement()) {
                    this.addModifier(m);
                    continue;
                }
                logger.warning("Ignoring non-timed colony modifier: " + m.toString());
                continue;
            }
            if ("buildQueue".equals(in.getLocalName())) {
                int size = this.getAttribute(in, "xLength", 0);
                if (size > 0) {
                    for (int x = 0; x < size; ++x) {
                        String typeId = in.getAttributeValue(null, "x" + Integer.toString(x));
                        this.buildQueue.add(this.getSpecification().getType(typeId, BuildableType.class));
                    }
                }
                in.nextTag();
                continue;
            }
            if (BUILD_QUEUE_TAG.equals(in.getLocalName())) {
                String id = in.getAttributeValue(null, "id");
                this.buildQueue.add(this.getSpecification().getType(id, BuildableType.class));
                in.nextTag();
                continue;
            }
            if (POPULATION_QUEUE_TAG.equals(in.getLocalName())) {
                String id = in.getAttributeValue(null, "id");
                this.populationQueue.add((UnitType)((BuildableType)this.getSpecification().getType(id, UnitType.class)));
                in.nextTag();
                continue;
            }
            super.readChild(in);
        }
        if (this.populationQueue.isEmpty()) {
            for (UnitType unitType : this.getSpecification().getUnitTypesWithAbility("model.ability.bornInColony")) {
                GoodsType food = this.getSpecification().getGoodsType("model.goods.food");
                List<AbstractGoods> required = unitType.getRequiredGoods();
                boolean found = false;
                for (AbstractGoods goods : required) {
                    if (goods.getType() != food) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    required.add(new AbstractGoods(food, 200));
                    unitType.setRequiredGoods(required);
                }
                this.populationQueue.add(unitType);
            }
        }
        if (this.owner.isAI() && this.getUnitCount() != oldUnitCount) {
            this.firePropertyChange(REARRANGE_WORKERS, true, false);
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    public void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "colony";
    }

    private class Occupation {
        public WorkLocation workLocation;
        public GoodsType workType;

        public Occupation(WorkLocation workLocation, GoodsType workType) {
            this.workLocation = workLocation;
            this.workType = workType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoBuildReason {
        NONE,
        NOT_BUILDING,
        NOT_BUILDABLE,
        POPULATION_TOO_SMALL,
        MISSING_BUILD_ABILITY,
        MISSING_ABILITY,
        WRONG_UPGRADE,
        LIMIT_EXCEEDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColonyChangeEvent {
        POPULATION_CHANGE,
        PRODUCTION_CHANGE,
        BONUS_CHANGE,
        WAREHOUSE_CHANGE,
        BUILD_QUEUE_CHANGE,
        UNIT_TYPE_CHANGE;

    }
}

