/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public class AbstractUnit
extends FreeColObject {
    private Unit.Role role = Unit.Role.DEFAULT;
    private int number = 1;
    private static final String ROLE_TAG = "role";
    private static final String NUMBER_TAG = "number";

    public AbstractUnit() {
    }

    public AbstractUnit(String id, Unit.Role someRole, int someNumber) {
        this.setId(id);
        this.role = someRole;
        this.number = someNumber;
    }

    public AbstractUnit(UnitType unitType, Unit.Role someRole, int someNumber) {
        this(unitType.getId(), someRole, someNumber);
    }

    public AbstractUnit(XMLStreamReader in) throws XMLStreamException {
        this.readFromXML(in);
    }

    public AbstractUnit clone() {
        return new AbstractUnit(this.getId(), this.getRole(), this.getNumber());
    }

    public final UnitType getUnitType(Specification specification) {
        return specification.getUnitType(this.getId());
    }

    public final Unit.Role getRole() {
        return this.role;
    }

    public final void setRole(Unit.Role newRole) {
        this.role = newRole;
    }

    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int newNumber) {
        this.number = newNumber;
    }

    public StringTemplate getLabel(Specification spec) {
        return StringTemplate.template("abstractUnit").addAmount("%number%", this.getNumber()).add("%unit%", this.getUnitType(spec).getNameKey());
    }

    public EquipmentType[] getEquipment(Specification spec) {
        ArrayList<EquipmentType> equipment = new ArrayList<EquipmentType>();
        switch (this.role) {
            case PIONEER: {
                EquipmentType tools = spec.getEquipmentType("model.equipment.tools");
                for (int count = 0; count < tools.getMaximumCount(); ++count) {
                    equipment.add(tools);
                }
                break;
            }
            case MISSIONARY: {
                equipment.add(spec.getEquipmentType("model.equipment.missionary"));
                break;
            }
            case SOLDIER: {
                equipment.add(spec.getEquipmentType("model.equipment.muskets"));
                break;
            }
            case SCOUT: {
                equipment.add(spec.getEquipmentType("model.equipment.horses"));
                break;
            }
            case DRAGOON: {
                equipment.add(spec.getEquipmentType("model.equipment.muskets"));
                equipment.add(spec.getEquipmentType("model.equipment.horses"));
                break;
            }
        }
        return equipment.toArray(new EquipmentType[equipment.size()]);
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, AbstractUnit.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, ROLE_TAG, this.role);
        this.writeAttribute(out, NUMBER_TAG, this.number);
    }

    protected final void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.role = this.getAttribute(in, ROLE_TAG, Unit.Role.class, Unit.Role.DEFAULT);
        this.number = this.getAttribute(in, NUMBER_TAG, 1);
    }

    public String toString() {
        return Integer.toString(this.number) + " " + this.getId() + " (" + this.role.toString() + ")";
    }

    public static String getXMLElementTagName() {
        return "abstractUnit";
    }
}

