/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;

public class AbstractGoods
extends FreeColObject {
    private GoodsType type;
    private int amount;
    private static final String TYPE_TAG = "type";
    private static final String AMOUNT_TAG = "amount";

    public AbstractGoods() {
    }

    public AbstractGoods(GoodsType type, int amount) {
        this.setId(type.getId());
        this.type = type;
        this.amount = amount;
    }

    public AbstractGoods(AbstractGoods other) {
        this.setId(other.type.getId());
        this.type = other.type;
        this.amount = other.amount;
    }

    public String getNameKey() {
        return this.getType().getNameKey();
    }

    public final GoodsType getType() {
        return this.type;
    }

    public final void setType(GoodsType newType) {
        this.type = newType;
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int newAmount) {
        this.amount = newAmount;
    }

    public boolean equals(AbstractGoods other) {
        return this.type == other.type && this.amount == other.amount;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, AbstractGoods.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, TYPE_TAG, this.type);
        out.writeAttribute(AMOUNT_TAG, Integer.toString(this.amount));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        Specification spec = this.getSpecification();
        this.type = spec.getType(in, TYPE_TAG, GoodsType.class, null);
        this.amount = this.getAttribute(in, AMOUNT_TAG, 0);
    }

    public String toString() {
        return Integer.toString(this.amount) + " " + this.type.getId();
    }

    public static String getXMLElementTagName() {
        return "abstractGoods";
    }
}

