/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import javax.swing.filechooser.FileSystemView;

public class FreeColDirectories {
    public static final String COPYRIGHT = "Copyright (C) 2003-2012 The FreeCol Team";
    public static final String LICENSE = "http://www.gnu.org/licenses/gpl.html";
    public static final String REVISION = "$Revision: 2763 $";
    private static File saveDirectory;
    private static File autoSaveDirectory;
    private static File mainUserDirectory;
    private static File tcUserDirectory;
    private static File userModsDirectory;
    private static String tc;
    private static File savegameFile;
    public static final String DEFAULT_TC = "freecol";
    private static String dataFolder;
    private static File clientOptionsFile;
    private static final String HIGH_SCORE_FILE = "HighScores.xml";
    private static final String DIRECTORY = "rules";
    private static final String STRINGS_DIRECTORY = "strings";

    public static void createAndSetDirectories() {
        String freeColDirectoryName = "/".equals(System.getProperty("file.separator")) ? ".freecol" : DEFAULT_TC;
        File userHome = FileSystemView.getFileSystemView().getDefaultDirectory();
        if (System.getProperty("os.name").equals("Mac OS X")) {
            if (!new File(userHome, freeColDirectoryName).isDirectory()) {
                userHome = new File(userHome, "Library");
                freeColDirectoryName = "FreeCol";
            }
        } else if (System.getProperty("os.name").startsWith("Windows") && !new File(userHome, freeColDirectoryName).isDirectory()) {
            freeColDirectoryName = "FreeCol";
        }
        if (mainUserDirectory == null) {
            FreeColDirectories.setMainUserDirectory(new File(userHome, freeColDirectoryName));
        }
        if (!FreeColDirectories.insistDirectory(mainUserDirectory)) {
            return;
        }
        if (saveDirectory == null) {
            saveDirectory = new File(FreeColDirectories.getMainUserDirectory(), "save");
        }
        if (!FreeColDirectories.insistDirectory(saveDirectory)) {
            saveDirectory = null;
        }
        if (!FreeColDirectories.insistDirectory(autoSaveDirectory = new File(saveDirectory, "autosave"))) {
            autoSaveDirectory = null;
        }
        if (!FreeColDirectories.insistDirectory(tcUserDirectory = new File(FreeColDirectories.getMainUserDirectory(), FreeColDirectories.getTc()))) {
            tcUserDirectory = null;
        }
        if (!FreeColDirectories.insistDirectory(userModsDirectory = new File(FreeColDirectories.getMainUserDirectory(), "mods"))) {
            userModsDirectory = null;
        }
        if (clientOptionsFile == null) {
            clientOptionsFile = tcUserDirectory == null ? null : new File(tcUserDirectory, "options.xml");
        }
    }

    public static File getAutosaveDirectory() {
        return autoSaveDirectory;
    }

    public static File getBaseDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), "base");
    }

    public static File getClientOptionsFile() {
        return clientOptionsFile;
    }

    public static File getDataDirectory() {
        if (dataFolder.equals("")) {
            return new File("data");
        }
        return new File(dataFolder);
    }

    public static File getHighScoreFile() {
        return new File(FreeColDirectories.getDataDirectory(), HIGH_SCORE_FILE);
    }

    public static File getI18nDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), STRINGS_DIRECTORY);
    }

    public static File getMainUserDirectory() {
        return mainUserDirectory;
    }

    public static File getMapsDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), "maps");
    }

    public static File getOptionsDirectory() {
        return tcUserDirectory;
    }

    public static File getRulesClassicDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), "rules/classic");
    }

    public static File getRulesDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), DIRECTORY);
    }

    public static File getSaveDirectory() {
        return saveDirectory;
    }

    public static File getSavegameFile() {
        return savegameFile;
    }

    public static File getStandardModsDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), "mods");
    }

    public static String getTc() {
        return tc;
    }

    public static File getUserModsDirectory() {
        return userModsDirectory;
    }

    public static boolean insistDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            System.out.println("Could not create directory " + file.getName() + " under " + file.getParentFile().getName() + " because a non-directory with that name is already there.");
            return false;
        }
        return file.mkdir();
    }

    public static void setClientOptionsFile(File file) {
        clientOptionsFile = file;
    }

    public static void setDataFolder(String dataFolder) {
        FreeColDirectories.dataFolder = dataFolder;
    }

    public static void setMainUserDirectory(File mainUserDirectory) {
        FreeColDirectories.mainUserDirectory = mainUserDirectory;
    }

    public static void setSaveDirectory(File saveDirectory) {
        FreeColDirectories.saveDirectory = saveDirectory;
    }

    public static void setSavegameFile(File savegameFile) {
        FreeColDirectories.savegameFile = savegameFile;
    }

    public static void setSaveGameFile(String name) {
        FreeColDirectories.setSavegameFile(new File(name));
        if (!FreeColDirectories.getSavegameFile().exists() || !FreeColDirectories.getSavegameFile().isFile()) {
            FreeColDirectories.setSavegameFile(new File(FreeColDirectories.getSaveDirectory(), name));
            if (!FreeColDirectories.getSavegameFile().exists() || !FreeColDirectories.getSavegameFile().isFile()) {
                System.out.println("Could not find savegame file: " + name);
                System.exit(1);
            }
        } else {
            FreeColDirectories.setSaveDirectory(FreeColDirectories.getSavegameFile().getParentFile());
        }
    }

    public static void setTc(String tc) {
        FreeColDirectories.tc = tc;
    }

    static {
        mainUserDirectory = null;
        tc = DEFAULT_TC;
        savegameFile = null;
        dataFolder = "data";
        clientOptionsFile = null;
    }
}

