/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.debug;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugUtils {
    private static final Logger logger = Logger.getLogger(DebugUtils.class.getName());

    public static void addBuildings(FreeColClient freeColClient, String buildingTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ArrayList buildings = new ArrayList();
        for (BuildingType b : game.getSpecification().getBuildingTypeList()) {
            String msg = Messages.message(b.toString() + ".name");
            buildings.add(new ChoiceItem<BuildingType>(msg, b));
        }
        BuildingType buildingType = (BuildingType)gui.showChoiceDialog(null, buildingTitle, "Cancel", buildings);
        if (buildingType == null) {
            return;
        }
        ServerGame sGame = server.getGame();
        BuildingType sBuildingType = server.getSpecification().getBuildingType(buildingType.getId());
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        ArrayList<String> results = new ArrayList<String>();
        int fails = 0;
        for (Colony sColony : sPlayer.getColonies()) {
            Colony.NoBuildReason reason = sColony.getNoBuildReason(sBuildingType);
            results.add(sColony.getName() + ": " + reason.toString());
            if (reason == Colony.NoBuildReason.NONE) {
                ServerBuilding sBuilding = new ServerBuilding(sGame, sColony, sBuildingType);
                sColony.addBuilding(sBuilding);
                continue;
            }
            ++fails;
        }
        gui.showInformationMessage(Utils.join(", ", results));
        if (fails < sPlayer.getNumberOfSettlements()) {
            freeColClient.getConnectController().reconnect();
        }
    }

    public static void addFathers(FreeColClient freeColClient, String fatherTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        ArrayList<ChoiceItem<FoundingFather>> fathers = new ArrayList<ChoiceItem<FoundingFather>>();
        for (FoundingFather father : sSpec.getFoundingFathers()) {
            if (sPlayer.hasFather(father)) continue;
            String msg = Messages.message(father.getNameKey());
            fathers.add(new ChoiceItem<FoundingFather>(msg, father));
        }
        FoundingFather father = gui.showChooseFoundingFatherDialog(fathers, fatherTitle);
        if (father != null) {
            server.getInGameController().addFoundingFather((ServerPlayer)sPlayer, father);
        }
    }

    public static void addGold(FreeColClient freeColClient) {
        int gold;
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        String response = gui.showInputDialog(null, StringTemplate.key("menuBar.debug.addGold"), Integer.toString(1000), "ok", "cancel", true);
        try {
            gold = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        player.modifyGold(gold);
        sPlayer.modifyGold(gold);
    }

    public static void addImmigration(FreeColClient freeColClient) {
        int crosses;
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        String response = gui.showInputDialog(null, StringTemplate.key("menuBar.debug.addImmigration"), Integer.toString(100), "ok", "cancel", true);
        try {
            crosses = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        player.incrementImmigration(crosses);
        sPlayer.incrementImmigration(crosses);
    }

    public static void addLiberty(FreeColClient freeColClient) {
        int liberty;
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        String response = gui.showInputDialog(null, StringTemplate.key("menuBar.debug.addLiberty"), Integer.toString(100), "ok", "cancel", true);
        try {
            liberty = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        for (Colony c : player.getColonies()) {
            c.addLiberty(liberty);
            sGame.getFreeColGameObject(c.getId(), Colony.class).addLiberty(liberty);
        }
    }

    public static void addSkipChangeListener(FreeColClient freeColClient, JMenu menu, final JMenuItem item) {
        final FreeColServer server = freeColClient.getFreeColServer();
        menu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean skipping = server.getInGameController().getSkippedTurns() > 0;
                item.setText(Messages.message(skipping ? "menuBar.debug.stopSkippingTurns" : "menuBar.debug.skipTurns"));
            }
        });
    }

    public static void addNewUnitToTile(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Game game = freeColClient.getGame();
        Specification sSpec = sGame.getSpecification();
        Player player = freeColClient.getMyPlayer();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        GUI gui = freeColClient.getGUI();
        ArrayList uts = new ArrayList();
        for (UnitType t : sSpec.getUnitTypeList()) {
            String msg = Messages.message(t.toString() + ".name");
            uts.add(new ChoiceItem<UnitType>(msg, t));
        }
        UnitType unitChoice = (UnitType)gui.showChoiceDialog(null, "Select Unit Type", "Cancel", uts);
        if (unitChoice == null) {
            return;
        }
        Unit carrier = null;
        UnitLocation sCarrier = null;
        if (!sTile.isLand() && !unitChoice.isNaval()) {
            for (Unit u : sTile.getUnitList()) {
                if (!u.isNaval() || u.getSpaceLeft() < unitChoice.getSpaceTaken()) continue;
                sCarrier = u;
                carrier = game.getFreeColGameObject(sCarrier.getId(), Unit.class);
                break;
            }
        }
        Tile loc = sCarrier != null ? sCarrier : sTile;
        ServerUnit sUnit = new ServerUnit(sGame, loc, sPlayer, unitChoice);
        sUnit.setMovesLeft(sUnit.getInitialMovesLeft());
        StringWriter sw = new StringWriter();
        try {
            XMLStreamWriter xsw = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            ((FreeColGameObject)loc).toXML(xsw, sPlayer, true, true);
            xsw.close();
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(sw.toString()));
            xsr.nextTag();
            if (carrier == null) {
                tile.updateFreeColGameObject(xsr, Tile.class);
            } else {
                carrier.updateFreeColGameObject(xsr, Unit.class);
            }
            xsr.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Add unit fail: " + sw.toString(), e);
        }
        Unit unit = game.getFreeColGameObject(sUnit.getId(), Unit.class);
        if (unit != null) {
            gui.setActiveUnit(unit);
            player.invalidateCanSeeTiles();
            gui.refresh();
        }
    }

    public static void addUnitGoods(FreeColClient freeColClient, Unit unit) {
        int a;
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        GUI gui = freeColClient.getGUI();
        ArrayList gtl = new ArrayList();
        for (GoodsType t : sSpec.getGoodsTypeList()) {
            if (t.isFoodType() && t != sSpec.getPrimaryFoodType()) continue;
            String msg = Messages.message(t.toString() + ".name");
            gtl.add(new ChoiceItem<GoodsType>(msg, t));
        }
        GoodsType goodsType = (GoodsType)gui.showChoiceDialog(null, "Select Goods Type", "Cancel", gtl);
        if (goodsType == null) {
            return;
        }
        String amount = gui.showInputDialog(null, StringTemplate.name("Select Goods Amount"), "20", "ok", "cancel", true);
        if (amount == null) {
            return;
        }
        try {
            a = Integer.parseInt(amount);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        GoodsType sGoodsType = sSpec.getGoodsType(goodsType.getId());
        GoodsContainer ugc = unit.getGoodsContainer();
        GoodsContainer sgc = sGame.getFreeColGameObject(ugc.getId(), GoodsContainer.class);
        ugc.setAmount(goodsType, a);
        sgc.setAmount(sGoodsType, a);
    }

    public static void checkDesyncAction(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        Map map = game.getMap();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Map sMap = sGame.getMap();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        GUI gui = freeColClient.getGUI();
        boolean problemDetected = false;
        for (Tile t : sMap.getAllTiles()) {
            if (!sPlayer.canSee(t)) continue;
            for (Unit u : t.getUnitList()) {
                if (!u.isVisibleTo(sPlayer)) continue;
                if (game.getFreeColGameObject(u.getId(), Unit.class) == null) {
                    System.out.println("Desynchronization detected: Unit missing on client-side");
                    System.out.println(Messages.message(Messages.getLabel(u)) + "(" + u.getId() + "). Position: " + u.getTile().getPosition());
                    try {
                        System.out.println("Possible unit on client-side: " + map.getTile(u.getTile().getPosition()).getFirstUnit().getId());
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    System.out.println();
                    problemDetected = true;
                    continue;
                }
                Unit cUnit = game.getFreeColGameObject(u.getId(), Unit.class);
                if (cUnit.getTile() == null || cUnit.getTile().getId().equals(u.getTile().getId())) continue;
                System.out.println("Deynchronization detected: Unit located on different tiles");
                System.out.println("Server: " + Messages.message(Messages.getLabel(u)) + "(" + u.getId() + "). Position: " + u.getTile().getPosition());
                System.out.println("Client: " + Messages.message(Messages.getLabel(cUnit)) + "(" + cUnit.getId() + "). Position: " + cUnit.getTile().getPosition());
                System.out.println();
                problemDetected = true;
            }
        }
        gui.showInformationMessage(problemDetected ? "menuBar.debug.compareMaps.problem" : "menuBar.debug.compareMaps.checkComplete");
    }

    public static void displayColonyPlan(FreeColClient freeColClient, Colony colony) {
        FreeColServer server = freeColClient.getFreeColServer();
        AIMain aiMain = server.getAIMain();
        AIColony aiColony = aiMain.getAIColony(colony);
        StringBuilder sb = new StringBuilder();
        if (aiColony == null) {
            sb.append(colony.getName() + "is not an AI colony.");
        } else {
            sb.append(aiColony.getColonyPlan().toString());
            sb.append("\n\nTILE IMPROVEMENTS:\n");
            for (TileImprovementPlan tip : aiColony.getTileImprovementPlans()) {
                sb.append(tip.toString());
                sb.append("\n");
            }
            sb.append("\n\nWISHES:\n");
            for (Wish w : aiColony.getWishes()) {
                sb.append(w.toString());
                sb.append("\n");
            }
            sb.append("\n\nEXPORT GOODS:\n");
            for (AIGoods aig : aiColony.getAIGoods()) {
                sb.append(aig.toString());
                sb.append("\n");
            }
        }
        freeColClient.getGUI().showInformationMessage(sb.toString());
    }

    public static void displayEurope(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        AIMain aiMain = server.getAIMain();
        StringBuilder sb = new StringBuilder();
        for (Player tp : sGame.getPlayers()) {
            Player p = sGame.getFreeColGameObject(tp.getId(), Player.class);
            if (p.getEurope() == null) continue;
            ArrayList<Unit> inEurope = new ArrayList<Unit>();
            ArrayList<Unit> toEurope = new ArrayList<Unit>();
            ArrayList<Unit> toAmerica = new ArrayList<Unit>();
            HashMap<String, ArrayList<Unit>> units = new HashMap<String, ArrayList<Unit>>();
            units.put("To Europe", toEurope);
            units.put("In Europe", inEurope);
            units.put("To America", toAmerica);
            sb.append("\n==");
            sb.append(Messages.message(p.getNationName()));
            sb.append("==\n");
            for (Unit u : p.getEurope().getUnitList()) {
                if (u.getDestination() instanceof Map) {
                    toAmerica.add(u);
                    continue;
                }
                if (u.getDestination() instanceof Europe) {
                    toEurope.add(u);
                    continue;
                }
                inEurope.add(u);
            }
            for (String label : units.keySet()) {
                List list = (List)units.get(label);
                if (list.size() <= 0) continue;
                sb.append("\n->" + label + "\n");
                for (Unit u : list) {
                    sb.append('\n');
                    sb.append(Messages.message(Messages.getLabel(u)));
                    if (u.isUnderRepair()) {
                        sb.append(" (Repairing)");
                        continue;
                    }
                    sb.append("    ");
                    AIUnit aiu = aiMain.getAIUnit(u);
                    if (aiu.getMission() == null) {
                        sb.append(" (None)");
                        continue;
                    }
                    sb.append(aiu.getMission().toString().replaceAll("\n", "    \n"));
                }
                sb.append('\n');
            }
        }
        freeColClient.getGUI().showInformationMessage(sb.toString());
    }

    public static void displayMission(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        AIMain aiMain = server.getAIMain();
        AIUnit aiUnit = aiMain.getAIUnit(unit);
        String msg = aiUnit.getMission() instanceof TransportMission ? ((TransportMission)aiUnit.getMission()).toFullString() : "Unit has no transport mission.";
        freeColClient.getGUI().showInformationMessage(msg);
    }

    public static void displayUnits(FreeColClient freeColClient) {
        Unit u;
        Player player = freeColClient.getMyPlayer();
        List<Unit> all = player.getUnits();
        StringBuilder sb = new StringBuilder("\nActive units:\n");
        Unit first = player.getNextActiveUnit();
        if (first != null) {
            sb.append(first.toString() + "\nat " + (FreeColGameObject)((Object)first.getLocation()) + "\n");
            all.remove(first);
            while (player.hasNextActiveUnit() && (u = player.getNextActiveUnit()) != first) {
                sb.append(u.toString() + "\nat " + (FreeColGameObject)((Object)u.getLocation()) + "\n");
                all.remove(u);
            }
        }
        sb.append("Going-to units:\n");
        first = player.getNextGoingToUnit();
        if (first != null) {
            all.remove(first);
            sb.append(first.toString() + "\nat " + (FreeColGameObject)((Object)first.getLocation()) + "\n");
            while (player.hasNextGoingToUnit() && (u = player.getNextGoingToUnit()) != first) {
                sb.append(u.toString() + "\nat " + (FreeColGameObject)((Object)u.getLocation()) + "\n");
                all.remove(u);
            }
        }
        sb.append("Remaining units:\n");
        while (!all.isEmpty()) {
            u = all.remove(0);
            sb.append(u.toString() + "\nat " + (FreeColGameObject)((Object)u.getLocation()) + "\n");
        }
        freeColClient.getGUI().showInformationMessage(sb.toString());
    }

    public static void dumpTile(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        System.err.println("\nClient side:");
        tile.dumpObject();
        System.err.println("\n\nServer side:");
        sGame.getFreeColGameObject(tile.getId()).dumpObject();
        System.err.println("\n");
    }

    public static void resetMoves(FreeColClient freeColClient, List<Unit> units) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        GUI gui = freeColClient.getGUI();
        boolean first = true;
        for (Unit u : units) {
            Unit su = sGame.getFreeColGameObject(u.getId(), Unit.class);
            u.setMovesLeft(u.getInitialMovesLeft());
            su.setMovesLeft(su.getInitialMovesLeft());
            if (!first) continue;
            gui.setActiveUnit(u);
            first = false;
        }
        gui.refresh();
    }

    public static void revealMap(FreeColClient freeColClient, boolean reveal) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        server.exploreMapForAllPlayers(reveal);
        game.getSpecification().getBooleanOption("model.option.fogOfWar").setValue(reveal);
    }

    public static void setColonyGoods(FreeColClient freeColClient, Colony colony) {
        int a;
        Specification spec = colony.getSpecification();
        ArrayList gtl = new ArrayList();
        for (GoodsType t : spec.getGoodsTypeList()) {
            if (t.isFoodType() && t != spec.getPrimaryFoodType()) continue;
            String msg = Messages.message(t.toString() + ".name");
            gtl.add(new ChoiceItem<GoodsType>(msg, t));
        }
        GoodsType goodsType = (GoodsType)freeColClient.getGUI().showChoiceDialog(null, "Select Goods Type", "Cancel", gtl);
        if (goodsType == null) {
            return;
        }
        String amount = freeColClient.getGUI().showInputDialog(null, StringTemplate.name("Select Goods Amount"), Integer.toString(colony.getGoodsCount(goodsType)), "ok", "cancel", true);
        if (amount == null) {
            return;
        }
        try {
            a = Integer.parseInt(amount);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = server.getSpecification();
        GoodsType sGoodsType = sSpec.getGoodsType(goodsType.getId());
        GoodsContainer cgc = colony.getGoodsContainer();
        GoodsContainer sgc = sGame.getFreeColGameObject(cgc.getId(), GoodsContainer.class);
        cgc.setAmount(goodsType, a);
        sgc.setAmount(sGoodsType, a);
    }

    public static void setMonarchAction(FreeColClient freeColClient, String monarchTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Player player = freeColClient.getMyPlayer();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        GUI gui = freeColClient.getGUI();
        ArrayList<ChoiceItem<Monarch.MonarchAction>> actions = new ArrayList<ChoiceItem<Monarch.MonarchAction>>();
        for (Monarch.MonarchAction action : Monarch.MonarchAction.values()) {
            actions.add(new ChoiceItem<Monarch.MonarchAction>(action));
        }
        Monarch.MonarchAction action = gui.showChoiceMonarchActionDialog(monarchTitle, actions);
        server.getInGameController().setMonarchAction(sPlayer, action);
    }

    public static void setRumourType(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        ArrayList rumours = new ArrayList();
        for (LostCityRumour.RumourType rumour : LostCityRumour.RumourType.values()) {
            if (rumour == LostCityRumour.RumourType.NO_SUCH_RUMOUR) continue;
            rumours.add(new ChoiceItem<LostCityRumour.RumourType>(rumour.toString(), rumour));
        }
        LostCityRumour.RumourType rumourChoice = (LostCityRumour.RumourType)((Object)freeColClient.getGUI().showChoiceDialog(null, "Select Lost City Rumour", "Cancel", rumours));
        tile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
        sTile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
    }

    public static void skipTurns(FreeColClient freeColClient) {
        int skip;
        FreeColServer server = freeColClient.getFreeColServer();
        if (server.getInGameController().getSkippedTurns() > 0) {
            server.getInGameController().setSkippedTurns(0);
            return;
        }
        String response = freeColClient.getGUI().showInputDialog(null, StringTemplate.key("menuBar.debug.skipTurns"), Integer.toString(10), "ok", "cancel", true);
        if (response == null) {
            return;
        }
        try {
            skip = Integer.parseInt(response);
        }
        catch (NumberFormatException nfe) {
            skip = -1;
        }
        if (skip > 0) {
            freeColClient.skipTurns(skip);
        }
    }

    public static void stepRNG(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        boolean more = true;
        while (more) {
            int val = server.getInGameController().stepRandom();
            more = gui.showConfirmDialog(null, StringTemplate.template("menuBar.debug.randomValue").addAmount("%value%", val), "more", "ok");
        }
    }

    public static void summarizeSettlement(FreeColClient freeColClient, IndianSettlement is) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        AIMain aiMain = server.getAIMain();
        Specification sSpec = sGame.getSpecification();
        IndianSettlement sis = sGame.getFreeColGameObject(is.getId(), IndianSettlement.class);
        StringBuilder sb = new StringBuilder(sis.getName());
        sb.append("\n\nAlarm\n");
        Player mostHated = sis.getMostHated();
        for (Player p : sGame.getLiveEuropeanPlayers()) {
            Tension tension = sis.getAlarm(p);
            sb.append(Messages.message(p.getNationName()) + " " + (tension == null ? "(none)" : Integer.toString(tension.getValue())) + (mostHated == p ? " (most hated)" : "") + " " + Messages.message(sis.getShortAlarmLevelMessageId(p)) + " " + (Object)((Object)sis.getContactLevel(p)) + "\n");
        }
        sb.append("\nGoods Present\n");
        for (Goods goods : sis.getCompactGoods()) {
            sb.append(Messages.message(goods.getLabel(true)) + "\n");
        }
        sb.append("\nGoods Production\n");
        for (GoodsType type : sSpec.getGoodsTypeList()) {
            int prod = sis.getTotalProductionOf(type);
            if (prod <= 0) continue;
            sb.append(Messages.message(type.getNameKey()) + " " + prod + "\n");
        }
        sb.append("\nPrices (buy 1/100 / sell 1/100)\n");
        GoodsType[] wanted = sis.getWantedGoods();
        for (GoodsType type : sSpec.getGoodsTypeList()) {
            int i;
            if (!type.isStorable()) continue;
            for (i = wanted.length - 1; i >= 0 && type != wanted[i]; --i) {
            }
            sb.append(Messages.message(type.getNameKey()) + ": " + sis.getPriceToBuy(type, 1) + "/" + sis.getPriceToBuy(type, 100) + " / " + sis.getPriceToSell(type, 1) + "/" + sis.getPriceToSell(type, 100) + (i < 0 ? "" : " wanted[" + Integer.toString(i) + "]") + "\n");
        }
        sb.append("\nUnits present\n");
        for (Unit u : sis.getUnitList()) {
            Mission m = aiMain.getAIUnit(u).getMission();
            sb.append(u + " at " + (FreeColGameObject)((Object)u.getLocation()));
            if (m != null) {
                sb.append(" " + Utils.lastPart(m.getClass().getName(), "."));
            }
            sb.append("\n");
        }
        sb.append("\nUnits owned\n");
        for (Unit u : sis.getOwnedUnits()) {
            Mission m = aiMain.getAIUnit(u).getMission();
            sb.append(u + " at " + (FreeColGameObject)((Object)u.getLocation()));
            if (m != null) {
                sb.append(" " + Utils.lastPart(m.getClass().getName(), "."));
            }
            sb.append("\n");
        }
        sb.append("\nTiles\n");
        for (Tile t : sis.getOwnedTiles()) {
            sb.append(t + "\n");
        }
        sb.append("\nConvert Progress = " + sis.getConvertProgress());
        sb.append("\nLast Tribute = " + sis.getLastTribute());
        freeColClient.getGUI().showInformationMessage(sb.toString());
    }

    public static void takeOwnership(FreeColClient freeColClient, Settlement settlement) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Settlement sSettlement = (Settlement)sGame.getFreeColGameObject(settlement.getId());
        Player player = freeColClient.getMyPlayer();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        sSettlement.changeOwner(sPlayer);
        freeColClient.getConnectController().reconnect();
    }

    public static void takeOwnership(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Unit sUnit = sGame.getFreeColGameObject(unit.getId(), Unit.class);
        Player player = freeColClient.getMyPlayer();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        sUnit.setOwner(sPlayer);
        for (Unit u : sUnit.getUnitList()) {
            u.setOwner(sPlayer);
        }
        freeColClient.getConnectController().reconnect();
    }

    public static void useAI(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Player player = freeColClient.getMyPlayer();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        AIMain aiMain = server.getAIMain();
        AIPlayer ap = aiMain.getAIPlayer(player);
        ap.setDebuggingConnection(freeColClient.getClient().getConnection());
        ap.startWorking();
        freeColClient.getConnectController().reconnect();
    }
}

