/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;

public final class TilePanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(TilePanel.class.getName());
    private static final String COLOPEDIA = "COLOPEDIA";
    private TileType tileType;

    public TilePanel(FreeColClient freeColClient, GUI gui, Tile tile) {
        super(freeColClient, gui);
        StringTemplate ownerName;
        this.tileType = tile.getType();
        this.setLayout((LayoutManager)new MigLayout("wrap 1, insets 20 30 10 30", "[center]", ""));
        JButton colopediaButton = new JButton(Messages.message("menuBar.colopedia"));
        colopediaButton.setActionCommand(String.valueOf(COLOPEDIA));
        colopediaButton.addActionListener(this);
        TilePanel.enterPressesWhenFocused(colopediaButton);
        ComponentInputMap inputMap = new ComponentInputMap(this.okButton);
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, inputMap);
        String name = Messages.message(tile.getLabel()) + " (" + tile.getX() + ", " + tile.getY() + ")";
        this.add(new JLabel(name));
        ImageLibrary lib = this.getLibrary();
        Image terrain = lib.getTerrainImage(this.tileType, tile.getX(), tile.getY());
        int width = terrain.getWidth(null);
        int baseHeight = terrain.getHeight(null);
        int height = lib.getCompoundTerrainImageHeight(this.tileType);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.translate(0, height - baseHeight);
        gui.displayColonyTile(g, tile, null);
        this.add(new JLabel(new ImageIcon(image)));
        if (tile.getRegion() != null) {
            this.add(this.localizedLabel(tile.getRegion().getLabel()));
        }
        if (tile.getOwner() != null && (ownerName = tile.getOwner().getNationName()) != null) {
            this.add(this.localizedLabel(ownerName));
        }
        if (this.tileType != null) {
            UnitType colonist = this.getSpecification().getDefaultUnitType();
            JLabel label = null;
            boolean first = true;
            for (GoodsType goodsType : this.getSpecification().getFarmedGoodsTypeList()) {
                int potential = tile.potential(goodsType, colonist);
                UnitType expert = this.getSpecification().getExpertForProducing(goodsType);
                int expertPotential = tile.potential(goodsType, expert);
                if (potential > 0) {
                    label = new JLabel(String.valueOf(potential), this.getLibrary().getGoodsImageIcon(goodsType), 0);
                    if (first) {
                        this.add((Component)label, "split");
                        first = false;
                    } else {
                        this.add(label);
                    }
                }
                if (expertPotential <= potential) continue;
                if (label == null) {
                    label = new JLabel(String.valueOf(expertPotential), this.getLibrary().getGoodsImageIcon(goodsType), 0);
                    label.setToolTipText(Messages.message(expert.getNameKey()));
                    if (first) {
                        this.add((Component)label, "split");
                        first = false;
                        continue;
                    }
                    this.add(new JLabel("/"));
                    this.add(label);
                    continue;
                }
                label.setText(String.valueOf(potential) + "/" + String.valueOf(expertPotential));
                label.setToolTipText(Messages.message(colonist.getNameKey()) + "/" + Messages.message(expert.getNameKey()));
            }
        }
        this.add((Component)this.okButton, "newline 30, split 2, align center, tag ok");
        this.add((Component)colopediaButton, "tag help");
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getGUI().removeFromCanvas(this);
        } else {
            this.getGUI().showColopediaPanel(command);
        }
    }

    public String getUIClassID() {
        return "TilePanelUI";
    }
}

