/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.TypeCountMap;

public final class ReportProductionPanel
extends ReportPanel {
    private static final int NUMBER_OF_GOODS = 4;
    private final JComboBox[] boxes = new JComboBox[4];
    private final JButton selectButton;
    private final JLabel selectLabel;
    private final List<GoodsType> goodsTypes = new ArrayList<GoodsType>();

    public ReportProductionPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, Messages.message("reportProductionAction.name"));
        ArrayList<String> goodsNames = new ArrayList<String>();
        goodsNames.add(Messages.message("nothing"));
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (goodsType.isFarmed()) continue;
            this.goodsTypes.add(goodsType);
            goodsNames.add(Messages.message(goodsType.getNameKey()));
        }
        String[] model = goodsNames.toArray(new String[this.goodsTypes.size() + 1]);
        for (int index = 0; index < 4; ++index) {
            this.boxes[index] = new JComboBox<String>(model);
        }
        this.selectLabel = new JLabel(Messages.message("report.production.selectGoods"));
        this.selectButton = new JButton(Messages.message("report.production.update"));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ReportProductionPanel.this.update();
            }
        });
        this.reportPanel.setLayout((LayoutManager)new MigLayout("gap 0 0", "[fill]", "[fill]"));
        this.update();
    }

    private void update() {
        ArrayList<GoodsType> selectedTypes = new ArrayList<GoodsType>();
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)this.selectLabel, "span, split 6");
        for (int index = 0; index < 4; ++index) {
            this.reportPanel.add(this.boxes[index]);
            int selectedIndex = this.boxes[index].getSelectedIndex();
            if (selectedIndex <= 0) continue;
            selectedTypes.add(this.goodsTypes.get(selectedIndex - 1));
        }
        this.reportPanel.add((Component)this.selectButton, "wrap 20");
        if (!selectedTypes.isEmpty()) {
            TypeCountMap<BuildingType> buildingCount = new TypeCountMap<BuildingType>();
            ArrayList basicBuildingTypes = new ArrayList();
            for (GoodsType goodsType : selectedTypes) {
                ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
                for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
                    BuildingType firstLevel;
                    if (!goodsType.equals(buildingType.getProducedGoodsType()) && buildingType.getModifierSet(goodsType.getId()).isEmpty() || buildingTypes.contains(firstLevel = buildingType.getFirstLevel())) continue;
                    buildingTypes.add(firstLevel);
                }
                basicBuildingTypes.add(buildingTypes);
            }
            JLabel newLabel = new JLabel(Messages.message("Colony"));
            newLabel.setBorder(FreeColPanel.TOPLEFTCELLBORDER);
            this.reportPanel.add((Component)newLabel, "newline 20");
            for (int index = 0; index < selectedTypes.size(); ++index) {
                newLabel = this.localizedLabel(((GoodsType)selectedTypes.get(index)).getNameKey());
                newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
                this.reportPanel.add(newLabel);
                for (BuildingType buildingType : (List)basicBuildingTypes.get(index)) {
                    newLabel = this.localizedLabel(buildingType.getNameKey());
                    newLabel.setBorder(FreeColPanel.TOPCELLBORDER);
                    this.reportPanel.add(newLabel);
                }
            }
            int[] totalProduction = new int[selectedTypes.size()];
            for (Colony colony : this.getSortedColonies()) {
                JButton colonyButton = ReportProductionPanel.getLinkButton(colony.getName(), null, colony.getId());
                colonyButton.setBorder(FreeColPanel.LEFTCELLBORDER);
                colonyButton.addActionListener(this);
                this.reportPanel.add((Component)colonyButton, "newline");
                for (int index = 0; index < selectedTypes.size(); ++index) {
                    GoodsType goodsType = (GoodsType)selectedTypes.get(index);
                    int newValue = colony.getNetProductionOf(goodsType);
                    int n = index;
                    totalProduction[n] = totalProduction[n] + newValue;
                    Goods goods = new Goods(colony.getGame(), colony, goodsType, newValue);
                    GoodsLabel goodsLabel = new GoodsLabel(goods, this.getGUI());
                    goodsLabel.setHorizontalAlignment(10);
                    goodsLabel.setBorder(FreeColPanel.CELLBORDER);
                    this.reportPanel.add(goodsLabel);
                    for (BuildingType buildingType : (List)basicBuildingTypes.get(index)) {
                        Building building = colony.getBuilding(buildingType);
                        if (building == null) {
                            newLabel = new JLabel();
                            newLabel.setBorder(FreeColPanel.CELLBORDER);
                            this.reportPanel.add(newLabel);
                            continue;
                        }
                        buildingCount.incrementCount(building.getType(), 1);
                        BuildingPanel buildingPanel = new BuildingPanel(this.getFreeColClient(), building, this.getGUI());
                        buildingPanel.setBorder(FreeColPanel.CELLBORDER);
                        this.reportPanel.add(buildingPanel);
                    }
                }
            }
        }
        this.revalidate();
        this.repaint();
    }
}

