/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportUnitPanel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportNavalPanel
extends ReportUnitPanel {
    public ReportNavalPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, "reportNavalAction.name", false);
    }

    protected void addREFUnits() {
        this.reportPanel.add((Component)new JLabel(Messages.message(this.player.getNation().getRefNation().getId() + ".name")), "span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<AbstractUnit> refUnits = this.getController().getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit unit : refUnits) {
                if (!unit.getUnitType(this.getSpecification()).hasAbility("model.ability.navalUnit")) continue;
                this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
            }
        }
    }

    protected void addOwnUnits() {
        this.reportPanel.add((Component)this.localizedLabel(StringTemplate.template("report.military.forces").addStringTemplate("%nation%", this.player.getNationName())), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isAvailableTo(this.player) || !unitType.hasAbility("model.ability.navalUnit")) continue;
            AbstractUnit unit = new AbstractUnit(unitType, Unit.Role.DEFAULT, this.getCount("naval", unitType));
            this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
        }
    }

    protected void gatherData() {
        for (Unit unit : this.player.getUnits()) {
            if (!unit.isNaval()) continue;
            this.addUnit(unit, "naval");
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(750, 600);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

