/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuickActionMenu
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(QuickActionMenu.class.getName());
    private final FreeColPanel parentPanel;
    private FreeColClient freeColClient;
    private GUI gui;

    public QuickActionMenu(FreeColClient freeColClient, GUI gui, FreeColPanel freeColPanel) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.parentPanel = freeColPanel;
    }

    public void createUnitMenu(UnitLabel unitLabel) {
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        final Unit tempUnit = unitLabel.getUnit();
        this.setLabel("Unit");
        ImageIcon unitIcon = imageLibrary.getUnitImageIcon(tempUnit, 0.66);
        JMenuItem name = new JMenuItem(Messages.message(tempUnit.getLabel()) + " (" + Messages.message("menuBar.colopedia") + ")", unitIcon);
        name.setActionCommand(UnitLabel.UnitAction.COLOPEDIA.toString());
        name.addActionListener(unitLabel);
        this.add(name);
        this.addSeparator();
        if (tempUnit.isCarrier() && this.addCarrierItems(unitLabel)) {
            this.addSeparator();
        }
        if (tempUnit.getLocation().getTile() != null && tempUnit.getLocation().getTile().getColony() != null) {
            if (this.addWorkItems(unitLabel)) {
                this.addSeparator();
            }
            if (this.addEducationItems(unitLabel)) {
                this.addSeparator();
            }
            if (tempUnit.getLocation() instanceof WorkLocation) {
                if (tempUnit.getColony().canReducePopulation()) {
                    JMenuItem menuItem = new JMenuItem(Messages.message("leaveTown"));
                    menuItem.setActionCommand(UnitLabel.UnitAction.LEAVE_TOWN.toString());
                    menuItem.addActionListener(unitLabel);
                    this.add(menuItem);
                }
                if (!tempUnit.isCarrier() && tempUnit.getColony() != null) {
                    for (Unit unit : tempUnit.getColony().getTile().getUnitList()) {
                        if (!unit.isCarrier() || !unit.canCarryUnits() || !unit.canAdd(tempUnit) || unit.getUnitList().contains(tempUnit)) continue;
                        final Unit funit = unit;
                        JMenuItem menuItem = new JMenuItem(Messages.message("Board " + Messages.message(unit.getLabel())));
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                if (QuickActionMenu.this.freeColClient.getInGameController().putOutsideColony(tempUnit)) {
                                    QuickActionMenu.this.freeColClient.getInGameController().boardShip(tempUnit, funit);
                                }
                            }
                        });
                        this.add(menuItem);
                    }
                }
            } else if (this.addCommandItems(unitLabel)) {
                this.addSeparator();
            }
        } else if (tempUnit.getLocation() instanceof Europe && this.addCommandItems(unitLabel)) {
            this.addSeparator();
        }
        if (tempUnit.hasAbility("model.ability.canBeEquipped") && this.addEquipmentItems(unitLabel)) {
            this.addSeparator();
        }
    }

    private boolean addCarrierItems(UnitLabel unitLabel) {
        Unit tempUnit = unitLabel.getUnit();
        if (tempUnit.hasCargo()) {
            JMenuItem menuItem;
            JMenuItem cargo = new JMenuItem(Messages.message("cargoOnCarrier"));
            this.add(cargo);
            for (Unit passenger : tempUnit.getUnitList()) {
                menuItem = new JMenuItem("    " + Messages.message(passenger.getLabel()));
                menuItem.setFont(menuItem.getFont().deriveFont(2));
                this.add(menuItem);
            }
            for (Goods goods : tempUnit.getGoodsList()) {
                menuItem = new JMenuItem("    " + Messages.message(goods.getLabel(true)));
                menuItem.setFont(menuItem.getFont().deriveFont(2));
                this.add(menuItem);
            }
            return true;
        }
        return false;
    }

    private List<JMenuItem> descendingList(final Map<JMenuItem, Integer> map) {
        ArrayList<JMenuItem> ret = new ArrayList<JMenuItem>(map.keySet());
        Collections.sort(ret, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem m1, JMenuItem m2) {
                Integer i1 = (Integer)map.get(m1);
                Integer i2 = (Integer)map.get(m2);
                int cmp = i2.compareTo(i1);
                if (cmp == 0) {
                    cmp = m1.getText().compareTo(m2.getText());
                }
                return cmp;
            }
        });
        return ret;
    }

    private JMenuItem makeProductionItem(GoodsType type, WorkLocation wl, int amount, UnitLabel unitLabel, boolean claim) {
        StringTemplate t = StringTemplate.template(type.getId() + ".workAs").addAmount("%amount%", amount);
        if (claim) {
            t.addStringTemplate("%claim%", wl.getClaimTemplate());
        } else {
            t.addName("%claim%", "");
        }
        JMenuItem menuItem = new JMenuItem(Messages.message(t), this.parentPanel.getLibrary().getScaledGoodsImageIcon(type, 0.66f));
        menuItem.setActionCommand(UnitLabel.getWorkLabel(wl) + "/" + wl.getId() + "/" + type.getId() + "/" + (claim ? "!" : ""));
        menuItem.addActionListener(unitLabel);
        return menuItem;
    }

    private boolean addWorkItems(UnitLabel unitLabel) {
        final Unit unit = unitLabel.getUnit();
        UnitType unitType = unit.getType();
        GoodsType expertGoods = unitType.getExpertProduction();
        Colony colony = unit.getLocation().getColony();
        Specification spec = this.freeColClient.getGame().getSpecification();
        WorkLocation current = unit.getLocation() instanceof WorkLocation ? (WorkLocation)unit.getLocation() : null;
        int bonusChange = current != null ? 0 : colony.governmentChange(colony.getWorkLocationUnitCount() + 1);
        HashMap<JMenuItem, Integer> items = new HashMap<JMenuItem, Integer>();
        HashMap<JMenuItem, Integer> extras = new HashMap<JMenuItem, Integer>();
        JMenuItem expertOwned = null;
        JMenuItem expertUnowned = null;
        for (GoodsType type : spec.getGoodsTypeList()) {
            JMenuItem ji;
            int bestOwnedProd = 0;
            int bestUnownedProd = 0;
            WorkLocation bestOwned = null;
            WorkLocation bestUnowned = null;
            for (WorkLocation wl : colony.getAllWorkLocations()) {
                int prod = bonusChange;
                switch (wl.getNoAddReason(unit)) {
                    case NONE: {
                        if ((prod += wl.getPotentialProduction(type, unitType)) <= bestOwnedProd) break;
                        bestOwnedProd = prod;
                        bestOwned = wl;
                        break;
                    }
                    case ALREADY_PRESENT: {
                        if ((prod += wl.getPotentialProduction(type, unitType)) <= bestOwnedProd) break;
                        bestOwnedProd = prod;
                        bestOwned = unit.getWorkType() == type ? null : wl;
                        break;
                    }
                    case CLAIM_REQUIRED: {
                        if ((prod += wl.getPotentialProduction(type, unitType)) <= bestUnownedProd) break;
                        bestUnownedProd = prod;
                        bestUnowned = wl;
                        break;
                    }
                }
            }
            if (bestOwned != null) {
                ji = this.makeProductionItem(type, bestOwned, bestOwnedProd, unitLabel, false);
                if (type == expertGoods) {
                    expertOwned = ji;
                } else {
                    items.put(ji, new Integer(bestOwnedProd));
                }
            }
            if (bestUnowned == null || bestUnownedProd <= bestOwnedProd) continue;
            ji = this.makeProductionItem(type, bestUnowned, bestUnownedProd, unitLabel, true);
            if (type == expertGoods) {
                expertUnowned = ji;
                continue;
            }
            extras.put(ji, new Integer(bestUnownedProd));
        }
        JMenu container = new JMenu(Messages.message("model.unit.changeWork"));
        this.add(container);
        List<JMenuItem> owned = this.descendingList(items);
        if (expertOwned != null) {
            owned.add(0, expertOwned);
        }
        for (JMenuItem j : owned) {
            container.add(j);
        }
        List<JMenuItem> unowned = this.descendingList(extras);
        if (expertUnowned != null) {
            unowned.add(0, expertUnowned);
        }
        if (!unowned.isEmpty()) {
            if (!owned.isEmpty()) {
                container.addSeparator();
            }
            for (JMenuItem j : unowned) {
                container.add(j);
            }
        }
        if (current != null) {
            JMenuItem ji = new JMenuItem(Messages.message("showProductivity"));
            ji.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    QuickActionMenu.this.gui.showWorkProductionPanel(unit);
                }
            });
            this.add(ji);
        }
        return !owned.isEmpty() || !unowned.isEmpty() || current != null;
    }

    private boolean addEducationItems(UnitLabel unitLabel) {
        JMenuItem menuItem;
        boolean separatorNeeded = false;
        Unit unit = unitLabel.getUnit();
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        if (unit.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            for (Unit teacher : unit.getColony().getTeachers()) {
                if (!unit.canBeStudent(teacher) || !(unit.getLocation() instanceof WorkLocation)) continue;
                menuItem = null;
                ImageIcon teacherIcon = imageLibrary.getUnitImageIcon(teacher, 0.5);
                if (teacher.getStudent() != unit) {
                    String assign = Messages.message("assignToTeacher");
                    if (teacher.getStudent() != null) {
                        assign = assign + " (" + teacher.getTurnsOfTraining() + "/" + teacher.getNeededTurnsOfTraining() + ")";
                    }
                    menuItem = new JMenuItem(assign, teacherIcon);
                    menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN.toString() + "/" + teacher.getId());
                    menuItem.addActionListener(unitLabel);
                } else {
                    String teacherName = Messages.message(teacher.getType().getNameKey());
                    menuItem = new JMenuItem(Messages.message(StringTemplate.template("menu.unit.apprentice").addName("%unit%", teacherName)) + ": " + teacher.getTurnsOfTraining() + "/" + teacher.getNeededTurnsOfTraining(), teacherIcon);
                    menuItem.setEnabled(false);
                }
                this.add(menuItem);
                separatorNeeded = true;
            }
        }
        if (unit.getStudent() != null) {
            Unit student = unit.getStudent();
            String studentName = Messages.message(student.getType().getNameKey());
            menuItem = new JMenuItem(Messages.message(StringTemplate.template("menuBar.teacher").addName("%unit%", studentName)) + ": " + unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
            menuItem.setEnabled(false);
            this.add(menuItem);
            separatorNeeded = true;
        }
        int experience = unit.getExperience();
        GoodsType goods = unit.getExperienceType();
        if (experience > 0 && goods != null) {
            UnitType expertType = this.freeColClient.getGame().getSpecification().getExpertForProducing(goods);
            if (unit.getType().canBeUpgraded(expertType, UnitTypeChange.ChangeType.EXPERIENCE)) {
                int maxExperience = unit.getType().getMaximumExperience();
                double probability = (double)(unit.getType().getUnitTypeChange(expertType).getProbability(UnitTypeChange.ChangeType.EXPERIENCE) * experience) / (double)maxExperience;
                String jobName = Messages.message(goods.getWorkingAsKey());
                ImageIcon expertIcon = imageLibrary.getUnitImageIcon(expertType, 0.5);
                JMenuItem experienceItem = new JMenuItem(Messages.message(StringTemplate.template("menu.unit.experience").addName("%job%", jobName)) + " " + experience + "/" + maxExperience + " (" + FreeColPanel.getModifierFormat().format(probability) + "%)", expertIcon);
                experienceItem.setEnabled(false);
                this.add(experienceItem);
                separatorNeeded = true;
            }
        }
        return separatorNeeded;
    }

    private boolean addCommandItems(UnitLabel unitLabel) {
        final Unit tempUnit = unitLabel.getUnit();
        boolean isUnitAtSea = tempUnit.isAtSea();
        JMenuItem menuItem = new JMenuItem(Messages.message("activateUnit"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (tempUnit.getState() != Unit.UnitState.ACTIVE) {
                    QuickActionMenu.this.freeColClient.getInGameController().changeState(tempUnit, Unit.UnitState.ACTIVE);
                }
                QuickActionMenu.this.gui.setActiveUnit(tempUnit);
            }
        });
        menuItem.setEnabled(!isUnitAtSea);
        this.add(menuItem);
        if (!(tempUnit.getLocation() instanceof Europe)) {
            menuItem = new JMenuItem(Messages.message("fortifyUnit"));
            menuItem.setActionCommand(UnitLabel.UnitAction.FORTIFY.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(tempUnit.getMovesLeft() > 0 && tempUnit.getState() != Unit.UnitState.FORTIFIED && tempUnit.getState() != Unit.UnitState.FORTIFYING);
            this.add(menuItem);
        }
        Unit.UnitState unitState = tempUnit.getState();
        menuItem = new JMenuItem(Messages.message("sentryUnit"));
        menuItem.setActionCommand(UnitLabel.UnitAction.SENTRY.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(unitState != Unit.UnitState.SENTRY && !isUnitAtSea);
        this.add(menuItem);
        boolean hasTradeRoute = tempUnit.getTradeRoute() != null;
        menuItem = new JMenuItem(Messages.message("clearUnitOrders"));
        menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_ORDERS.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled((unitState != Unit.UnitState.ACTIVE || hasTradeRoute) && !isUnitAtSea);
        this.add(menuItem);
        menuItem = new JMenuItem(Messages.message("assignTradeRoute"));
        menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN_TRADE_ROUTE.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(tempUnit.isCarrier() && !hasTradeRoute);
        this.add(menuItem);
        if (tempUnit.canCarryTreasure() && tempUnit.canCashInTreasureTrain()) {
            menuItem = new JMenuItem(Messages.message("cashInTreasureTrain.order"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    QuickActionMenu.this.freeColClient.getInGameController().checkCashInTreasureTrain(tempUnit);
                }
            });
            this.add(menuItem);
        }
        if (tempUnit.getColony() != null && !tempUnit.isCarrier()) {
            for (Unit unit : tempUnit.getColony().getTile().getUnitList()) {
                if (!unit.isCarrier() || !unit.canCarryUnits()) continue;
                if (tempUnit.isOnCarrier()) {
                    menuItem = new JMenuItem(Messages.message("leaveTown"));
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            QuickActionMenu.this.freeColClient.getInGameController().putOutsideColony(tempUnit);
                        }
                    });
                }
                this.add(menuItem);
            }
        }
        return true;
    }

    private boolean addEquipmentItems(final UnitLabel unitLabel) {
        UnitType newUnitType;
        final Unit tempUnit = unitLabel.getUnit();
        final InGameController igc = this.freeColClient.getInGameController();
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        boolean separatorNeeded = false;
        if (tempUnit.getEquipment().size() > 1) {
            JMenuItem newItem = new JMenuItem(Messages.message("model.equipment.removeAll"));
            newItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HashMap<EquipmentType, Integer> equipment = new HashMap<EquipmentType, Integer>(tempUnit.getEquipment().getValues());
                    for (Map.Entry entry : equipment.entrySet()) {
                        igc.equipUnit(tempUnit, (EquipmentType)entry.getKey(), -((Integer)entry.getValue()).intValue());
                    }
                    unitLabel.updateIcon();
                }
            });
            this.add(newItem);
        }
        EquipmentType horses = null;
        EquipmentType muskets = null;
        for (EquipmentType equipmentType : this.freeColClient.getGame().getSpecification().getEquipmentTypeList()) {
            EquipmentType type;
            JMenuItem newItem;
            int count = tempUnit.getEquipment().getCount(equipmentType);
            if (count > 0) {
                newItem = new JMenuItem(Messages.message(equipmentType.getId() + ".remove"));
                if (equipmentType.needsGoodsToBuild()) {
                    GoodsType goodsType = equipmentType.getRequiredGoods().get(0).getType();
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsType, 0.66f));
                }
                final int items = count;
                type = equipmentType;
                newItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        igc.equipUnit(tempUnit, type, -items);
                        unitLabel.updateIcon();
                    }
                });
                this.add(newItem);
            }
            if (!tempUnit.canBeEquippedWith(equipmentType) || count != 0) continue;
            newItem = null;
            count = equipmentType.getMaximumCount() - count;
            if (!equipmentType.needsGoodsToBuild()) {
                newItem = new JMenuItem();
                newItem.setText(Messages.message(equipmentType.getId() + ".add"));
            } else if (tempUnit.isInEurope() && tempUnit.getOwner().getEurope().canBuildEquipment(equipmentType)) {
                int price = 0;
                newItem = new JMenuItem();
                for (AbstractGoods ag : equipmentType.getRequiredGoods()) {
                    price += tempUnit.getOwner().getMarket().getBidPrice(ag.getType(), ag.getAmount());
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(ag.getType(), 0.66f));
                }
                while (!tempUnit.getOwner().checkGold(count * price)) {
                    --count;
                }
                newItem.setText(Messages.message(equipmentType.getId() + ".add") + " (" + Messages.message(StringTemplate.template("goldAmount").addAmount("%amount%", count * price)) + ")");
            } else if (tempUnit.getColony() != null && tempUnit.getColony().canBuildEquipment(equipmentType)) {
                newItem = new JMenuItem();
                for (AbstractGoods ag : equipmentType.getRequiredGoods()) {
                    int present = tempUnit.getColony().getGoodsCount(ag.getType()) / ag.getAmount();
                    if (present < count) {
                        count = present;
                    }
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(ag.getType(), 0.66f));
                }
                newItem.setText(Messages.message(equipmentType.getId() + ".add"));
            }
            if (newItem == null) continue;
            if ("model.equipment.horses".equals(equipmentType.getId())) {
                horses = equipmentType;
            } else if ("model.equipment.muskets".equals(equipmentType.getId())) {
                muskets = equipmentType;
            }
            final int items = count;
            type = equipmentType;
            newItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    igc.equipUnit(tempUnit, type, items);
                    unitLabel.updateIcon();
                }
            });
            this.add(newItem);
        }
        if (horses != null && muskets != null && horses.isCompatibleWith(muskets)) {
            final EquipmentType horseType = horses;
            final EquipmentType musketType = muskets;
            JMenuItem newItem = new JMenuItem(Messages.message("model.equipment.dragoon"), imageLibrary.getUnitImageIcon(tempUnit.getType(), Unit.Role.DRAGOON, 0.3333333333333333));
            newItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    igc.equipUnit(tempUnit, horseType, 1);
                    igc.equipUnit(tempUnit, musketType, 1);
                    unitLabel.updateIcon();
                }
            });
            this.add(newItem);
        }
        if (separatorNeeded = true) {
            this.addSeparator();
            separatorNeeded = false;
        }
        if ((newUnitType = tempUnit.getType().getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, tempUnit.getOwner())) != null) {
            JMenuItem menuItem = new JMenuItem(Messages.message("clearSpeciality"), imageLibrary.getUnitImageIcon(newUnitType, 0.3333333333333333));
            menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_SPECIALITY.toString());
            menuItem.addActionListener(unitLabel);
            this.add(menuItem);
            if (tempUnit.getLocation() instanceof Building && !((Building)tempUnit.getLocation()).canAddType(newUnitType)) {
                menuItem.setEnabled(false);
            }
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    public void createGoodsMenu(GoodsLabel goodsLabel) {
        final Goods goods = goodsLabel.getGoods();
        final InGameController inGameController = this.freeColClient.getInGameController();
        ImageLibrary imageLibrary = this.parentPanel.getLibrary();
        this.setLabel("Cargo");
        JMenuItem name = new JMenuItem(Messages.message(goods.getNameKey()) + " (" + Messages.message("menuBar.colopedia") + ")", imageLibrary.getScaledGoodsImageIcon(goods.getType(), 0.66f));
        name.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickActionMenu.this.gui.showColopediaPanel(goods.getType().getId());
            }
        });
        this.add(name);
        if (!(goods.getLocation() instanceof Colony)) {
            if (this.freeColClient.getMyPlayer().canTrade(goods)) {
                JMenuItem unload = new JMenuItem(Messages.message("unload"));
                unload.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        inGameController.unloadCargo(goods, false);
                        if (QuickActionMenu.this.parentPanel instanceof CargoPanel) {
                            CargoPanel cargoPanel = (CargoPanel)QuickActionMenu.this.parentPanel;
                            cargoPanel.initialize();
                        }
                        QuickActionMenu.this.parentPanel.revalidate();
                    }
                });
                this.add(unload);
            } else if (goods.getLocation() instanceof Unit && ((Unit)goods.getLocation()).isInEurope()) {
                JMenuItem pay = new JMenuItem(Messages.message("boycottedGoods.payArrears"));
                pay.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        inGameController.payArrears(goods.getType());
                        if (QuickActionMenu.this.parentPanel instanceof CargoPanel) {
                            CargoPanel cargoPanel = (CargoPanel)QuickActionMenu.this.parentPanel;
                            cargoPanel.initialize();
                        }
                        QuickActionMenu.this.parentPanel.revalidate();
                    }
                });
                this.add(pay);
            }
            JMenuItem dump = new JMenuItem(Messages.message("dumpCargo"));
            dump.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    inGameController.unloadCargo(goods, true);
                    if (QuickActionMenu.this.parentPanel instanceof CargoPanel) {
                        ((CargoPanel)QuickActionMenu.this.parentPanel).initialize();
                    }
                    QuickActionMenu.this.parentPanel.revalidate();
                }
            });
            this.add(dump);
        }
    }
}

