/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NegotiationDialog
extends FreeColDialog<DiplomaticTrade>
implements ActionListener {
    private static Logger logger = Logger.getLogger(NegotiationDialog.class.getName());
    private static final String ACCEPT = "accept";
    private static final String CANCEL = "cancel";
    private static final String SEND = "send";
    private static final int HUGE_DEMAND = 100000;
    private DiplomaticTrade agreement;
    private JButton acceptButton;
    private JButton cancelButton;
    private JButton sendButton;
    private StanceTradeItemPanel stancePanel;
    private GoldTradeItemPanel goldOfferPanel;
    private GoldTradeItemPanel goldDemandPanel;
    private ColonyTradeItemPanel colonyOfferPanel;
    private ColonyTradeItemPanel colonyDemandPanel;
    private GoodsTradeItemPanel goodsOfferPanel;
    private GoodsTradeItemPanel goodsDemandPanel;
    private JPanel summary;
    private final Unit unit;
    private final Settlement settlement;
    private Player player;
    private Player otherPlayer;
    private Player sender;
    private Player recipient;
    private boolean canAccept;
    private String demandMessage;
    private String offerMessage;
    private String exchangeMessage;

    public NegotiationDialog(FreeColClient freeColClient, GUI gui, Unit unit, Settlement settlement) {
        this(freeColClient, gui, unit, settlement, null);
    }

    public NegotiationDialog(FreeColClient freeColClient, GUI gui, Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        super(freeColClient, gui);
        this.setFocusCycleRoot(true);
        this.unit = unit;
        this.settlement = settlement;
        this.player = this.getMyPlayer();
        this.sender = unit.getOwner();
        this.recipient = settlement.getOwner();
        this.otherPlayer = this.sender == this.player ? this.recipient : this.sender;
        this.canAccept = agreement != null;
        this.agreement = agreement != null ? agreement : new DiplomaticTrade(unit.getGame(), this.sender, this.recipient);
        this.demandMessage = Messages.message(StringTemplate.template("negotiationDialog.demand").addStringTemplate("%nation%", this.sender.getNationName()));
        this.offerMessage = Messages.message(StringTemplate.template("negotiationDialog.offer").addStringTemplate("%nation%", this.sender.getNationName()));
        this.exchangeMessage = Messages.message(StringTemplate.template("negotiationDialog.exchange").addStringTemplate("%nation%", this.sender.getNationName()));
        if (this.player.atWarWith(this.otherPlayer) && this.getStance() == null) {
            this.agreement.add(new StanceTradeItem(this.getGame(), this.player, this.otherPlayer, Player.Stance.PEACE));
        }
        this.summary = new JPanel((LayoutManager)new MigLayout("wrap 2", "[20px][]"));
        this.summary.setOpaque(false);
    }

    @Override
    public void initialize() {
        this.sendButton = new JButton(Messages.message("negotiationDialog.send"));
        this.sendButton.addActionListener(this);
        this.sendButton.setActionCommand(SEND);
        FreeColPanel.enterPressesWhenFocused(this.sendButton);
        this.acceptButton = new JButton(Messages.message("negotiationDialog.accept"));
        this.acceptButton.addActionListener(this);
        this.acceptButton.setActionCommand(ACCEPT);
        FreeColPanel.enterPressesWhenFocused(this.acceptButton);
        this.acceptButton.setEnabled(this.canAccept);
        this.cancelButton = new JButton(Messages.message("negotiationDialog.cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL);
        this.setCancelComponent(this.cancelButton);
        FreeColPanel.enterPressesWhenFocused(this.cancelButton);
        this.stancePanel = new StanceTradeItemPanel(this, this.player, this.otherPlayer);
        this.goldDemandPanel = new GoldTradeItemPanel(this, this.otherPlayer, 100000);
        this.goldOfferPanel = new GoldTradeItemPanel(this, this.player, this.player.getGold() == Integer.MIN_VALUE ? 100000 : this.player.getGold());
        this.colonyDemandPanel = new ColonyTradeItemPanel(this, this.otherPlayer);
        this.colonyOfferPanel = new ColonyTradeItemPanel(this, this.player);
        this.setLayout((LayoutManager)new MigLayout("wrap 3", "[200, fill][300, fill][200, fill]", ""));
        this.add((Component)new JLabel(this.demandMessage), "center");
        this.add((Component)new JLabel(this.offerMessage), "skip, center");
        this.add(this.goldDemandPanel);
        this.add((Component)this.summary, "spany, top");
        this.add(this.goldOfferPanel);
        if (this.unit.isCarrier()) {
            List<Goods> unitGoods = this.unit.getGoodsList();
            this.goodsDemandPanel = new GoodsTradeItemPanel(this, this.otherPlayer, this.getAnyGoods());
            this.add(this.goodsDemandPanel);
            this.goodsOfferPanel = new GoodsTradeItemPanel(this, this.player, this.unit.getOwner() == this.player ? this.unit.getGoodsList() : this.settlement.getCompactGoods());
            this.add(this.goodsOfferPanel);
        } else {
            this.add(this.colonyDemandPanel);
            this.add(this.colonyOfferPanel);
        }
        this.add((Component)this.stancePanel, "skip");
        this.add((Component)this.sendButton, "newline 20, span, split 3");
        this.add((Component)this.acceptButton, "tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.updateDialog();
    }

    private List<Goods> getAnyGoods() {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            if (!type.isStorable()) continue;
            goodsList.add(new Goods(this.getGame(), null, type, 100));
        }
        return goodsList;
    }

    private void updateDialog() {
        this.stancePanel.updateStanceBox();
        this.updateOfferItems();
        this.updateDemandItems();
        this.updateSummary();
    }

    private void updateOfferItems() {
        this.goldOfferPanel.setAvailableGold(this.player.getGold());
        if (this.unit.isCarrier()) {
            ArrayList<Goods> goodsAvail = new ArrayList<Goods>();
            if (this.unit.getOwner() == this.player) {
                goodsAvail.addAll(this.unit.getGoodsList());
            } else {
                goodsAvail.addAll(this.settlement.getCompactGoods());
            }
            for (Goods g : goodsAvail) {
                if (g.getAmount() <= 100) continue;
                g.setAmount(100);
            }
            block1: for (Goods goods : this.agreement.getGoodsGivenBy(this.player)) {
                for (int i = 0; i < goodsAvail.size(); ++i) {
                    Goods g = (Goods)goodsAvail.get(i);
                    if (g.getType() != goods.getType()) continue;
                    if (g.getAmount() <= goods.getAmount()) {
                        goodsAvail.remove(i);
                        continue block1;
                    }
                    g.setAmount(g.getAmount() - goods.getAmount());
                    continue block1;
                }
            }
            this.goodsOfferPanel.updateGoodsBox(goodsAvail);
        } else {
            this.colonyOfferPanel.updateColonyBox();
        }
    }

    private void updateDemandItems() {
        NationSummary ns = this.getController().getNationSummary(this.otherPlayer);
        int foreignGold = ns == null ? 0 : ns.getGold();
        this.goldDemandPanel.setAvailableGold(foreignGold);
        if (this.unit.isCarrier()) {
            this.goodsDemandPanel.updateGoodsBox(this.agreement.getGoodsGivenBy(this.otherPlayer));
        } else {
            this.colonyDemandPanel.updateColonyBox();
        }
    }

    private JButton getTradeItemButton(TradeItem item) {
        TradeItem i;
        String description = null;
        if (item instanceof StanceTradeItem) {
            i = (StanceTradeItem)item;
            description = Messages.message(((StanceTradeItem)i).getStance().getKey());
        } else if (item instanceof GoldTradeItem) {
            int gold = ((GoldTradeItem)item).getGold();
            description = Messages.message(StringTemplate.template("tradeItem.gold.long").addAmount("%amount%", gold));
        } else if (item instanceof ColonyTradeItem) {
            i = (ColonyTradeItem)item;
            description = Messages.message(StringTemplate.template("tradeItem.colony.long").addName("%colony%", ((ColonyTradeItem)i).getColonyName()));
        } else if (item instanceof GoodsTradeItem) {
            i = (GoodsTradeItem)item;
            description = Messages.message(StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", ((GoodsTradeItem)i).getGoods().getAmount()).add("%goods%", ((GoodsTradeItem)i).getGoods().getNameKey()));
        } else if (item instanceof UnitTradeItem) {
            i = (UnitTradeItem)item;
            description = Messages.message(((UnitTradeItem)i).getUnit().getLabel());
        }
        JButton button = new JButton(new RemoveAction(item));
        button.setText(description);
        button.setMargin(emptyMargin);
        button.setOpaque(false);
        button.setForeground(LINK_COLOR);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    private void updateSummary() {
        List<TradeItem> demands;
        this.summary.removeAll();
        List<TradeItem> offers = this.agreement.getItemsGivenBy(this.player);
        if (!offers.isEmpty()) {
            this.summary.add((Component)new JLabel(this.offerMessage), "span");
            for (TradeItem item : offers) {
                this.summary.add((Component)this.getTradeItemButton(item), "skip");
            }
        }
        if (!(demands = this.agreement.getItemsGivenBy(this.otherPlayer)).isEmpty()) {
            if (demands.isEmpty()) {
                this.summary.add((Component)new JLabel(this.demandMessage), "span");
            } else {
                this.summary.add((Component)new JLabel(this.exchangeMessage), "newline 20, span");
            }
            for (TradeItem item : demands) {
                this.summary.add((Component)this.getTradeItemButton(item), "skip");
            }
        }
    }

    public void addColonyTradeItem(Player source, Colony colony) {
        Player destination = source == this.otherPlayer ? this.player : this.otherPlayer;
        this.agreement.add(new ColonyTradeItem(this.getGame(), source, destination, colony));
    }

    public void addGoldTradeItem(Player source, int amount) {
        Player destination = source == this.otherPlayer ? this.player : this.otherPlayer;
        this.agreement.add(new GoldTradeItem(this.getGame(), source, destination, amount));
    }

    public void addGoodsTradeItem(Player source, Goods goods) {
        Player destination = source == this.otherPlayer ? this.player : this.otherPlayer;
        this.agreement.add(new GoodsTradeItem(this.getGame(), source, destination, goods, this.settlement));
    }

    public void setStance(Player.Stance stance) {
        this.agreement.add(new StanceTradeItem(this.getGame(), this.otherPlayer, this.player, stance));
    }

    public Player.Stance getStance() {
        return this.agreement.getStance();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(CANCEL)) {
            this.agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
            this.setResponse(this.agreement);
        } else if (command.equals(ACCEPT)) {
            this.agreement.setStatus(DiplomaticTrade.TradeStatus.ACCEPT_TRADE);
            this.setResponse(this.agreement);
        } else if (command.equals(SEND)) {
            this.agreement.setStatus(DiplomaticTrade.TradeStatus.PROPOSE_TRADE);
            this.setResponse(this.agreement);
        }
    }

    private class StanceTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JComboBox stanceBox;
        private JButton addButton;
        private NegotiationDialog negotiationDialog;
        private Player source;
        private Player target;

        public StanceTradeItemPanel(NegotiationDialog parent, Player source, Player target) {
            this.negotiationDialog = parent;
            this.source = source;
            this.target = target;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.stanceBox = new JComboBox();
            this.updateStanceBox();
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.add(new JLabel(Messages.message("tradeItem.stance")));
            this.add(this.stanceBox);
            this.add(this.addButton);
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                StanceItem stance = (StanceItem)this.stanceBox.getSelectedItem();
                this.negotiationDialog.setStance(stance.getValue());
                NegotiationDialog.this.updateSummary();
            }
        }

        public void updateStanceBox() {
            Player.Stance select;
            this.stanceBox.removeAllItems();
            Player.Stance stance = this.source.getStance(this.target);
            if (stance != Player.Stance.WAR) {
                this.stanceBox.addItem(new StanceItem(Player.Stance.WAR));
            } else {
                this.stanceBox.addItem(new StanceItem(Player.Stance.CEASE_FIRE));
            }
            if (stance != Player.Stance.PEACE && stance != Player.Stance.UNCONTACTED) {
                this.stanceBox.addItem(new StanceItem(Player.Stance.PEACE));
            }
            if (stance != Player.Stance.ALLIANCE) {
                this.stanceBox.addItem(new StanceItem(Player.Stance.ALLIANCE));
            }
            if ((select = this.negotiationDialog.getStance()) != null) {
                this.stanceBox.setSelectedItem(new StanceItem(select));
            }
        }

        private class StanceItem {
            private Player.Stance value;

            public StanceItem(Player.Stance value) {
                this.value = value;
            }

            public String toString() {
                return Messages.message(this.value.getKey());
            }

            public Player.Stance getValue() {
                return this.value;
            }

            public boolean equals(Object other) {
                if (other == null || !(other instanceof StanceItem)) {
                    return false;
                }
                return this.value.equals((Object)((StanceItem)other).value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GoodsTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JComboBox goodsBox;
        private JButton addButton;
        private Player player;
        private NegotiationDialog negotiationDialog;
        private JLabel label;

        public GoodsTradeItemPanel(NegotiationDialog parent, Player source, List<Goods> allGoods) {
            this.player = source;
            this.negotiationDialog = parent;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.label = new JLabel(Messages.message("tradeItem.goods"));
            this.goodsBox = new JComboBox(new DefaultComboBoxModel());
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.add(this.label);
            this.add(this.goodsBox);
            this.add(this.addButton);
            this.setSize(this.getPreferredSize());
            this.updateGoodsBox(allGoods);
        }

        private void updateGoodsBox(List<Goods> allGoods) {
            ActionListener[] listeners;
            for (ActionListener al : listeners = this.goodsBox.getActionListeners()) {
                this.goodsBox.removeActionListener(al);
            }
            this.goodsBox.removeAllItems();
            for (Goods g : allGoods) {
                this.goodsBox.addItem(new GoodsItem(g));
            }
            for (ActionListener al : listeners) {
                this.goodsBox.addActionListener(al);
            }
            boolean enable = !allGoods.isEmpty();
            this.label.setEnabled(enable);
            this.addButton.setEnabled(enable);
            this.goodsBox.setEnabled(enable);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                this.negotiationDialog.addGoodsTradeItem(this.player, ((GoodsItem)this.goodsBox.getSelectedItem()).getValue());
                NegotiationDialog.this.updateDialog();
            }
        }

        private class GoodsItem {
            private Goods value;

            public GoodsItem(Goods value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.value = value;
            }

            public String toString() {
                return Messages.message(this.value.getLabel(true));
            }

            public Goods getValue() {
                return this.value;
            }

            public boolean equals(Object other) {
                return other instanceof GoodsItem ? this.value.equals(((GoodsItem)other).value) : false;
            }

            public int hashCode() {
                return this.value.hashCode();
            }
        }
    }

    private class GoldTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JSpinner spinner;
        private JButton addButton;
        private Player player;
        private NegotiationDialog negotiationDialog;

        public GoldTradeItemPanel(NegotiationDialog parent, Player source, int gold) {
            this.player = source;
            this.negotiationDialog = parent;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, gold, 1));
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(5);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.add(new JLabel(Messages.message("tradeItem.gold")));
            this.add(this.spinner);
            this.add(this.addButton);
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                int amount = (Integer)this.spinner.getValue();
                this.negotiationDialog.addGoldTradeItem(this.player, amount);
                NegotiationDialog.this.updateDialog();
            }
        }

        public void setAvailableGold(int gold) {
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
            model.setMaximum(new Integer(gold));
        }
    }

    private class ColonyTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JComboBox colonyBox;
        private JButton addButton;
        private Player player;
        private NegotiationDialog negotiationDialog;
        private JLabel textLabel;

        public ColonyTradeItemPanel(NegotiationDialog parent, Player source) {
            this.player = source;
            this.negotiationDialog = parent;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.textLabel = new JLabel(Messages.message("tradeItem.colony"));
            this.colonyBox = new JComboBox();
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.add(this.textLabel);
            this.add(this.colonyBox);
            this.add(this.addButton);
            this.updateColonyBox();
        }

        private void updateColonyBox() {
            ActionListener[] listeners;
            if (!this.player.isEuropean()) {
                return;
            }
            for (ActionListener al : listeners = this.colonyBox.getActionListeners()) {
                this.colonyBox.removeActionListener(al);
            }
            this.colonyBox.removeAllItems();
            Iterator<Colony> coloniesInAgreement = NegotiationDialog.this.agreement.getColoniesGivenBy(this.player).iterator();
            List<Colony> coloniesAvail = NegotiationDialog.this.getClientOptions().getSortedColonies(this.player);
            block1: while (coloniesInAgreement.hasNext()) {
                Colony colony = coloniesInAgreement.next();
                for (int i = 0; i < coloniesAvail.size(); ++i) {
                    Colony colonyAvail = coloniesAvail.get(i);
                    if (colonyAvail != colony) continue;
                    coloniesAvail.remove(i);
                    continue block1;
                }
            }
            if (coloniesAvail.isEmpty()) {
                this.addButton.setEnabled(false);
                this.colonyBox.setEnabled(false);
            } else {
                for (Colony c : coloniesAvail) {
                    this.colonyBox.addItem(c);
                }
                for (ActionListener al : listeners) {
                    this.colonyBox.addActionListener(al);
                }
                this.addButton.setEnabled(true);
                this.colonyBox.setEnabled(true);
            }
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                this.negotiationDialog.addColonyTradeItem(this.player, (Colony)this.colonyBox.getSelectedItem());
                NegotiationDialog.this.updateDialog();
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private TradeItem item;

        public RemoveAction(TradeItem item) {
            this.item = item;
        }

        public void actionPerformed(ActionEvent e) {
            NegotiationDialog.this.agreement.remove(this.item);
            NegotiationDialog.this.updateDialog();
        }
    }
}

