/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NationDetailPanel
extends ColopediaGameObjectTypePanel<Nation> {
    public NationDetailPanel(FreeColClient freeColClient, GUI gui, ColopediaPanel colopediaPanel) {
        super(freeColClient, gui, colopediaPanel, ColopediaAction.PanelType.NATIONS.toString(), 0.5);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        ArrayList<Nation> nations = new ArrayList<Nation>();
        nations.addAll(this.getSpecification().getEuropeanNations());
        nations.addAll(this.getSpecification().getIndianNations());
        super.addSubTrees(root, nations);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        Nation nation = this.getSpecification().getNation(id);
        NationType currentNationType = nation.getType();
        for (Player player : this.getGame().getPlayers()) {
            if (player.getNation() != nation) continue;
            currentNationType = player.getNationType();
            break;
        }
        panel.setLayout((LayoutManager)new MigLayout("wrap 3, fillx, gapx 20", "", ""));
        JLabel name = this.localizedLabel(nation.getNameKey());
        name.setFont(smallHeaderFont);
        panel.add((Component)name, "span, align center, wrap 40");
        JLabel artLabel = new JLabel(this.getLibrary().getMonarchImageIcon(nation));
        panel.add((Component)artLabel, "spany, gap 40, top");
        panel.add(this.localizedLabel("colopedia.nation.ruler"));
        panel.add(this.localizedLabel(nation.getRulerNameKey()));
        panel.add(this.localizedLabel("colopedia.nation.defaultAdvantage"));
        panel.add(this.getButton(nation.getType()));
        panel.add(this.localizedLabel("colopedia.nation.currentAdvantage"));
        panel.add((Component)this.getButton(currentNationType), "wrap push");
    }
}

