/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabourData {
    private static final LocationData.Getter UNITS_IN_EUROPE_GETTER = new LocationData.Getter(){

        public LocationData getLocationData(UnitData unitData) {
            return unitData.unitsInEurope;
        }
    };
    private static final LocationData.Getter UNITS_AT_SEA_GETTER = new LocationData.Getter(){

        public LocationData getLocationData(UnitData unitData) {
            return unitData.unitsAtSea;
        }
    };
    private static final LocationData.Getter UNITS_ON_LAND_GETTER = new LocationData.Getter(){

        public LocationData getLocationData(UnitData unitData) {
            return unitData.unitsOnLand;
        }
    };
    private Map<GoodsType, UnitData> experts = new LinkedHashMap<GoodsType, UnitData>();
    private Map<String, UnitData> unitDataMap = new LinkedHashMap<String, UnitData>();
    private UnitData summary = new UnitData(null);
    private UnitData missionary;
    private UnitData pioneer;
    private UnitData soldier;
    private UnitData scout;

    public LabourData(FreeColClient client) {
        Specification spec = client.getGame().getSpecification();
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (!unitType.isAvailableTo(client.getMyPlayer())) continue;
            GoodsType production = unitType.getExpertProduction();
            if (production != null) {
                this.experts.put(production, this.getUnitData(unitType));
            }
            if (unitType.hasAbility("model.ability.expertPioneer")) {
                this.pioneer = this.getUnitData(unitType);
                continue;
            }
            if (unitType.hasAbility("model.ability.expertSoldier")) {
                this.soldier = this.getUnitData(unitType);
                continue;
            }
            if (unitType.hasAbility("model.ability.expertScout")) {
                this.scout = this.getUnitData(unitType);
                continue;
            }
            if (!unitType.hasAbility("model.ability.expertMissionary")) continue;
            this.missionary = this.getUnitData(unitType);
        }
        this.gatherData(client.getMyPlayer());
    }

    private void gatherData(Player player) {
        List<UnitType> labourTypes = LabourData.getLabourTypes(player);
        Iterator<Unit> units = player.getUnitIterator();
        while (units.hasNext()) {
            Unit unit = units.next();
            if (!labourTypes.contains(unit.getType())) continue;
            Location location = unit.getLocation();
            UnitData data = this.getUnitData(unit.getType());
            if (location instanceof WorkLocation) {
                this.incrementColonyCount(location.getColony(), unit, data);
                continue;
            }
            if (location instanceof Europe) {
                this.incrementOutsideWorker(data, unit, UNITS_IN_EUROPE_GETTER);
                continue;
            }
            if (location instanceof Tile && ((Tile)location).getSettlement() != null) {
                this.incrementColonyCount((Colony)((Tile)location).getSettlement(), unit, data);
                continue;
            }
            if (location instanceof Unit) {
                this.incrementOutsideWorker(data, unit, UNITS_AT_SEA_GETTER);
                continue;
            }
            this.incrementOutsideWorker(data, unit, UNITS_ON_LAND_GETTER);
        }
        this.summarize();
        for (UnitData unitData : this.unitDataMap.values()) {
            LocationData total = unitData.getTotal();
            GoodsType expertProduction = unitData.getUnitType().getExpertProduction();
            if (expertProduction == null) continue;
            for (Colony colony : player.getColonies()) {
                LocationData data = unitData.details.containsKey(colony) ? unitData.getLocationData(colony) : null;
                int netProduction = colony.getNetProductionOf(expertProduction);
                if (data != null) {
                    data.netProduction = netProduction;
                }
                total.netProduction += netProduction;
            }
        }
    }

    public static List<UnitType> getLabourTypes(Player player) {
        List<UnitType> unitTypes = player.getSpecification().getUnitTypeList();
        ArrayList<UnitType> labourTypes = new ArrayList<UnitType>();
        for (UnitType unitType : unitTypes) {
            if (!unitType.hasSkill() || !unitType.isAvailableTo(player)) continue;
            labourTypes.add(unitType);
        }
        return labourTypes;
    }

    private void summarize() {
        for (UnitData unitData : this.unitDataMap.values()) {
            this.summarize(unitData, UNITS_IN_EUROPE_GETTER);
            this.summarize(unitData, UNITS_AT_SEA_GETTER);
            this.summarize(unitData, UNITS_ON_LAND_GETTER);
            for (final Colony colony : unitData.details.keySet()) {
                this.summarize(unitData, new LocationData.Getter(){

                    public LocationData getLocationData(UnitData data) {
                        return data.getLocationData(colony);
                    }
                });
            }
        }
    }

    private void summarize(UnitData data, LocationData.Getter getter) {
        LocationData unitLocation = getter.getLocationData(data);
        LocationData summaryLocation = getter.getLocationData(this.summary);
        data.total.add(unitLocation);
        summaryLocation.add(unitLocation);
        this.summary.total.add(unitLocation);
    }

    private void incrementOutsideWorker(UnitData unitData, Unit unit, LocationData.Getter getter) {
        switch (unit.getRole()) {
            case DRAGOON: 
            case SOLDIER: {
                this.incrementOutsideWorker(unitData, unit, this.soldier, getter);
                break;
            }
            case MISSIONARY: {
                this.incrementOutsideWorker(unitData, unit, this.missionary, getter);
                break;
            }
            case PIONEER: {
                this.incrementOutsideWorker(unitData, unit, this.pioneer, getter);
                break;
            }
            case SCOUT: {
                this.incrementOutsideWorker(unitData, unit, this.scout, getter);
                break;
            }
            default: {
                getter.getLocationData(unitData).notWorking++;
            }
        }
    }

    private void incrementOutsideWorker(UnitData expert, Unit unit, UnitData workingAs, LocationData.Getter getter) {
        if (unit.getType() == workingAs.unitType) {
            getter.getLocationData(expert).workingProfessionals.colonists++;
        } else {
            getter.getLocationData(expert).workingAmateurs++;
            getter.getLocationData(workingAs).otherWorkingAmateurs.colonists++;
        }
    }

    private void incrementColonyCount(final Colony colony, Unit unit, UnitData unitData) {
        GoodsType currentlyWorking;
        Location location = unit.getLocation();
        if (!(location instanceof WorkLocation)) {
            this.incrementOutsideWorker(unitData, unit, new LocationData.Getter(){

                public LocationData getLocationData(UnitData data) {
                    return data.getLocationData(colony);
                }
            });
            return;
        }
        WorkLocation wl = (WorkLocation)location;
        LocationData colonyData = unitData.getLocationData(colony);
        Unit teacher = unit.getTeacher();
        if (teacher != null) {
            colonyData.students++;
            UnitData learning = this.getUnitData(Unit.getUnitTypeTeaching(teacher.getType(), unit.getType()));
            learning.getLocationData(colony).addOtherStudent(unitData.getUnitName());
        }
        if (wl.canTeach()) {
            colonyData.teachers++;
        }
        int production = (currentlyWorking = unit.getWorkType()) == null ? 0 : wl.getProductionOf(unit, currentlyWorking);
        UnitData workingAs = this.experts.get(currentlyWorking);
        if (workingAs.getUnitType() == unit.getType()) {
            colonyData.getWorkingProfessionals().addProduction(production);
        } else {
            colonyData.workingAmateurs++;
            workingAs.getLocationData(colony).otherWorkingAmateurs.addProduction(production);
        }
    }

    public UnitData getUnitData(UnitType unitType) {
        UnitData data = this.unitDataMap.get(unitType.getId());
        if (data == null) {
            data = new UnitData(unitType);
            this.unitDataMap.put(unitType.getId(), data);
        }
        return data;
    }

    public UnitData getSummary() {
        return this.summary;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnitData {
        private UnitType unitType;
        private boolean summary = false;
        private Map<Colony, LocationData> details = new LinkedHashMap<Colony, LocationData>();
        private LocationData total = new LocationData(this, true);
        private LocationData unitsAtSea = new LocationData(this);
        private LocationData unitsOnLand = new LocationData(this);
        private LocationData unitsInEurope = new LocationData(this);

        public UnitData(UnitType unitType) {
            this.unitType = unitType;
            if (unitType == null) {
                this.summary = true;
            }
        }

        private LocationData getLocationData(Colony colony) {
            LocationData colonyData = this.details.get(colony);
            if (colonyData == null) {
                colonyData = new LocationData(this);
                this.details.put(colony, colonyData);
            }
            return colonyData;
        }

        public String getUnitName() {
            if (this.isSummary()) {
                return null;
            }
            return Messages.message(this.unitType.getNameKey());
        }

        public boolean hasDetails() {
            return this.getTotal().getRowCount() > 0;
        }

        public int getUnitSummaryRowCount() {
            return Math.max(1, this.getTotal().getRowCount());
        }

        public UnitType getUnitType() {
            return this.unitType;
        }

        public LocationData getTotal() {
            return this.total;
        }

        public LocationData getUnitsAtSea() {
            return this.unitsAtSea;
        }

        public LocationData getUnitsOnLand() {
            return this.unitsOnLand;
        }

        public LocationData getUnitsInEurope() {
            return this.unitsInEurope;
        }

        public Map<Colony, LocationData> getDetails() {
            return this.details;
        }

        public boolean isSummary() {
            return this.summary;
        }

        public boolean showProduction() {
            return !this.summary && this.unitType.getExpertProduction() != null;
        }

        public boolean showNetProduction() {
            return this.showProduction() && this.unitType.getExpertProduction().isStorable();
        }

        public GoodsType getExpertProduction() {
            if (this.summary) {
                return null;
            }
            return this.getUnitType().getExpertProduction();
        }
    }

    public static class LocationData {
        private UnitData unitData;
        private boolean isTotal;
        private ProductionData workingProfessionals = new ProductionData();
        private int workingAmateurs;
        private ProductionData otherWorkingAmateurs = new ProductionData();
        private int netProduction;
        private int teachers;
        private int otherStudents;
        private String otherStudentsName;
        private int students;
        private int notWorking;

        public LocationData(UnitData unitData) {
            this(unitData, false);
        }

        public LocationData(UnitData unitData, boolean total) {
            this.unitData = unitData;
            this.isTotal = total;
        }

        public int getOtherStudents() {
            return this.otherStudents;
        }

        public String getOtherStudentsName() {
            return this.otherStudentsName;
        }

        public void addOtherStudent(String name) {
            ++this.otherStudents;
            this.otherStudentsName = name;
        }

        public ProductionData getWorkingProfessionals() {
            return this.workingProfessionals;
        }

        public ProductionData getOtherWorkingAmateurs() {
            return this.otherWorkingAmateurs;
        }

        public int getNetProduction() {
            return this.netProduction;
        }

        public int getTotalColonists() {
            return this.workingAmateurs + this.workingProfessionals.getColonists() + this.notWorking + this.teachers + this.otherStudents - this.students;
        }

        public int getTotalProduction() {
            return this.workingProfessionals.getProduction() + this.otherWorkingAmateurs.getProduction();
        }

        public int getRowCount() {
            boolean isSummary = this.getUnitData().isSummary();
            int rows = 0;
            if (this.workingProfessionals.getColonists() > 0) {
                ++rows;
            }
            if (this.workingAmateurs > 0) {
                ++rows;
            }
            if (!isSummary && this.otherWorkingAmateurs.getColonists() > 0) {
                ++rows;
            }
            if (this.teachers > 0) {
                ++rows;
            }
            if (this.students > 0) {
                ++rows;
            }
            if (!isSummary && this.otherStudents > 0) {
                ++rows;
            }
            if (this.notWorking > 0) {
                ++rows;
            }
            return rows;
        }

        public boolean isTraining() {
            return this.teachers > 0 || this.students > 0 || this.otherStudents > 0;
        }

        public int getWorkingAmateurs() {
            return this.workingAmateurs;
        }

        public int getTeachers() {
            return this.teachers;
        }

        public int getStudents() {
            return this.students;
        }

        public int getNotWorking() {
            return this.notWorking;
        }

        public UnitData getUnitData() {
            return this.unitData;
        }

        public boolean isTotal() {
            return this.isTotal;
        }

        private void add(LocationData data) {
            this.workingProfessionals.add(data.workingProfessionals);
            this.workingAmateurs += data.workingAmateurs;
            this.otherWorkingAmateurs.add(data.otherWorkingAmateurs);
            this.teachers += data.teachers;
            this.students += data.students;
            this.otherStudents += data.otherStudents;
            this.notWorking += data.notWorking;
            if (data.otherStudents > 0) {
                this.otherStudentsName = data.otherStudentsName;
            }
        }

        public static interface Getter {
            public LocationData getLocationData(UnitData var1);
        }
    }

    public static class ProductionData {
        private int colonists;
        private int production;

        public void addProduction(int production) {
            this.colonists = this.getColonists() + 1;
            this.production = this.getProduction() + production;
        }

        public int getColonists() {
            return this.colonists;
        }

        public int getProduction() {
            return this.production;
        }

        private void add(ProductionData data) {
            this.colonists += data.colonists;
            this.production += data.production;
        }
    }
}

